<?php defined('\ABSPATH') || exit; ?>
<div class="wrap">
    <h2><?php _e('Help', 'affegg'); ?></h2>

    <hr>

    <?php if (!in_array(\get_locale(), array('ru_RU', 'uk'))) return; ?>

    <p>
        Это сокращенный мануал по работе с плагином. 
        Полное руководство пользователя находится <a href="http://www.keywordrush.com/manuals/affegg_manual.pdf">здесь</a>.
    </p>
    <hr>
    <h3>Создание витрин</h3>

    <p>Витрины - это списки url товаров, которые потом будут добавлены в посты или страницы. Необходимо просто открыть страницу с интересующим вас товаром или раздел магазина в браузере и скопировать url из адресной строки в список витрины. Список всех поддерживаемых магазинов можно найти на странице "Настройка Deeplink”.</p>

    <p>
        Вы можете добавлять в витрину url несольких видов:
    <ol>
        <li>url конкретных товаров,</li>
        <li>url каталогов или разделов сайта,</li>
        <li>url любого изображения.</li>
    </ol>
    Во втором случаи в витрину будут добавлены все товары со страницы каталога.
    Используйте специальный синтаксис, чтобы обозначить url каталога, например:
</p>

<code>[catalog limit=10]http://supershop.com/super-catalog</code>

<p>Параметр limit=10 указывает на максимальное количество товаров, которое необходимо  получить из каталога.</p>
<p>Вы можете комбинировать различные виды url, а также url  из разных магазинов в одной витрине.</p>
<p>
    Посмотрите <a href="https://www.youtube.com/watch?v=n1MLjX9BreY ">видео</a>, демонстрирующее создание витрин.
</p>


<h3>Добавление витрин в записи и на страницы</h3>
<p>Чтобы вставить витрину на страницу или в пост, скопируйте ее шорткод [affegg id=ID] и в редакторе вставьте его в место, где должны отображаться товары. Каждая витрина имеет уникальный цифровой идентификатор (ID), который необходимо указать в шорткоде. Например, шорт-код:</p>

<code>[affegg id=10]</code>

<p>Добавит в пост витрину с ID равным 10.</p>

<p>
    Вы можете воспользоваться специальной кнопкой "Добавить витрины" в редакторе Wordpress, чтобынайти нужную витрину в списке и добавить её шорткод в текст поста.    
</p>

<p>Существует возможность выводить товары витрины частями, для этого используйте специальные параметры шор-кода.
    Например, код:</p>

<code>[affegg id=10 next=3]</code>

<p>выведит первые 3 товара из витрины. Повторное использование кода:</p>

<code>[affegg id=10 next=3]</code>

<p>в пределах этого же поста, выведит следующие 3 товара этой витрины.</p>

<p>Используйте специальный параметр limit для ограничения количества товаров при выводе витрины. Если при этом задать параметр offset, то он будет указывать на начало первого возвращаемого товара. Нумерация товаров начинается с нуля.
    Например:</p>
<code>[affegg id=10 offset=5 limit=3]</code>
<p>выведит три товара начиная с пятого.</p>


<p>Для сортировки товаров при выводе витрины, используйте специальный параметр order=<поле>, например:</p>

<code>[affegg id=10 order=price]</code>

<p>отсортирует товары витрины по цене, начиная с наименьшей.</p>

<p>Порядок сортировки изменен на противоположный - от большего к меньшему:</p>
<code>[affegg id=10 order="price desc"]</code>

<p>Поля по которым возможна сортировка товаров: </p>
<code>'title', 'price', 'manufacturer', 'in_stock', 'create_date', 'last_update', 'last_in_stock', 'shop_id'.</code>

<p>При каждом обновлении страницы выведет товары витрины в случайном порядке:</p>
<code>[affegg id=10 order=rand]</code>

<h3>Настройка Deeplink</h3>

<p>Чтобы получать партнерское вознаграждение за переходы и продажи по ссылкам на товары, необходимо задать Deeplink одной из CPA-сетей для каждого магазна на странице "Настройка Deeplink".</p>
<p>В разных партнерских сетях механизм Deeplink может называться по-разному, но суть его в том, что вы можете отправить посетителя через свою партнерскую ссылку на любую страницу интернет-магазина.</p>
<p>Вы должны задать начальную часть от полного Deeplink, а фактически url магазина для перехода будет подставлен автоматически в конец этой ссылки. Например, для admitad, настройка Deeplink может выглядеть:</p>
<code>http://ad.admitad.com/goto/15306de4d3a449b23ea14c242c2a90/?ulp=</code>
<p>Непосредственно на блоге ссылки будет выглядеть:</p>
<code>http://ad.admitad.com/goto/15306de4d3a449b23ea14c242c2a90/?ulp=[тут будет подставлен url товара]</code>

<p>Вы также можете монетизировать трафик через "родные" партнерские программы магазинов. Для этого задайте свой партнерский идентификатор, который будет добавлен ко всем ссылкам на магазин, например: 
    <br><em>partner_id=12345</em>
</p>


<h4>Настройка Deeplink для Admitad</h4>
<p>Перейдите "Программы" -> "Мои программы", зайдите в партнерскую программу соответствующего магазина. Далее перейдите "Рекламные материалы" -> "Deeplink" и скопируйте ссылку в поле "Новая рекламная ссылка".</p>

<h4>Настройка Deeplink для Где слон?</h4>
<p>Перейдите "Инструменты" -> "Вольные ссылки", нажмите кнопку "Создать вольную ссылку". Затем выберите рекламодателя и опцию "Динамический адрес перехода" и сохраните ссылку. (Если при сохранении вольной ссылки возникает ошибка, впишите в поле "Адрес" адрес главной страницы магазина).</p>

<h4>Настройка Deeplink для Actionpay</h4>
<p>Перейдите "Мои офферы" и нажмите кнопку "Получить ссылки" возле соответствующего оффера. Deeplink ссылка находится в конце списка.</p>

<h4>Настройка Deeplink для CityAds</h4>
<p>Перейдите "Офферы" -> "Список офферов", зайдите в соответствующий оффер. Далее перейдите "Инструменты" -> "Ссылки" и скопируйте ссылку в поле "Стандартная".</p>

<h3>Автоматическое обновление товаров и каталогов</h3>
<p>Чтобы данные всегда оставались в актуальном состоянии, Affiliate Egg плагин будет периодически обновлять данные по ценам, наличию товара, а также обновлять списки товаров из каталогов. Задать периодичность проверки или отключить эту опцию можно на странице "Опции".</p>
<p>Для запуска механизма обновления используется стандартный механизм Wordpress Cron, который работает только при наличии трафика на сайте.</p>

<h3>Автоматическое обновление плагина</h3>
<p>Если ваша подписка на обновления плагина активна, вы будете получать уведомления или автоматические апдейты Affiliate Egg через стандартные механизмы обновлений Wordpress. Вы можете обновить плагин прямо из админ-панели Wordpress или вручную скачав архив с плагином.</p>

<h3>Виджеты</h3>
<p>Affiliate Egg плагин добавляет в вашу Wordpress тему специальный виджет для отображения товаров витрин. Добавить виджет AffiliateEgg в сайдбар и настроить его внешний вид вы можете на стандартной странице <em>Внешний вид → Виджеты</em>.</p>


<h3>Автоблоггинг</h3>
<p>С помощью автоблоггинга вы можете настроить автоматическое создание постов с товарами. Для задания автоблоггинга используйте URL каталога магазина с обновляемым списком товаров, например, раздел "новинки". Периодически будут создаваться Affiliate Egg Витрины из новых товаров, а также новые посты в блоге с этими витринами. </p>

<h3>Пользовательские шаблоны</h3>

<p>При автоматическом обновлении плагина удаляются и перезаписываются все файлы в директории плагина. Поэтому предусмотрена специальная директория, в которой вы можете хранить свои собственные шаблоны для витрин: <em>wp-content/affegg-templates</em>. </p>

<p>Все шаблоны для витрин обязательно должны начинаться с пефикса <em>egg_</em>, например:</p>
<code>egg_mysupertemplate.php</code>
<p>В первых строчках файла шаблона вы можете задать имя шаблона:</p>
<code>
    &lt;?php<br>
    /*<br>
    Name: Мой новый шаблон<br>
    */<br>
    ?&gt;
</code>
<p>Файлы шаблона должны быть в utf-8 кодировке.</p>
<p>Шаблоны для виджетов создаются аналогично, единственное отличие — перфикс файлы должен быть <em>wegg_</em>.</p>


</div>