<?php
defined('\ABSPATH') || exit;
/*
  Name: Tile (3 columns)
 */
__('Tile (3 columns)', 'affegg-tpl');
?>

<?php wp_enqueue_style('egg-bootstrap'); ?>
<div class="egg-container egg-grid">
    <div class="container-fluid">

        <div class="row">
            <?php foreach ($items as $i => $item): ?>
                <div class="col-xs-4 cegg-gridbox"> 
                    <a rel="nofollow" target="_blank" href="<?php echo esc_url($item['url']) ?>" class="thumbnail"<?php echo $item['ga_event'] ?>>

                        <?php if ($item['img']): ?>
                            <img src="<?php echo esc_attr($item['img']) ?>" alt="<?php echo esc_attr($item['title']); ?>" />
                        <?php else: ?>
                            <?php echo esc_html($item['title']); ?><?php if ($item['manufacturer']): ?>, <?php echo esc_html($item['manufacturer']); ?><?php endif; ?>                                
                        <?php endif; ?>
                    </a>

                </div>
                <?php
                if (($i + 1) % 3 == 0)
                    echo '<div class="clearfix"></div>';
                ?>
            <?php endforeach; ?>
        </div>    
    </div>    
</div>
