<?php

/**
Plugin Name: Cookie Info
Plugin URI: http://danielpaul.me/projects/cookieinfo/
Description: Beautiful & Functional Cookie Compliance Script. Cookie Compliance is an EU law - Inform your visitors in an elegant manner.
Author: Daniel Paul
Author URI: http://danielpaul.me/
Version: 1.4


 ---------------------------------------------------------------------------------

      ___          ___          ___          ___                     ___
    /  /\        /  /\        /  /\        /__/|       ___         /  /\
   /  /:/       /  /::\      /  /::\      |  |:|      /  /\       /  /:/_
  /  /:/       /  /:/\:\    /  /:/\:\     |  |:|     /  /:/      /  /:/ /\
 /  /:/  ___  /  /:/  \:\  /  /:/  \:\  __|  |:|    /__/::\     /  /:/ /:/_
/__/:/  /  /\/__/:/ \__\:\/__/:/ \__\:\/__/\_|:|____\__\/\:\__ /__/:/ /:/ /\
\  \:\ /  /:/\  \:\ /  /:/\  \:\ /  /:/\  \:\/:::::/   \  \:\/\\  \:\/:/ /:/
 \  \:\  /:/  \  \:\  /:/  \  \:\  /:/  \  \::/~~~~     \__\::/ \  \::/ /:/
  \  \:\/:/    \  \:\/:/    \  \:\/:/    \  \:\         /__/:/   \  \:\/:/
   \  \::/      \  \::/      \  \::/      \  \:\        \__\/     \  \::/
    \__\/        \__\/        \__\/        \__\/                   \__\/
                ___          ___       ___
   ___         /__/\        /  /\     /  /\
  /  /\        \  \:\      /  /:/_   /  /::\
 /  /:/         \  \:\    /  /:/ /\ /  /:/\:\
/__/::\     _____\__\:\  /  /:/ /://  /:/  \:\        by Daniel Paul
\__\/\:\__ /__/::::::::\/__/:/ /://__/:/ \__\:\       [www.danielpaul.me]
   \  \:\/\\  \:\~~\~~\/\  \:\/:/ \  \:\ /  /:/
    \__\::/ \  \:\  ~~~  \  \::/   \  \:\  /:/
    /__/:/   \  \:\       \  \:\    \  \:\/:/
    \__\/     \  \:\       \  \:\    \  \::/
               \__\/        \__\/     \__\/


 ---------------------------------------------------------------------------------

 */

require_once dirname( __FILE__ ) . '/inc/class.settings-api.php';

class CookieInfo_Settings {

    private $settings_api;

    function load_scripts() {
        wp_register_style('cookieinfo', plugins_url('css/cookieinfo.css', __FILE__), array(), '1.0');
        wp_enqueue_style('cookieinfo');
 
        wp_register_script('cookieinfo', plugins_url( 'js/CookieInfo.js', __FILE__), array('jquery'), '1.0', true);
        wp_enqueue_script('jquery');
        wp_enqueue_script('cookieinfo');
    }

    function __construct() {
        $this->settings_api = WeDevs_Settings_API_DP::getInstance();

        add_action( 'admin_init', array($this, 'admin_init') );
        add_action( 'admin_menu', array($this, 'admin_menu') );

         add_action('init', array($this, 'load_scripts'));
    }

    function admin_init() {

        //set the settings
        $this->settings_api->set_sections( $this->get_settings_sections() );
        $this->settings_api->set_fields( $this->get_settings_fields() );

        //initialize settings
        $this->settings_api->admin_init();
    }

    function admin_menu() {
        add_options_page( 'Cookie Info', 'Cookie Info', 'install_plugins', 'cookieinfo', array($this, 'plugin_page') );
    }

    function get_settings_sections() {
        $sections = array(
            array(
                'id' => 'cookieinfo_basics',
                'title' => __( 'Basic Settings', 'cookieinfo' )
            ),
            array(
                'id' => 'cookieinfo_advanced',
                'title' => __( 'Advanced Settings', 'cookieinfo' )
            )
        );
        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    function get_settings_fields() {
        $settings_fields = array(
            'cookieinfo_basics' => array(
                array(
                    'name' => 'defaulttext',
                    'label' => __( 'Default info text', 'cookieinfo' ),
                    'desc' => __( 'Short information that is shown to the user about your use of cookies.', 'cookieinfo' ),
                    'type' => 'textarea',
                    'default' => __('We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.')
                ),
                array(
                    'name' => 'okbuttontext',
                    'label' => __( 'Confirmation button Text', 'cookieinfo' ),
                    'type' => 'text',
                    'default' => __('Ok')
                ),
                array(
                    'name' => 'position',
                    'label' => __( 'Position', 'cookieinfo' ),
                    'type' => 'radio',
                    'options' => array(
                        'bottom' => 'Bottom',
                        'top' => 'Top'
                    ),
                    'default' => 'bottom'
                ),
                array(
                    'name' => 'style',
                    'label' => __( 'Style', 'cookieinfo' ),
                    'type' => 'select',
                    'options' => array(
                        'dark' => 'Dark',
                        'light' => 'Light'
                    ),
                    'default' => 'dark'
                ),
                array(
                    'name' => 'displaymore',
                    'label' => __( 'More information section', 'cookieinfo' ),
                    'type' => 'radio',
                    'options' => array(
                        'true' => 'Show',
                        'false' => 'Hide'
                    ),
                    'default' => 'true'
                ),
                array(
                    'name' => 'morebuttontext',
                    'label' => __( 'More button text', 'cookieinfo' ),
                    'type' => 'text',
                    'default' => __('More Info')
                ),
                array(
                    'name' => 'moretext',
                    'label' => __( 'More information', 'cookieinfo' ),
                    'desc' => __( 'A more detailed description of why you use cookies on your site.', 'cookieinfo' ),
                    'type' => 'textarea',
                    'default' => __('Cookies are small text files held on your computer. Some cookies are required to ensure that the site functions correctly, for this reason we may have already set some cookies. They also allow us to give you the best browsing experience possible and help us understand how you use our site.')
                ),
                array(
                    'name' => 'moreurl',
                    'label' => __( 'More information URL', 'cookieinfo' ),
                    'desc' => __( 'Add an URL here to disable the more information slider and redirect the user to a webpage. Leave blank to use the more information slider instead.', 'cookieinfo' ),
                    'type' => 'text',
                    'default' => ''
                ),
            ),
            'cookieinfo_advanced' => array(
                array(
                    'name' => 'sticky',
                    'label' => __( 'Fixed or not?', 'cookieinfo' ),
                    'desc' => __( 'Fixed makes the cookie info banner visible when the user scrolls down.', 'cookieinfo' ),
                    'type' => 'radio',
                    'options' => array(
                        'true' => 'Fixed',
                        'false' => 'Absolute'
                    ),
                    'default' => 'true'
                ),
                /* array(
                    'name' => 'makespace',
                    'label' => __( 'Make space for the cookie bar?', 'cookieinfo' ),
                    'desc' => __( 'This will push your HTML body up or down so that the info banner does not obstruct any other content on your page.', 'cookieinfo' ),
                    'type' => 'checkbox',
                    'default' => 'off'
                ), */
                array(
                    'name' => 'delay',
                    'label' => __( 'Display delay', 'cookieinfo' ),
                    'desc' => __( 'Milliseconds. Set time delay in seconds to show the user the cookie info banner.', 'cookieinfo' ),
                    'type' => 'number',
                    'default' => '1000'
                ),
                array(
                    'name' => 'speedin',
                    'label' => __( 'Animation speed in', 'cookieinfo' ),
                    'desc' => __( 'Animation speed in seconds.', 'cookieinfo' ),
                    'type' => 'number',
                    'default' => '500'
                ),
                array(
                    'name' => 'speedout',
                    'label' => __( 'Animation speed out', 'cookieinfo' ),
                    'desc' => __( 'Animation speed in seconds.', 'cookieinfo' ),
                    'type' => 'number',
                    'default' => '400'
                ),
                array(
                    'name' => 'cookiename',
                    'label' => __( 'Cookie Name', 'cookieinfo' ),
                    'desc' => __( 'Name of the cookie that is set so that the user does not see this banner again once they have accepted.', 'cookieinfo' ),
                    'type' => 'text',
                    'default' => 'CookieInfo'
                ),
                array(
                    'name' => 'cookieexpiry',
                    'label' => __( 'Cookie Expiry', 'cookieinfo' ),
                    'desc' => __( 'Days. When to show the cookie info banner again to the same user.', 'cookieinfo' ),
                    'type' => 'number',
                    'default' => '90'
                ),
            )
        );

        return $settings_fields;
    }

    function plugin_page() {
        echo '<div class="wrap">';
        echo '<div id="icon-plugins" class="icon32"><br></div><h2><strong>Cookie Info</strong> - The Beautiful & Functional
Cookie Compliance Script</h2><br />';

        // settings_errors();

        $this->settings_api->show_navigation();
        $this->settings_api->show_forms();

        echo '</div>';
        echo '<p><a href="http://danielpaul.me/projects/cookieinfo/" target="_blank">Cookie Info</a> Wordpress and jQuery plugin &copy; <a href="http://danielpaul.me/" target="_blank">Daniel Paul</a>. Available for purchase at <a href="http://codecanyon.net/user/DanielPaul?ref=DanielPaul" target="_blank">CodeCanyon.net</a>.</p>';

    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function get_pages() {
        $pages = get_pages();
        $pages_options = array();
        if ( $pages ) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }

        return $pages_options;
    }

}

$settings = new CookieInfo_Settings();

/**
 * Get the value of a settings field
 *
 * @param string $option settings field name
 * @param string $section the section name this field belongs to
 * @param string $default default text if it's not found
 * @return mixed
 */
function cookieinfo_option( $option, $section, $default = '' ) {

    $options = get_option( $section );

    if ( isset( $options[$option] ) ) {
        return $options[$option];
    }

    return $default;
}

/**
 * Output style and scripts
 */


function cookieinfo_script(){ ?>
  <script type="text/javascript">
    jQuery(document).ready(function(){
      jQuery().cookieInfo({
        defaultText: "<?php echo cookieinfo_option( 'defaulttext', 'cookieinfo_basics', __('We use cookies to improve your experience on our website. By browsing this website, you agree to our use of cookies.') ); ?>",
        okButton: "<?php echo cookieinfo_option( 'okbuttontext', 'cookieinfo_basics', __('Ok') ); ?>",
        displayMore: <?php echo cookieinfo_option('displaymore', 'cookieinfo_basics', 'true'); ?>,
        moreButton: "<?php echo cookieinfo_option( 'morebuttontext', 'cookieinfo_basics', __('More Info') ); ?>",
        moreInfo: "<?php echo cookieinfo_option( 'moretext', 'cookieinfo_basics', __('Cookies are small text files held on your computer. Some cookies are required to ensure that the site functions correctly, for this reason we may have already set some cookies. They also allow us to give you the best browsing experience possible and help us understand how you use our site.') ); ?>",
        moreURL:  "<?php echo cookieinfo_option( 'moreurl', 'cookieinfo_basics', __('') ); ?>",
        location: "<?php echo cookieinfo_option( 'position', 'cookieinfo_basics', 'bottom' ); ?>",
        speedIn: <?php echo cookieinfo_option( 'speedin', 'cookieinfo_advanced', '500' ); ?>,
        speedOut: <?php echo cookieinfo_option( 'speedout', 'cookieinfo_advanced', '400' ); ?>,
        delay: <?php echo cookieinfo_option( 'delay', 'cookieinfo_advanced', '1000' ); ?>,
        float: <?php echo cookieinfo_option('sticky', 'cookieinfo_advanced', 'true'); ?>,
        style: "<?php echo cookieinfo_option( 'style', 'cookieinfo_basics', 'dark' ); ?>",
        cookieExpiry: <?php echo cookieinfo_option( 'cookieexpiry', 'cookieinfo_advanced', '90' ); ?>,
        cookieName: "<?php echo cookieinfo_option( 'cookiename', 'cookieinfo_advanced', 'CookieInfo' ); ?>"
      });
    });
  </script>
<?php }

add_action('wp_footer', 'cookieinfo_script');


/**
 * Prevent Wordpress from auto checking updates for this plugin
 */

function cookieinfo_updatecheck( $r, $url ) {
    if ( 0 !== strpos( $url, 'http://api.wordpress.org/plugins/update-check' ) )
        return $r; // Not a plugin update request. Bail immediately.
    $plugins = unserialize( $r['body']['plugins'] );
    unset( $plugins->plugins[ plugin_basename( __FILE__ ) ] );
    unset( $plugins->active[ array_search( plugin_basename( __FILE__ ), $plugins->active ) ] );
    $r['body']['plugins'] = serialize( $plugins );
    return $r;
}
add_filter( 'http_request_args', 'cookieinfo_updatecheck', 5, 2 );


/* ================================================== /


   ____                                 ___
  /\  _`\                    __        /\_ \
  \ \ \/\ \     __      ___ /\_\     __\//\ \
   \ \ \ \ \  /'__`\  /' _ `\/\ \  /'__`\\ \ \
    \ \ \_\ \/\ \L\.\_/\ \/\ \ \ \/\  __/ \_\ \_
     \ \____/\ \__/.\_\ \_\ \_\ \_\ \____\/\____\
      \/___/  \/__/\/_/\/_/\/_/\/_/\/____/\/____/


   ____                   ___
  /\  _`\                /\_ \
  \ \ \L\ \ __     __  __\//\ \      -=[ (c) 2013 Daniel Paul ]=-
   \ \ ,__/'__`\  /\ \/\ \ \ \ \
    \ \ \/\ \L\.\_\ \ \_\ \ \_\ \_     Do NOT duplicate or steal!
     \ \_\ \__/.\_\\ \____/ /\____\
      \/_/\/__/\/_/ \/___/  \/____/


  Hi there curious person! You are viewing the source code of my wordpress plugin.
  Hope you are not trying to steal anything ... :|

  Feel free to learn, analyze and/or use the techniques used in my plugin...

  * If you need any help modifying this plugin, please contact me via my codecanyon page.
  * I'll be happy to help... :)
  * http://codecanyon.net/users/DanielPaul?ref=DanielPaul



/ ================================================== */
