<?php
add_action( 'admin_menu', 'hashbar_wpnbp_add_admin_menu' );
add_action( 'admin_init', 'hashbar_wpnbp_settings_init' );


function hashbar_wpnbp_add_admin_menu(  ) { 

	add_submenu_page( 'edit.php?post_type=wphash_ntf_bar', 'HashBar Options', 'HashBar Options', 'manage_options', 'hashbar_options_page', 'hashbar_wpnbp_options_page' );

}


function hashbar_wpnbp_settings_init(  ) { 

	register_setting( 'options_group_1', 'hashbar_wpnbp_opt' );

	add_settings_section(
		'hashbar_wpnbp_options_group_1_section', 
		'', 
		null, 
		'options_group_1'
	);

	add_settings_field( 
		'dont_show_bar_after_close', 
		__( 'Don\'t Show Notification After Close', 'hashbar' ), 
		'hashbar_wpnbp_checkbox_render', 
		'options_group_1', 
		'hashbar_wpnbp_options_group_1_section' 
	);

	add_settings_field( 
		'mobile_device_breakpoint', 
		__( 'Mobile device breakpoint (px)', 'hashbar' ), 
		'hashbar_wpnbp_text_render', 
		'options_group_1', 
		'hashbar_wpnbp_options_group_1_section' 
	);

	// posts_limit
	add_settings_field( 
		'posts_limit', 
		__( 'Limit Posts List', 'hashbar' ), 
		'hashbar_wpnbp_posts_limit_render', 
		'options_group_1', 
		'hashbar_wpnbp_options_group_1_section' 
	);

	// pages_limit
	add_settings_field( 
		'pages_limit', 
		__( 'Limit Pages List', 'hashbar' ), 
		'hashbar_wpnbp_pages_limit_render', 
		'options_group_1', 
		'hashbar_wpnbp_options_group_1_section' 
	);

}


function hashbar_wpnbp_checkbox_render(  ) { 

	$options = get_option( 'hashbar_wpnbp_opt' );
	$checkbox_val = isset($options['dont_show_bar_after_close']) ? $options['dont_show_bar_after_close'] : '';
	?>
	<input type='checkbox' name='hashbar_wpnbp_opt[dont_show_bar_after_close]'  <?php checked($checkbox_val, 1) ?> value='1'>
	<p class="description">If check this option. The notification will not apprear again in a page, after closing the notification.</p>
	<?php

}

function hashbar_wpnbp_text_render(  ) { 

	$options = get_option( 'hashbar_wpnbp_opt' );
	$text_val = isset($options['mobile_device_breakpoint']) ? $options['mobile_device_breakpoint'] : '';
	?>
	<input type='text' name='hashbar_wpnbp_opt[mobile_device_breakpoint]' value="<?php echo esc_attr($text_val); ?>">
	<p class="description">Sets the breakpoint between mobile and desktop devices. Below this breakpoint mobile layout will appear (Default: 767).</p>
	<?php

}

function hashbar_wpnbp_posts_limit_render(  ) { 

	$options = get_option( 'hashbar_wpnbp_opt' );
	$text_val = isset($options['posts_limit']) ? $options['posts_limit'] : '';
	?>
	<input type='number' name='hashbar_wpnbp_opt[posts_limit]' value="<?php echo esc_attr($text_val); ?>" min="-1">
	<p class="description">Default:10 . -1 Means unlimited. If your site has larger number of posts, It is recommended not to laod larger amount of posts in notification bar options. Otherwise it will occour an memory error of loading posts.</p>
	<?php

}

function hashbar_wpnbp_pages_limit_render(  ) { 

	$options = get_option( 'hashbar_wpnbp_opt' );
	$text_val = isset($options['pages_limit']) ? $options['pages_limit'] : '';
	?>
	<input type='number' name='hashbar_wpnbp_opt[pages_limit]' value="<?php echo esc_attr($text_val); ?>" min="-1">
	<p class="description">Default:10 . -1 Means unlimited. If your site has larger number of pages, It is recommended not to laod larger amount of posts in notification bar options. Otherwise it will occour an memory error of loading posts</p>
	<?php

}


function hashbar_wpnbp_options_page(  ) { 

	?>
	<form action='options.php' method='post'>

		<h2><?php echo esc_html__( 'HashBar Pro Global Options', 'hashbar' ) ?></h2>

		<?php
		settings_fields( 'options_group_1' );
		do_settings_sections( 'options_group_1' );
		submit_button();
		?>

	</form>
	<?php

}

?>