(function( $ ) {
	'use strict';

	$(function() {

		$(document).on('click', '.nav-tab', function(e){
			e.preventDefault();
			var $this = $(this),
				target = $this.attr('href');
			if ( !$this.hasClass('nav-tab-active') ) {
				$('.nav-tab.nav-tab-active').removeClass('nav-tab-active');
				$('.tab-content.active').removeClass('active');
				
				$this.addClass('nav-tab-active');
				target.replace('#', '');
				$(target).addClass('active');
			}
		});

		// Checkbox toggles
		function wpipaCheckboxToggles( el ) {
			var $this = el,
				targetSelector = '[data-checkbox="'+$this.attr('id')+'"]';
			if ( $this.prop('checked') ) {
				$( targetSelector ).closest('.form-field').addClass('active').removeClass('hidden');
			} else {
				$( targetSelector ).closest('.form-field').addClass('hidden').removeClass('active');
			}
		}

		$('.wpipa-checkbox-toggle').each(function() {
			wpipaCheckboxToggles( $(this) );
		});
		
		$(document).on('change', '.wpipa-checkbox-toggle', function(e) {
			wpipaCheckboxToggles( $(this) );
		});

		// Select which shows/hides options based on its value
		function wpipaShowHideChildOptions( el ) {
			var $this = $(el),
				tempValue = $this.val(),
				targetSelector = '[data-parent-select-id="'+$this.attr('id')+'"]',
				activeSelector = '[data-parent-select-value="'+tempValue+'"]';

			$( targetSelector ).closest('.wpipa-select-child').removeClass('wpipa-active');

			if ( tempValue && activeSelector ) {

				$( activeSelector ).closest('.wpipa-select-child').addClass('wpipa-active');
			}
		}

		$('select.wpipa-has-child-opt').each(function() {
			wpipaShowHideChildOptions( $(this) );
		});

		$(document).on('change', 'select.wpipa-has-child-opt', function(e) {
			wpipaShowHideChildOptions( $(this) );
		});

		/*function wpipaShowHideInsideChildOptions( el ) {
			var $this = $(el),
				tempValue = $this.val(),
				targetSelector = '[data-parent-inside-select-id="'+$this.attr('id')+'"]',
				activeSelector = '[data-parent-inside-select-value="'+tempValue+'"]';

			$( targetSelector ).closest('.form-field').addClass('hidden').removeClass('active');

			if ( tempValue && activeSelector ) {

				$( activeSelector ).closest('.form-field').addClass('active').removeClass('hidden');
			}
		}

		$('select.wpipa-has-child-opt-inside').each(function() {
			wpipaShowHideInsideChildOptions( $(this) );
		});

		$(document).on('change', 'select.wpipa-has-child-opt-inside', function(e) {
			wpipaShowHideInsideChildOptions( $(this) );
		});*/

		// Color Picker
		$('.wpipa-color-picker').wpColorPicker();


		$(document).on( 'click', '.wpipa-enable-split-test', function(e) {

			e.preventDefault();

			var $this = $(this);

			if ( $this.hasClass('active') ) {
				$('.wpipa-b-option').val('');
				$this.text(adminVars.enable_test).removeClass('active');
				$('.wpipa-ab').removeClass('active');
				$('.wpipa-reset-split-test').removeClass('show');
				
			} else {
				$('.wpipa-b-option').val('1');
				$this.text(adminVars.disable_test).addClass('active');
				$('.wpipa-ab').addClass('active');
				$('.wpipa-reset-split-test').addClass('show');
			}
		});

		$(document).on( 'click', '.wpipa-reset-split-test', function(e) {

			e.preventDefault();

			var $this = $(this),
				ad_id = $this.attr('data-ad-id');

			$this.prop( "disabled", true );

			var data = {
				'action': 'wpipa_reset_ab_stats',
				'ad_id': ad_id
			};
			
			$.post( ajaxurl, data, function( response ) {

				$('#wpipa-test-stats-a').html( response );
				$('#wpipa-test-stats-b').html( response );

				$this.prop( "disabled", false );
			});
		});

		var slideraVal = $('.wpipa-ab-slider-a-option').val();
		var sliderbVal = $('.wpipa-ab-slider-b-option').val();

		$('.wpipa-ab-slider').slider();

		$('.wpipa-ab-slider-a').slider({
			value: slideraVal,
			min: 1,
			max: 99,
			slide: function(event, ui) {
				$('.wpipa-a-slider-num').text(ui.value);
				$('.wpipa-ab-slider-a-option').val(ui.value);

				$('.wpipa-ab-slider-b').slider( "option", "value", 100 - ui.value );
				$('.wpipa-b-slider-num').text( 100 - ui.value);
				$('.wpipa-ab-slider-b-option').val( 100 - ui.value);
			}
		});

		$('.wpipa-ab-slider-b').slider({
			value: sliderbVal,
			min: 1,
			max: 99,
			slide: function(event, ui) {
				$('.wpipa-b-slider-num').text(ui.value);
				$('.wpipa-ab-slider-b-option').val(ui.value);

				$('.wpipa-ab-slider-a').slider( "option", "value", 100 - ui.value );
				$('.wpipa-a-slider-num').text( 100 - ui.value);
				$('.wpipa-ab-slider-a-option').val( 100 - ui.value);
			}
		});
	});

	//$( window ).load(function() {
	//});

})( jQuery );