<?php
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
/**
 * Fired during plugin activation
 *
 * @link       https://mythemeshop.com
 * @since      1.0
 *
 * @package    wp-in-post-ads
 * @subpackage wp-in-post-ads/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0
 * @package    wp-in-post-ads
 * @subpackage wp-in-post-ads/includes
 * @author     MyThemeShop
 */
class WP_In_Post_Ads_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0
	 */
	public static function activate() {

		if ( false == get_option( 'wpipa_inside_post_ads' ) ) {

			add_option( 'wpipa_inside_post_ads', array() );
		}

		if ( false == get_option( 'wpipa_ads_view_count' ) ) {

			add_option( 'wpipa_ads_view_count', array() );
		}
	}
}
