<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Rakit\Validation\Validator;

class smpush_controller extends smpush_helper {
  public static $apisetting;
  public static $defconnection;
  public static $pushdb;
  public static $firebase;
  public static $history;
  public static $data;
  public static $platforms = array('ios','iosfcm','android','wp','wp10','bb','chrome','safari','firefox','opera','edge','samsung','fbmsn','fbnotify','email','viber');
  public static $webPlatforms = array('chrome','safari','firefox','opera','edge','samsung');
  public static $mobilePlatforms = array('ios','iosfcm','android','wp','wp10','bb');
  public static $platform_titles = array('iOS','iOS FCM','Android','Windows Phone','Windows 10','BlackBerry','Chrome','Safari','Firefox','Opera','Edge','Samsung Browser','Messenger','FB Notifications','Newsletter','Viber');

  public function __construct(){
    $this->plugin_bootstrap();
    $this->set_def_connection();
    $this->cron_setup();
    $this->add_rewrite_rules();
    $this->initAction();
    $this->moveServiceWokrer();
    $this->initSupportAMP();

    if(self::$defconnection['dbtype'] == 'remote'){
      self::$pushdb = new wpdb(self::$defconnection['dbuser'], self::$defconnection['dbpass'], self::$defconnection['dbname'], self::$defconnection['dbhost']);
      if(!self::$pushdb){
        $this->output(0, esc_html__('Connecting with the remote push notification database is failed', 'smio-push-notification'));
      }
    }
    else{
      global $wpdb;
      self::$pushdb = $wpdb;
    }
    self::$pushdb->hide_errors();

    self::$firebase = new smpush_firebase(self::$apisetting);
  }

  public function set_def_connection(){
    global $wpdb;
    self::$defconnection = $wpdb->get_row($wpdb->prepare("SELECT * FROM ".$wpdb->prefix."push_connection WHERE id=%d", [ self::$apisetting['def_connection'] ]), 'ARRAY_A');
  }

  public function initSupportAMP(){
    new smpush_amp(self::$apisetting);
  }

  public static function platformType($platform){
    if(in_array($platform, self::$webPlatforms)){
      return 'web';
    }
    elseif(in_array($platform, self::$mobilePlatforms)){
      return 'mobile';
    }
    else{
      return $platform;
    }
  }

  public static function parse_query($query){
    if(preg_match_all("/{([a-zA-Z0-9_]+)}/", $query, $matches)){
      foreach($matches[1] AS $match){
        if($match == 'ios_name' OR $match == 'iosfcm_name' OR $match == 'android_name' OR $match == 'wp_name' OR $match == 'wp10_name' OR $match == 'bb_name' OR $match == 'chrome_name' OR $match == 'safari_name' OR $match == 'firefox_name'
           OR $match == 'opera_name' OR $match == 'samsung_name' OR $match == 'edge_name' OR $match == 'fbmsn_name' OR $match == 'viber_name' OR $match == 'fbnotify_name' OR $match == 'email_name' OR $match == 'counter_name' OR $match == 'firebase_name')
          $query = str_replace('{'.$match.'}', self::$defconnection[$match] , $query);
        elseif($match == 'tbname_temp')
          $query = str_replace('{'.$match.'}', '`'.self::$defconnection['tbname'].'_temp'.'`' , $query);
        else
          $query = str_replace('{'.$match.'}', '`'.self::$defconnection[$match].'`' , $query);
      }
    }
    $query = str_replace('{wp_prefix}', SMPUSHTBPRE, $query);
    return $query;
  }

  public static function setting(){
    if($_POST){
      self::saveOptions();
    }
    elseif (isset($_GET['loadtaxs'])) {
      if(empty($_GET['smiopush_post_type'])){
        echo '';
        exit;
      }
      $html = '<option value=""></option>';
      $taxonomy_objects = get_object_taxonomies($_GET['smiopush_post_type'], 'objects');
      foreach ($taxonomy_objects as $type => $object){
        $html .= '<option value="'.$type.'">'.$type.'</option>';
      }
      echo $html;
      exit;
    }
    elseif (isset($_GET['loadcats'])) {
      if(empty($_GET['smiopush_object_name'])){
        echo '';
        exit;
      }
      wp_terms_checklist(0, array('taxonomy' => $_GET['smiopush_object_name']));
      exit;
    }
    else{
      global $wpdb;
      $connections = $wpdb->get_results("SELECT id,title FROM ".$wpdb->prefix."push_connection ORDER BY id ASC");
      wp_enqueue_script('media-upload');
      wp_enqueue_script('thickbox');
      wp_enqueue_script('jquery');
      wp_enqueue_style('thickbox');
      wp_enqueue_style('wp-color-picker');
      wp_enqueue_script('wp-color-picker');
      //labelauty libs
      wp_enqueue_style('smpush-labelauty-style');
      wp_enqueue_script('smpush-jquery-labelauty');

      if(smpush_mobapp_mode && is_multisite() && ! is_super_admin()){
        $canEditApiKeys = false;
      }
      else{
        $canEditApiKeys = true;
      }

      $envErrors = array();
      if(phpversion() < 7.1){
        $envErrors[] = 'PHP version must be 7.1 or later.';
      }
      if(!function_exists('gmp_init')){
        $envErrors[] = 'GMP PHP extension must be installed and enabled.';
      }
      if(!function_exists('openssl_decrypt')){
        $envErrors[] = 'OpenSSL PHP extension must be installed and enabled.';
      }
      if(!function_exists('mb_check_encoding')){
        $envErrors[] = 'MBSTRING PHP extension must be installed and enabled.';
      }
      if(!function_exists('curl_init')){
        $envErrors[] = 'CURL PHP extension must be installed and enabled.';
      }

      array_walk_recursive(self::$apisetting, 'self::clearSpecialChars');

      self::loadpage('setting', 1, array('connections' => $connections, 'canEditApiKeys' => $canEditApiKeys, 'envErrors' => $envErrors));
    }
  }

  public static function clearSpecialChars(&$value){
    $value = (is_string($value)) ? htmlspecialchars($value, ENT_QUOTES) : $value;
  }

  public static function documentation(){
    include(smpush_dir.'/class.documentation.php');
    self::load_jsplugins();
    $document = new smpush_documentation();
    $document = $document->build();
    $smpushexurl['auth_key'] = (self::$apisetting['complex_auth']==1)?md5(date('m/d/Y').self::$apisetting['auth_key'].date('H:i')):self::$apisetting['auth_key'];
    $smpushexurl['push_basename'] = get_bloginfo('wpurl') .'/'.self::$apisetting['push_basename'];
    include(smpush_dir.'/pages/documentation.php');
  }

  public static function loadpage($template, $noheader=0, $params=0){
    self::load_jsplugins();
    $noheader = ($noheader == 0) ? '' : '&noheader=1';
    $page_url = admin_url().'admin.php?page=smpush_'.$template.$noheader;
    include(smpush_dir.'/pages/'.$template.'.php');
  }

  public static function load_jsplugins(){
    wp_enqueue_style('smpush-style');
    if(is_rtl()){
      wp_enqueue_style('smpush-rtl');
    }
    wp_enqueue_script('smpush-mainscript');
    wp_enqueue_script('smpush-plugins');
  }

  public static function saveOptions(){
    if(smpush_env_demo){
      echo 1;
      die();
    }
    global $wp_filesystem;

    require(smpush_dir.'/lib/validation/autoload.php');
    $validator = new Validator;
    $validation = $validator->make($_POST, [
      'auth_key' => 'required',
      'push_basename' => 'required',
      'msgs_interval' => 'required|integer',
      'cron_limit' => 'required|integer',
      'def_connection' => 'required|integer',
      'geo_provider' => 'required',
      'apple_teamid' => 'required_if:apple_cert_type,p8',
      'apple_keyid' => 'required_if:apple_cert_type,p8',
      'apple_appid' => 'required_if:apple_cert_type,p8',
      'apple_passphrase' => 'required_if:apple_cert_type,pem',
      'firebase_config' => 'required_with:desktop_chrome_status',
      'chrome_apikey' => 'required_with:desktop_chrome_status',
      'chrome_projectid' => 'required_with:desktop_chrome_status',
      'chrome_vapid_public' => 'required_with:amp_support',
      'chrome_vapid_private' => 'required_with:amp_support',
      'safari_passphrase' => 'required_with:desktop_safari_status',
      'safari_web_id' => 'required_with:desktop_safari_status',
      'safari_icon' => 'required_with:desktop_safari_status',
      'e_appcomment_body' => 'required_with:e_appcomment',
      'e_newcomment_body' => 'required_with:e_newcomment',
      'e_newcomment_allusers_body' => 'required_with:e_newcomment_allusers',
      'e_newcomment_mentions_body' => 'required_with:e_newcomment_mentions',
      'e_usercomuser_body' => 'required_with:e_usercomuser',
      'e_woo_waiting_title' => 'required_with:e_woo_waiting',
      'e_woo_waiting_message' => 'required_with:e_woo_waiting',
      'e_woo_aband_maxage' => 'required_with:e_woo_abandoned|integer',
      'e_woo_aband_times' => 'required_with:e_woo_abandoned|integer',
      'e_woo_aband_interval' => 'required_with:e_woo_abandoned|integer',
      'e_woo_aband_title' => 'required_with:e_woo_abandoned',
      'e_woo_aband_message' => 'required_with:e_woo_abandoned',
      'e_woo_aband_last_title' => 'required_with:e_woo_aband_last_rem',
      'e_woo_aband_last_message' => 'required_with:e_woo_aband_last_rem',
      'e_wpjobman_body' => 'required_with:e_wpjobman_status',
      'e_mycred_nbalance_b' => 'required_with:e_mycred_nbalance',
      'e_mycred_transfer_b' => 'required_with:e_mycred_transfer',
    ]);
    $validation->validate();
    if ($validation->fails()) {
      $errors = $validation->errors();
      self::jsonPrint('validation', $errors->all());
    }

    if(!empty($_POST['msn_appid']) && (empty($_POST['msn_accesstoken']) || empty($_POST['msn_secret']))){
      self::jsonPrint('validation', [esc_html__('Messenger access token and secret are required')]);
    }
    if(isset($_POST['desktop_chrome_status']) && empty($_FILES['firebase_auth_file_upload']['tmp_name']) && empty($_POST['firebase_auth_file'])){
      self::jsonPrint('validation', [esc_html__('Firebase authentication file is required')]);
    }
    if(isset($_POST['desktop_safari_status']) && empty($_FILES['safari_certp12_upload']['tmp_name']) && empty($_POST['safari_certp12_path'])){
      self::jsonPrint('validation', [esc_html__('Safari P12 certification file is required')]);
    }
    if($_POST['apple_cert_type'] == 'pem' && empty($_FILES['apple_certp12_upload']['tmp_name']) && empty($_POST['apple_certp12_path'])){
      self::jsonPrint('validation', [esc_html__('iOS P12 certification file is required')]);
    }
    if($_POST['apple_cert_type'] == 'p8' && empty($_FILES['apple_certp8_upload']['tmp_name']) && empty($_POST['apple_certp8_path'])){
      self::jsonPrint('validation', [esc_html__('iOS P8 certification file is required')]);
    }
    if(!empty($_POST['safari_icon']) && function_exists('getimagesize')){
      $safari_icon_path = explode('/'.basename(smpush_upload_dir).'/', $_POST['safari_icon']);
      $safari_icon_path = smpush_upload_dir.'/'.$safari_icon_path[1];
      list($width, $height, $type, $attr) = getimagesize($safari_icon_path);
      if($width != 256 || $height != 256){
        self::jsonPrint('validation', [esc_html__('Safari icon dimensions must be 256 x 256 px')]);
      }
    }

    $newsetting = array();
    foreach($_POST AS $key => $value){
      if(!in_array($key, array('submit'))){
        $newsetting[$key] = $value;
        unset(self::$apisetting[$key]);
      }
    }
    unset($newsetting['selectDIV']);

    $categories = array();
    if(!empty($_POST['post_category'])){
      foreach($_POST['post_category'] as $catid){
        $categories[] = $catid;
      }
    }
    elseif(!empty($_POST['tax_input'])){
      foreach($_POST['tax_input'] as $tax){
        if (!empty($tax)){
          foreach($tax as $catid){
            $categories[] = $catid;
          }
        }
      }
    }
    unset(self::$apisetting['post_category']);
    unset(self::$apisetting['tax_input']);
    self::$apisetting['subspage_category'] = $categories;

    $checkbox = array(
    'bb_notify_friends',
    'bb_notify_messages',
    'bb_notify_activity',
    'bb_notify_activity_admins_only',
    'bb_notify_xprofile',
    'desktop_status',
    'desktop_debug',
    'desktop_chrome_status',
    'desktop_firefox_status',
    'desktop_safari_status',
    'desktop_opera_status',
    'desktop_edge_status',
    'desktop_samsung_status',
    'desktop_modal',
    'desktop_logged_only',
    'desktop_admins_only',
    'desktop_gps_status',
    'auto_geo',
    'complex_auth',
    'ios_onebyone',
    'apple_sandbox',
    'wp_authed',
    'bb_dev_env',
    'android_titanium_payload',
    'android_corona_payload',
    'android_fcm_msg',
    'ios_titanium_payload',
    'smtp_status',
    'msn_widget_status',
    'e_post_chantocats',
    'e_apprpost',
    'e_appcomment',
    'e_newcomment',
    'e_newcomment_allusers',
    'e_usercomuser',
    'e_postupdated',
    'e_newpost',
    'e_newcomment_mentions',
    'stop_summarize',
    'metabox_check_status',
    'msn_official_widget_status',
    'fblogin_regin_newsletter',
    'fblogin_regin_fbnotifs',
    'fblogin_regin_wpuser',
    'desktop_welc_status',
    'e_wpjobman_status',
    'desktop_offline',
    'subspage_geo_status',
    'subspage_keywords',
    'subspage_channels',
    'subspage_cats_status',
    'subspage_plat_web',
    'subspage_plat_mobile',
    'subspage_plat_msn',
    'subspage_plat_email',
    'subspage_show_catimages',
    'subspage_rating',
    'msn_woo_checkout',
    'msn_woo_cartbtn',
    'subspage_matchone',
    'fast_bridge',
    'gdpr_icon',
    'gdpr_subs_btn',
    'gdpr_ver_option',
    'e_woo_waiting',
    'e_woo_abandoned',
    'e_woo_aband_last_rem',
    'android_msg_counter',
    'ios_msg_counter',
    'webpush_onesignal_payload',
    'no_disturb',
    'black_overlay',
    'desktop_welc_redir',
    'pwa_support',
    'pwaforwp_support',
    'amp_support',
    'amp_post_widget',
    'amp_page_widget',
    'amp_post_shortcode',
    'amp_page_shortcode',
    'pwa_kaludi_support',
    'peepso_notifications',
    'real_webpush_views',
    'e_mycred_nbalance',
    'e_mycred_transfer',
    'logs_mode',
    );

    foreach($checkbox AS $inptname){
      if(!isset($_POST[$inptname])){
        self::$apisetting[$inptname] = 0;
      }
    }
    $upload_dir = wp_upload_dir();
    $cert_upload_path = $upload_dir['basedir'].'/certifications';
    if(! file_exists($cert_upload_path)){
      if(! $wp_filesystem->mkdir($cert_upload_path)){
        die(esc_html__('can not create a directory to save the certifications files under uploads directory .', 'smio-push-notification'));
      }
    }
    if(!empty($_FILES['apple_cert_upload']['tmp_name'])){
      if(strtolower(substr(sanitize_file_name($_FILES['apple_cert_upload']['name']), strrpos(sanitize_file_name($_FILES['apple_cert_upload']['name']), '.') + 1)) == 'pem'){
        $target_path = $cert_upload_path.'/cert_connection_'.time().'_'.$newsetting['def_connection'].'.pem';
        if($wp_filesystem->move($_FILES['apple_cert_upload']['tmp_name'], $target_path)){
          unset(self::$apisetting['apple_cert_path']);
          $newsetting['apple_cert_path'] = addslashes($target_path);
        }
      }
    }
    if(!empty($_FILES['apple_certp12_upload']['tmp_name'])){
      if(strtolower(substr(sanitize_file_name($_FILES['apple_certp12_upload']['name']), strrpos(sanitize_file_name($_FILES['apple_certp12_upload']['name']), '.') + 1)) == 'p12'){
        $target_path = $cert_upload_path.'/cert_connection_'.time().'_'.$newsetting['def_connection'].'.p12';
        if($wp_filesystem->move($_FILES['apple_certp12_upload']['tmp_name'], $target_path)){
          unset(self::$apisetting['apple_certp12_path']);
          $newsetting['apple_certp12_path'] = addslashes($target_path);
          $iosCertPEM = smpush_helper::convertCertP12($newsetting['apple_certp12_path'], $newsetting['apple_passphrase']);
          if($iosCertPEM === false){
            self::jsonPrint('validation', [esc_html__('Invalid iOS certification or password phrase is wrong')]);
          }
          $newsetting['apple_cert_path'] = $iosCertPEM;
        }
      }
    }
    if(!empty($_FILES['apple_certp8_upload']['tmp_name'])){
      if(strtolower(substr(sanitize_file_name($_FILES['apple_certp8_upload']['name']), strrpos(sanitize_file_name($_FILES['apple_certp8_upload']['name']), '.') + 1)) == 'p8'){
        $target_path = $cert_upload_path.'/cert_connection_'.time().'_'.$newsetting['def_connection'].'.p8';
        if($wp_filesystem->move($_FILES['apple_certp8_upload']['tmp_name'], $target_path)){
          unset(self::$apisetting['apple_certp8_path']);
          $newsetting['apple_certp8_path'] = addslashes($target_path);
        }
      }
    }
    if(!empty($_FILES['wp_cert']['tmp_name'])){
      $ext = strtolower(substr(sanitize_file_name($_FILES['wp_cert']['name']), strrpos(sanitize_file_name($_FILES['wp_cert']['name']), '.') + 1));
      $target_path = $cert_upload_path.'/wp_cert_connection_'.time().'_'.$newsetting['def_connection'].'.'.$ext;
      if($wp_filesystem->move($_FILES['wp_cert']['tmp_name'], $target_path)){
        unset(self::$apisetting['wp_cert']);
        $newsetting['wp_cert'] = addslashes($target_path);
      }
    }
    if(!empty($_FILES['wp_pem']['tmp_name'])){
      $ext = strtolower(substr(sanitize_file_name($_FILES['wp_pem']['name']), strrpos(sanitize_file_name($_FILES['wp_pem']['name']), '.') + 1));
      $target_path = $cert_upload_path.'/wp_pem_connection_'.time().'_'.$newsetting['def_connection'].'.'.$ext;
      if($wp_filesystem->move($_FILES['wp_pem']['tmp_name'], $target_path)){
        unset(self::$apisetting['wp_pem']);
        $newsetting['wp_pem'] = addslashes($target_path);
      }
    }
    if(!empty($_FILES['wp_cainfo']['tmp_name'])){
      $ext = strtolower(substr(sanitize_file_name($_FILES['wp_cainfo']['name']), strrpos(sanitize_file_name($_FILES['wp_cainfo']['name']), '.') + 1));
      $target_path = $cert_upload_path.'/wp_cainfo_connection_'.time().'_'.$newsetting['def_connection'].'.'.$ext;
      if($wp_filesystem->move($_FILES['wp_cainfo']['tmp_name'], $target_path)){
        unset(self::$apisetting['wp_cainfo']);
        $newsetting['wp_cainfo'] = addslashes($target_path);
      }
    }
    if(!empty($_FILES['safari_certp12_upload']['tmp_name'])){
      $ext = strtolower(substr(sanitize_file_name($_FILES['safari_certp12_upload']['name']), strrpos(sanitize_file_name($_FILES['safari_certp12_upload']['name']), '.') + 1));
      $target_path = $cert_upload_path.'/safari_certp12_connection_'.time().'_'.$newsetting['def_connection'].'.'.$ext;
      if($wp_filesystem->move($_FILES['safari_certp12_upload']['tmp_name'], $target_path)){
        unset(self::$apisetting['safari_certp12_path']);
        $newsetting['safari_certp12_path'] = addslashes($target_path);
        $safariCertPEM = smpush_helper::convertCertP12($newsetting['safari_certp12_path'], $newsetting['safari_passphrase']);
        if($safariCertPEM === false){
          self::jsonPrint('validation', [esc_html__('Invalid Safari certification or password phrase is wrong')]);
        }
        $newsetting['safari_cert_path'] = $safariCertPEM;
      }
    }
    if(!empty($_FILES['firebase_auth_file_upload']['tmp_name'])){
      $ext = strtolower(substr(sanitize_file_name($_FILES['firebase_auth_file_upload']['name']), strrpos(sanitize_file_name($_FILES['firebase_auth_file_upload']['name']), '.') + 1));
      $target_path = $cert_upload_path.'/firebase_auth_file_'.time().'_'.$newsetting['def_connection'].'.'.$ext;
      if($wp_filesystem->move($_FILES['firebase_auth_file_upload']['tmp_name'], $target_path)){
        unset(self::$apisetting['firebase_auth_file']);
        $newsetting['firebase_auth_file'] = addslashes($target_path);
        $wp_filesystem->chmod($target_path, 0600);
      }
    }

    if(!empty(self::$apisetting['safari_pack_path'])){
      smpush_unlink($cert_upload_path.'/'.self::$apisetting['safari_pack_path']);
      unset(self::$apisetting['safari_pack_path']);
    }

    self::$apisetting = array_map('wp_slash', self::$apisetting);
    self::$apisetting = array_merge($newsetting, self::$apisetting);

    /*if(self::$apisetting['msn_accesstoken'] != self::$apisetting['msn_oldaccesstoken']){
      $helper = new smpush_helper();
      $response = json_decode($helper->buildCurl('https://graph.facebook.com/v2.10/me/subscribed_apps?access_token='.self::$apisetting['msn_accesstoken'], false, true), true);
      if(isset($response['success']) && $response['success'] == 'true'){
        self::$apisetting['msn_subscribe_error'] = 0;
        self::$apisetting['msn_oldaccesstoken'] = self::$apisetting['msn_accesstoken'];
      }
      else{
        self::$apisetting['msn_subscribe_error'] = 1;
      }
    }*/

    if(self::$apisetting['viber_app_key'] != self::$apisetting['viber_app_key_old']){
      $helper = new smpush_helper();
      $callbackurl = get_bloginfo('wpurl').'/?smpushcontrol=viber';
      $jsonParams = json_encode(array('url' => $callbackurl, 'send_name' => true, 'send_photo' => true));
      $response = json_decode($helper->buildCurl('https://chatapi.viber.com/pa/set_webhook', false, $jsonParams, array('X-Viber-Auth-Token: '.self::$apisetting['viber_app_key'], 'content-type: application/json')), true);
      if(isset($response['status_message']) && $response['status_message'] == 'ok'){
        self::$apisetting['viber_error'] = 0;
        self::$apisetting['viber_app_key_old'] = self::$apisetting['msn_accesstoken'];
      } else{
        self::$apisetting['viber_error'] = 1;
      }
    }

    self::$apisetting['msn_subscribe_error'] = 0;
    self::$apisetting['last_change_time'] = time();
    self::$apisetting['settings_version'] = self::$apisetting['settings_version']+0.01;

    if (self::$apisetting['desktop_webpush'] == 0){
      self::$apisetting['amp_support'] = 0;
    }

    self::setup_bridge();
    smpush_unlink(smpush_cache_dir.'/jwt_header');

    global $wp_rewrite;
    self::add_rewrite_rules_ft(self::$apisetting['push_basename']);
    $wp_rewrite->flush_rules(false);

    update_option('smpush_options', self::$apisetting);
    echo 1;
    die();
  }

  public static function loadHistory($field, $index=false){
    if($index === false){
      if(isset(self::$history[$field])){
        if(is_array(self::$history[$field])){
          return array_map('stripslashes', self::$history[$field]);
        }
        else{
          return stripslashes(self::$history[$field]);
        }
      }
    }
    else{
      if(isset(self::$history[$field][$index])){
        return stripslashes(self::$history[$field][$index]);
      }
    }
    return '';
  }

  public static function loadData($field, $index=false, $defaultvalue=false){
    if($index === false){
      if(isset(self::$data[$field])){
        if(is_array(self::$data[$field])){
          return array_map('stripslashes_deep', self::$data[$field]);
        }
        else{
          return stripslashes(esc_attr(self::$data[$field]));
        }
      }
    }
    else{
      if(isset(self::$data[$field][$index])){
        if(is_array(self::$data[$field][$index])){
          return array_map('stripslashes_deep', self::$data[$field][$index]);
        }
        else{
          return stripslashes(esc_attr(self::$data[$field][$index]));
        }
      }
    }
    return ($defaultvalue !== false)? $defaultvalue : '';
  }

  public function build_menus(){
    $roles = smpush_helper::current_user_roles();

    if(empty(self::$apisetting['who_use']) || array_intersect($roles, self::$apisetting['who_use'])){
      add_menu_page('Settings', esc_html__('Smart Notification', 'smio-push-notification'), 'read', 'smpush_setting', array('smpush_controller', 'setting'), 'div', 4);
      add_submenu_page('smpush_setting', esc_html__('New Campaign', 'smio-push-notification'), esc_html__('New Campaign', 'smio-push-notification'), 'read', 'smpush_send_notification', array('smpush_sendpush', 'send_notification'));
      add_submenu_page('smpush_setting', esc_html__('Pending Campaigns', 'smio-push-notification'), esc_html__('Campaigns Pending', 'smio-push-notification'), 'read', 'smpush_campending', array('smpush_modules', 'archivepending'));
      add_submenu_page('smpush_setting', esc_html__('Campaigns Archive', 'smio-push-notification'), esc_html__('Campaigns Archive', 'smio-push-notification'), 'read', 'smpush_archive', array('smpush_modules', 'archive'));
      add_submenu_page('smpush_setting', esc_html__('Auto Responder', 'smio-push-notification'), esc_html__('Auto Responder', 'smio-push-notification'), 'read', 'smpush_archiveres', array('smpush_modules', 'smpush_archiveres'));
      add_submenu_page('smpush_setting', esc_html__('Auto Campaigns', 'smio-push-notification'), esc_html__('Auto Campaigns', 'smio-push-notification'), 'read', 'smpush_archiveauto', array('smpush_modules', 'archiveauto'));
      add_submenu_page('smpush_setting', esc_html__('RSS Auto Push', 'smio-push-notification'), esc_html__('RSS Auto Push', 'smio-push-notification'), 'read', 'smpush_autorss', array('smpush_autorss', 'page'));
      add_submenu_page('smpush_setting', esc_html__('Statistics', 'smio-push-notification'), esc_html__('Statistics', 'smio-push-notification'), 'read', 'smpush_statistics', array('smpush_modules', 'statistics'));
      add_submenu_page('smpush_setting', esc_html__('Event Manager', 'smio-push-notification'), esc_html__('Event Manager', 'smio-push-notification'), 'read', 'smpush_events', array('smpush_event_manager', 'page'));
      add_submenu_page('smpush_setting', esc_html__('Manage Connections', 'smio-push-notification'), esc_html__('Manage Connections', 'smio-push-notification'), 'read', 'smpush_connections', array('smpush_modules', 'connections'));
      add_submenu_page('smpush_setting', esc_html__('Manage Subscribers', 'smio-push-notification'), esc_html__('Manage Subscribers', 'smio-push-notification'), 'read', 'smpush_tokens', array('smpush_modules', 'tokens'));
      add_submenu_page('smpush_setting', esc_html__('Import Subscribers', 'smio-push-notification'), esc_html__('Import Subscribers', 'smio-push-notification'), 'read', 'smpush_import', array('smpush_modules', 'import'));
      add_submenu_page('smpush_setting', esc_html__('OneSignal Migration', 'smio-push-notification'), esc_html__('OneSignal Migration', 'smio-push-notification'), 'read', 'smpush_onesignal', array('smpush_modules', 'onesignal'));
      add_submenu_page('smpush_setting', esc_html__('Push Notification Channels', 'smio-push-notification'), esc_html__('Manage Channels', 'smio-push-notification'), 'read', 'smpush_channel', array('smpush_modules', 'push_channel'));
      add_submenu_page('smpush_setting', esc_html__('Test Dashboard', 'smio-push-notification'), esc_html__('Test Dashboard', 'smio-push-notification'), 'read', 'smpush_test_sending', array('smpush_modules', 'testing'));
      add_submenu_page('smpush_setting', esc_html__('Developer Documentation', 'smio-push-notification'), esc_html__('Documentation', 'smio-push-notification'), 'read', 'smpush_documentation', array('smpush_controller', 'documentation'));
      add_submenu_page(NULL, esc_html__('Sending Push Notification', 'smio-push-notification'), esc_html__('Sending Push Notification', 'smio-push-notification'), 'read', 'smpush_send_process', array('smpush_sendpush', 'send_process'));
      add_submenu_page(NULL, esc_html__('Queue Push', 'smio-push-notification'), esc_html__('Queue Push', 'smio-push-notification'), 'read', 'smpush_runqueue', array('smpush_sendpush', 'RunQueue'));
      add_submenu_page(NULL, esc_html__('Cancel Queue Push', 'smio-push-notification'), esc_html__('Cancel Queue Push', 'smio-push-notification'), 'read', 'smpush_cancelqueue', array('smpush_sendpush', 'smpush_cancelqueue'));
      add_submenu_page(NULL, esc_html__('Active invalid tokens', 'smio-push-notification'), esc_html__('Active invalid tokens', 'smio-push-notification'), 'read', 'smpush_active_tokens', array('smpush_sendpush', 'activateTokens'));
      add_submenu_page(NULL, esc_html__('Watch real-time GPS', 'smio-push-notification'), esc_html__('Watch real-time GPS', 'smio-push-notification'), 'read', 'smpush_realtime_gps', array('smpush_sendpush', 'gpsRealtime'));
      add_submenu_page(NULL, 'Campaign Ajax', 'Campaign Ajax', 'read', 'smpush_ajax_actions', array('smpush_modules', 'ajax_actions'));
      if(is_multisite() && ! is_super_admin()){
        return;
      }
      add_submenu_page('smpush_setting', esc_html__('System Error Log', 'smio-push-notification'), esc_html__('System Error Log', 'smio-push-notification'), 'read', 'smpush_error_log', array('smpush_modules', 'error_log'));
      add_submenu_page('smpush_setting', esc_html__('System Auto Update', 'smio-push-notification'), esc_html__('Auto Update', 'smio-push-notification'), 'read', 'smpush_autoupdate', array('smpush_autoupdate', 'auto_update'));
    }
  }

  public static function register_cron($schedules){
    $schedules['smpush_few_days'] = array(
      'interval' => 259200,
      'display' => esc_html__('Once every 3 days')
    );
    $schedules['smpush_recurring_min'] = array(
      'interval' => 180,
      'display' => esc_html__('Every 3 minutes')
    );
    return $schedules;
  }

  public function cron_setup(){
    if(!wp_next_scheduled('smpush_recurring_cron')){
      wp_schedule_event(current_time('timestamp'), 'smpush_recurring_min', 'smpush_recurring_cron');
	  }
    if(!wp_next_scheduled('smpush_silent_cron')){
      wp_schedule_event(current_time('timestamp'), 'hourly', 'smpush_silent_cron');
	  }
    if(!wp_next_scheduled('smpush_update_counters')){
      wp_schedule_event(mktime(3,0,0,date('m'),date('d'),date('Y')), 'daily', 'smpush_update_counters');
	  }
    if(! wp_next_scheduled('smpush_cron_fewdays')){
      wp_schedule_event(mktime(15,0,0,date('m'),date('d'),date('Y')), 'smpush_few_days', 'smpush_cron_fewdays');
	  }
    if(get_transient('smpush_update_notice') !== false){
      add_action('admin_notices', array('smpush_controller', 'update_notice'));
    }
  }

  public function check_update_notify(){
    if(function_exists('curl_init')){
      $ch = curl_init();
      curl_setopt($ch, CURLOPT_URL, "https://smartiolabs.com/update/push_notification");
      curl_setopt($ch, CURLOPT_REFERER, 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
      curl_setopt($ch, CURLOPT_HEADER, 0);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
      curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
      curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
      curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
      if(defined('WP_PROXY_HOST')){
        curl_setopt($ch, CURLOPT_PROXY, WP_PROXY_HOST);
        curl_setopt($ch, CURLOPT_PROXYPORT, WP_PROXY_PORT);
        curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
        if(defined('WP_PROXY_USERNAME')){
          curl_setopt($ch, CURLOPT_PROXYUSERPWD, WP_PROXY_USERNAME.':'.WP_PROXY_PASSWORD);
          curl_setopt($ch, CURLOPT_PROXYAUTH, CURLAUTH_ANY);
        }
      }
      $data = json_decode(curl_exec($ch));
      curl_close($ch);
      if($data !== NULL){
        if($data->version > SMPUSHVERSION){
          set_transient('smpush_update_notice', $data, 86400);
        }
      }
    }
  }

  public static function update_notice(){
    if(current_user_can('administrator')){
      $data = get_transient('smpush_update_notice');
      echo '<div class="notice notice-warning is-dismissible"><p><a href="'.$data->link.'" target="_blank">'.$data->plugin.' '.$data->version.'</a> '.esc_html__('is available! Please update your system using the', 'smio-push-notification').' <a href="'.admin_url().'admin.php?page=smpush_autoupdate">'.esc_html__('auto update page', 'smio-push-notification').'</a>.</p></div>';
    }
  }

  public static function demonote(){
    if(current_user_can('administrator')){
      echo '<div class="notice notice-error"><p><strong>It is a demo version and some features are disabled like save settings, delete records or send push messages.</strong></p></div>';
    }
  }

  public static function bizfeature(){
    if(current_user_can('administrator')){
      //echo '<div class="notice notice-error"><p><strong>This feature is available for Developer & Business plans only.</strong></p></div>';
    }
  }

  public static function illgeal(){
    if(current_user_can('administrator')){
      //echo '<div class="notice notice-error"><p>It is illegal use of `Smart Push Notification` plugin in multisite Wordpress network. Please upgrade your plan to Developer or Business for using this feature <a href="https://smartiolabs.com/product/push-notification-system#plans" target="_blank">click here</a></p></div>';
    }
  }

  public static function license(){
    if(current_user_can('administrator')){
      echo '<div class="notice notice-error"><p>Some of `Push Notification System` plugin functions are disabled. Please enter your purchase code in the `Auto Update` page.</p></div>';
    }
  }

  public static function vapid_warn(){
    if(current_user_can('administrator')){
      $can_show = get_option('smpush_dismiss_vapwarn');
      if(empty($can_show)){
        echo '<div class="notice notice-error"><p>Must update your VAPID keys at Firebase to continue sending your old subscribers. For how to <a href="https://youtu.be/2-yVATKeUKw" target="_blank">click here</a> | <a href="'.admin_url().'admin.php?page=smpush_tokens&dismiss_vap_warn=1">Dismiss</a></p></div>';
      }
    }
  }

  public static function firebase_warn(){
    if(current_user_can('administrator')){
      echo '<div class="notice notice-error"><p>Please complete Firebase configurations or plugin will not work properly to send out web push notifications.</p></div>';
    }
  }

  public static function update_counters(){
    global $wpdb;
    $defconid = self::$apisetting['def_connection'];
    $counter = self::$pushdb->get_var(self::parse_query("SELECT COUNT({id_name}) FROM {tbname}"));
    $wpdb->query("UPDATE ".$wpdb->prefix."push_connection SET `counter`='$counter' WHERE id='$defconid'");

    $toforgets = $wpdb->get_results("SELECT id FROM ".$wpdb->prefix."push_archive WHERE send_type IN('now','custom','feedback') AND starttime<NOW()-INTERVAL 60 DAY");
    if($toforgets){
      foreach($toforgets as $toforget){
        $wpdb->query("DELETE FROM ".$wpdb->prefix."push_archive WHERE id='$toforget->id'");
        $wpdb->query("DELETE FROM ".$wpdb->prefix."push_archive_reports WHERE msgid='$toforget->id'");
        $wpdb->query("DELETE FROM ".$wpdb->prefix."push_history WHERE msgid='$toforget->id'");
        $wpdb->query("DELETE FROM ".$wpdb->prefix."push_newsletter_templates WHERE msgid='$toforget->id'");
        $wpdb->query("DELETE FROM ".$wpdb->prefix."push_statistics WHERE msgid='$toforget->id'");
      }
    }

    $wpdb->query("DELETE FROM ".$wpdb->prefix."push_history WHERE timepost<NOW()-INTERVAL 60 DAY");
    $wpdb->query("DELETE FROM ".$wpdb->prefix."push_desktop_messages WHERE timepost<NOW()-INTERVAL 3 DAY");
    $wpdb->query("DELETE FROM ".$wpdb->prefix."push_feedback WHERE timepost<NOW()-INTERVAL 10 DAY");
    $wpdb->query("DELETE FROM ".$wpdb->prefix."push_cron_queue WHERE timepost<NOW()-INTERVAL 10 DAY");
  }

  public static function clean_cron_assets(){
    global $wpdb;
    $options = $wpdb->get_results("SELECT * FROM $wpdb->options WHERE `option_name` LIKE 'smpush_cron_stats_%'");
    if($options){
      foreach($options as $option){
        $settings = unserialize($option->option_value);
        if(!empty($settings['archiveid'])){
          $starttime = $wpdb->get_var($wpdb->prepare('SELECT starttime FROM '.$wpdb->prefix.'push_archive WHERE id = %d', [ $settings['archiveid'] ]));
          if(empty($starttime)){
            $wpdb->query("DELETE FROM $wpdb->options WHERE option_id = $option->option_id");
          } elseif($starttime && (strtotime($starttime)+86400) < time()){
            $wpdb->query("DELETE FROM $wpdb->options WHERE option_id = $option->option_id");
          }
        }
      }
    }
  }

  public static function update_all_counters(){
    global $wpdb;
    self::update_counters();
    $channels = $wpdb->get_results("SELECT id FROM ".$wpdb->prefix."push_channels");
    if($channels){
      foreach($channels as $channel){
        $count = $wpdb->get_var("SELECT COUNT(token_id) FROM ".$wpdb->prefix."push_relation WHERE channel_id='$channel->id'");
        $wpdb->query("UPDATE ".$wpdb->prefix."push_channels SET `count`='$count' WHERE id='$channel->id'");
      }
    }
  }

  public static function run_silent_cron(){
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, get_bloginfo('wpurl').'/?smpushcontrol=cron_job&time='.time());
    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    if(defined('WP_PROXY_HOST')){
      curl_setopt($ch, CURLOPT_PROXY, WP_PROXY_HOST);
      curl_setopt($ch, CURLOPT_PROXYPORT, WP_PROXY_PORT);
      curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
      if(defined('WP_PROXY_USERNAME')){
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, WP_PROXY_USERNAME.':'.WP_PROXY_PASSWORD);
        curl_setopt($ch, CURLOPT_PROXYAUTH, CURLAUTH_ANY);
      }
    }
    $result = curl_exec($ch);
    if(smpush_env == 'logs' || smpush_logs_mode){
      self::log('crob-job has been called silently !');
    }
    curl_close($ch);
  }

  public function get_option($index){
    return self::$apisetting[$index];
  }

  public function plugin_bootstrap(){
    self::$apisetting = get_option('smpush_options');
    self::$apisetting = array_map('stripslashes_deep', self::$apisetting);

    self::$apisetting['gdpr_ver_text_processed'] = self::processGDPRText(self::$apisetting['gdpr_privacylink'], self::$apisetting['gdpr_termslink'], self::$apisetting['gdpr_ver_text']);
    if(is_multisite() && !file_exists(smpush_upload_dir.'/smpush_premium.info')){
      add_action('admin_notices', array('smpush_controller', 'illgeal'));
    }
    if(empty(self::$apisetting['purchase_code'])){
      add_action('admin_notices', array('smpush_controller', 'license'));
    }
    if(self::$apisetting['desktop_status'] == 1 && empty(self::$apisetting['firebase_config'])){
      add_action('admin_notices', array('smpush_controller', 'firebase_warn'));
    }
    if(!empty(self::$apisetting['desktop_used_webpush'])){
      add_action('admin_notices', array('smpush_controller', 'vapid_warn'));
    }
    if(smpush_env_demo){
      add_action('admin_notices', array('smpush_controller', 'demonote'));
      if(!empty($_GET['page']) && $_GET['page'] == 'smpush_autorss'){
        add_action('admin_notices', array('smpush_controller', 'bizfeature'));
      }
    }
    wp_register_script('smpush-fb-chat-sdk', 'https://connect.facebook.net/'.self::$apisetting['msn_lang'].'/sdk/xfbml.customerchat.js#xfbml=1&version=v3.3');
    wp_register_script('smpush-fb-sdk', 'https://connect.facebook.net/'.self::$apisetting['msn_lang'].'/sdk.js#xfbml=1&version=v2.12');
    wp_register_script('smpush-gmap-source', 'https://maps.googleapis.com/maps/api/js?v=3.exp&key='.self::$apisetting['gmaps_apikey'], array('jquery'), SMPUSHVERSION);

    if(! defined('smpush_logs_mode')){
      if(! empty(self::$apisetting['logs_mode'])){
        define('smpush_logs_mode', true);
      } else {
        define('smpush_logs_mode', false);
      }
    }
  }

  public function add_mime_types($mime_types){
    $mime_types['crt'] = 'application/x-x509-user-cert';
    $mime_types['cer'] = 'application/pkix-cert';
    $mime_types['pem'] = 'application/x-pem-file';
    $mime_types['pfx'] = 'application/x-pkcs12';
    $mime_types['p12'] = 'application/x-pkcs12';
    $mime_types['csr'] = 'application/pkcs10';
    return $mime_types;
  }

  //for future use
  public function add_rewrite_rules(){
    $apiname = self::$apisetting['push_basename'];
    add_rewrite_rule($apiname.'/?$', 'index.php?smpushcontrol=debug', 'top');
    add_rewrite_rule($apiname.'/(.+)$', 'index.php?smpushcontrol=$matches[1]', 'top');
  }

  public static function add_rewrite_rules_ft($apiname){
    add_rewrite_rule($apiname.'/?$', 'index.php?smpushcontrol=debug', 'top');
    add_rewrite_rule($apiname.'/(.+)$', 'index.php?smpushcontrol=$matches[1]', 'top');
  }

  public static function redirect($link){
    echo '<script>window.location = "'.$link.'"</script>';
  }

  public static function setup_bridge(){
    flush_rewrite_rules();
    if(function_exists('wp_cache_flush')){
      wp_cache_flush();
    }
    smpush_unlink(ABSPATH.'/smart_manifest.js');
    smpush_unlink(ABSPATH.'/smart_service_worker.js');
    smpush_unlink(ABSPATH.'/smart_push_sw.js');
    smpush_unlink(ABSPATH.'/smart_firebase_sw.js');
    smpush_unlink(ABSPATH.'/smwp_amp_sw.js');
    smpush_unlink(ABSPATH.'/smart_bridge.php');
    smpush_unlink(smpush_dir.'/js/frontend_webpush.js');
    if(is_multisite()){
      smpush_unlink(smpush_cache_dir.'/settings'.get_current_blog_id());
    }
    else{
      smpush_unlink(smpush_cache_dir.'/settings');
    }

    /*$helper = new smpush_helper();
    $bridgeContents = $helper->readlocalfile(smpush_dir.'/bridge.php');
    $bridgeContents = str_replace('$include_path = \'.\';', '$include_path = \''.smpush_dir.'\';', $bridgeContents);
    $helper->storelocalfile(ABSPATH.'/smart_bridge.php', $bridgeContents);*/

    self::setup_htaccess();
    self::generateCaches();
  }

  public static function generateCaches(){
    if(self::$apisetting['desktop_status'] == 1){
      //if(self::$apisetting['desktop_webpush'] == 0 || self::$apisetting['desktop_webpush_old'] == 1){
        smpush_build_profile::manifest(true);
        smpush_build_profile::service_worker(true);
      //}
    }
  }

  public static function setup_htaccess(){
    if(!file_exists(ABSPATH.'/.htaccess'))return;
    $helper = new smpush_helper();
    $htaccess = $helper->readlocalfile(ABSPATH.'/.htaccess');
    if(empty($htaccess)){
      return;
    }
    $htaccess = preg_replace('/# BEGIN SMART PUSH FAST BRIDGE([\s\S]*?)# END SMART PUSH FAST BRIDGE\s?\n?/i', '', $htaccess);
    if(empty($htaccess)){
      return;
    }
    $smartbridge = "# BEGIN SMART PUSH FAST BRIDGE\n";
    $smartbridge .= "<IfModule mod_rewrite.c>\n";
    $smartbridge .= "RewriteEngine On\n";
    $smartbridge .= "RewriteRule ^".((!empty(self::$apisetting['push_basename']))? self::$apisetting['push_basename'] : 'push')."/([_0-9a-zA-Z-]+)/?(.*)?$ index.php?smpushcontrol=$1/$2&%{QUERY_STRING}\n";
    if(!isset(self::$apisetting['fast_bridge']) || self::$apisetting['fast_bridge'] == 1){
      $smartbridge .= "RewriteCond %{QUERY_STRING} ^smpushcontrol=(get_archive|get_link|go)(.*)$\n";
      $smartbridge .= "RewriteCond %{REQUEST_FILENAME} !-f\n";
      if(file_exists(ABSPATH.'/smart_bridge.php')){
        $smartbridge .= "RewriteRule ^(.*)$ smart_bridge.php?%{QUERY_STRING} [L]\n";
      }
      else{
        $smartbridge .= "RewriteRule ^(.*)$ ".(trim(str_replace(array(realpath(ABSPATH), '\\'), array('','/'), realpath(smpush_dir)), '/'))."/bridge.php?%{QUERY_STRING} [L]\n";
      }
    }
    $smartbridge .= "</IfModule>\n";
    $smartbridge .= "# END SMART PUSH FAST BRIDGE\n";
    if(strpos($htaccess, '# BEGIN SMART PUSH FAST BRIDGE') === false){
      $helper->storelocalfile(ABSPATH.'/.htaccess', $smartbridge.$htaccess);
    }
  }

  public function moveServiceWokrer(){
    global $wp_filesystem;

    if(self::$apisetting['desktop_webpush'] == 1){
      if(!file_exists(ABSPATH . '/smart_push_sw.js') || filesize(ABSPATH . '/smart_push_sw.js') == 0){
        if(file_exists(smpush_dir . '/js/sw.js')){
          $swcontents = $this->readlocalfile(smpush_dir . '/js/sw.js');
          $this->storelocalfile(smpush_dir . '/smart_push_sw.js', $swcontents);
          $wp_filesystem->move(smpush_dir . '/smart_push_sw.js', ABSPATH . '/smart_push_sw.js');
        }
      }
      if(!file_exists(ABSPATH . '/smart_firebase_sw.js') || filesize(ABSPATH . '/smart_firebase_sw.js') == 0){
        $firebase_config = json_decode(self::$apisetting['firebase_config'], true);
        if(file_exists(smpush_dir . '/js/firebase_sw.js') && !empty($firebase_config)){
          $swcontents = $this->readlocalfile(smpush_dir . '/js/firebase_sw.js');
          $this->storelocalfile(smpush_dir . '/smart_firebase_sw.js', str_replace('{SENDER_ID}', $firebase_config['messagingSenderId'], $swcontents));
          $wp_filesystem->move(smpush_dir . '/smart_firebase_sw.js', ABSPATH . '/smart_firebase_sw.js');
          if(!file_exists(ABSPATH . '/smart_firebase_sw.js')){
            $this->storelocalfile(ABSPATH . '/smart_firebase_sw.js', str_replace('{SENDER_ID}', $firebase_config['messagingSenderId'], $swcontents));
          }
        }
      }
    }
    if (self::$apisetting['pwaforwp_support'] == 1 && function_exists('pwaforwp_site_url')){
      $pwa_for_wp = new smpush_support_pwaforwp(self::$apisetting);
      $pwa_for_wp->sw_name_modify('null');
    }
  }

  public function rehubHotCount(){
    if(!empty($_POST['action']) && $_POST['action'] == 'hot-count' && !empty($_POST['post_id'])){
      $post_status = get_post_status($_POST['post_id']);
      if($post_status != 'publish') return;
      //do_action( 'save_post', $_GET['post_id'], get_post($_GET['post_id']));
      wp_update_post(['ID' => $_POST['post_id'], 'post_status' => 'draft']);
      wp_update_post(['ID' => $_POST['post_id'], 'post_status' => 'publish']);
    }
  }

  public function initAction(){
    if(self::$apisetting['desktop_paytoread'] == 2 && empty($_COOKIE['smpush_device_token'])){
      add_filter('the_content', array($this, 'filterProtectContent'), 99, 1);
    }
  }

  public function filterProtectContent($content){
    if(is_single() === false){
      return $content;
    }
    if (preg_match('/bot|crawl|curl|mediapartners|dataprovider|search|get|spider|find|java|majesticsEO|google|yahoo|teoma|contaxe|yandex|libwww-perl|facebook|facebookexternalhit/i', $_SERVER['HTTP_USER_AGENT'])){
      return $content;
    }
    $content = self::ShortHTMLString($content, self::$apisetting['desktop_paytoread_textsize']);
    $content .= '<p style="text-align:center"><button type="button" id="SMIOPayToReadButton" onclick="smpushDrawReqWindow()">'.self::$apisetting['desktop_paytoread_substext'].'</button></p>';
    return $content;
  }

  public static function refresh_linked_user(){
    setcookie('smpush_fresh_linked_user', 'true', (time()+2592000), COOKIEPATH);
    setcookie('smpush_linked_user', '', -1, COOKIEPATH);
  }

  public function wp_logout(){
    //setcookie('smpush_fresh_linked_user', '', -1, COOKIEPATH);
  }

  public function smtp_config($mailer){
    if(self::$apisetting['smtp_status'] == 0){
      return;
    }
    if ( !is_object( $mailer ) ) $mailer = (object) $mailer;
    $mailer->IsSMTP();
    $mailer->Port = self::$apisetting['smtp_port'];
    $mailer->Host = self::$apisetting['smtp_host'];
    $mailer->CharSet = 'utf-8';
    if(!empty(self::$apisetting['smtp_secure'])){
      $mailer->SMTPSecure = self::$apisetting['smtp_secure'];
    }
    if(empty(self::$apisetting['smtp_username'])){
      $mailer->SMTPAuth = false;
    }
    else{
      $mailer->SMTPAuth = true;
      $mailer->Username = self::$apisetting['smtp_username'];
      $mailer->Password = self::$apisetting['smtp_password'];
    }
    $mailer->SMTPDebug = (smpush_env == 'test')? 1 : 0; // enables SMTP debug information (for testing), 1 = errors and messages, 2 = messages only
  }

  public function start_fetch_method(){
    $profile = get_query_var('smpushprofile');
    $method = trim(get_query_var('smpushcontrol'), '/');
    if(!empty($method)){
      if(strpos($method, 'safari/v') !== false){
        new smpush_api('safari', true, $method);
      }
      else{
        new smpush_api($method);
      }
    }
    if(!empty($_GET['smpushprofile'])){
      new smpush_build_profile($_GET['smpushprofile']);
    }
  }

  public function register_vars($vars){
    $vars[] = 'smpushcontrol';
      return $vars;
  }

}
