<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class smpush_localization {

  public static function facebook_langs() {
    return array(
      'af_ZA' => 'Afrikaans',
      'ar_AR' => 'Arabic',
      'az_AZ' => 'Azerbaijani',
      'be_BY' => 'Belarusian',
      'bg_BG' => 'Bulgarian',
      'bn_IN' => 'Bengali',
      'bs_BA' => 'Bosnian',
      'ca_ES' => 'Catalan',
      'cs_CZ' => 'Czech',
      'cy_GB' => 'Welsh',
      'da_DK' => 'Danish',
      'de_DE' => 'German',
      'el_GR' => 'Greek',
      'en_GB' => 'English (UK)',
      'en_PI' => 'English (Pirate)',
      'en_UD' => 'English (Upside Down)',
      'en_US' => 'English (US)',
      'eo_EO' => 'Esperanto',
      'es_ES' => 'Spanish (Spain)',
      'es_LA' => 'Spanish',
      'et_EE' => 'Estonian',
      'eu_ES' => 'Basque',
      'fa_IR' => 'Persian',
      'fb_LT' => 'Leet Speak',
      'fi_FI' => 'Finnish',
      'fo_FO' => 'Faroese',
      'fr_CA' => 'French (Canada)',
      'fr_FR' => 'French (France)',
      'fy_NL' => 'Frisian',
      'ga_IE' => 'Irish',
      'gl_ES' => 'Galician',
      'he_IL' => 'Hebrew',
      'hi_IN' => 'Hindi',
      'hr_HR' => 'Croatian',
      'hu_HU' => 'Hungarian',
      'hy_AM' => 'Armenian',
      'id_ID' => 'Indonesian',
      'is_IS' => 'Icelandic',
      'it_IT' => 'Italian',
      'ja_JP' => 'Japanese',
      'ka_GE' => 'Georgian',
      'km_KH' => 'Khmer',
      'ko_KR' => 'Korean',
      'ku_TR' => 'Kurdish',
      'la_VA' => 'Latin',
      'lt_LT' => 'Lithuanian',
      'lv_LV' => 'Latvian',
      'mk_MK' => 'Macedonian',
      'ml_IN' => 'Malayalam',
      'ms_MY' => 'Malay',
      'nb_NO' => 'Norwegian (bokmal)',
      'ne_NP' => 'Nepali',
      'nl_NL' => 'Dutch',
      'nn_NO' => 'Norwegian (nynorsk)',
      'pa_IN' => 'Punjabi',
      'pl_PL' => 'Polish',
      'ps_AF' => 'Pashto',
      'pt_BR' => 'Portuguese (Brazil)',
      'pt_PT' => 'Portuguese (Portugal)',
      'ro_RO' => 'Romanian',
      'ru_RU' => 'Russian',
      'sk_SK' => 'Slovak',
      'sl_SI' => 'Slovenian',
      'sq_AL' => 'Albanian',
      'sr_RS' => 'Serbian',
      'sv_SE' => 'Swedish',
      'sw_KE' => 'Swahili',
      'ta_IN' => 'Tamil',
      'te_IN' => 'Telugu',
      'th_TH' => 'Thai',
      'tl_PH' => 'Filipino',
      'tr_TR' => 'Turkish',
      'uk_UA' => 'Ukrainian',
      'vi_VN' => 'Vietnamese',
      'zh_CN' => 'Simplified Chinese (China)',
      'zh_HK' => 'Traditional Chinese (Hong Kong)',
      'zh_TW' => 'Traditional Chinese (Taiwan)',
    );
  }
  
  public static function load_textdomain() {
    load_plugin_textdomain('smio-push-notification', false, basename(smpush_dir).'/language');
  }
  
  public static function javascript() {
    wp_localize_script('smpush-mainscript', 'smpush_jslang', array(
    'event_no_post' => esc_html__('Please create at least one post of this post type to enable creating a push event for it', 'smio-push-notification'),
    'applytoall' => esc_html__('Action will be applied to all results, continue?', 'smio-push-notification'),
    'deleteconfirm' => esc_html__('Are you sure you want to continue?', 'smio-push-notification'),
    'savechangesconfirm' => esc_html__('Do you want to save current changes?', 'smio-push-notification'),
    'no_tokens_msg' => esc_html__('There is no tokens accept your choices', 'smio-push-notification'),
    'start_queuing' => esc_html__('Start queuing', 'smio-push-notification'),
    'token_in_queue' => esc_html__('token in the queue table', 'smio-push-notification'),
    'escaped_reconnect' => esc_html__('Escaped and try reconnect...', 'smio-push-notification'),
    'completed' => esc_html__('Completed', 'smio-push-notification'),
    'message_queuing_completed' => esc_html__('message queuing completed and start now in sending process', 'smio-push-notification'),
    'message_queuing_scheduling' => esc_html__('message queued successfully for scheduling send', 'smio-push-notification'),
    'exit_and_back' => esc_html__('Exit and return back', 'smio-push-notification'),
    'error_refresh' => esc_html__('Error ocurred refresh the page', 'smio-push-notification'),
    'start_feedback' => esc_html__('Start feedback service', 'smio-push-notification'),
    ));
  }

}
