<form action="<?php echo esc_url($pageurl);?>&noheader=1" method="post" id="smpush_jform" class="validate">
<input type="hidden" name="id" value="<?php echo esc_attr($connection['id']);?>">
<input type="hidden" name="type" value="<?php echo esc_attr($connection['dbtype']);?>">
   <div id="post-body" class="metabox-holder columns-2">
      <div id="post-body-content" class="edit-form-section">
         <div id="namediv" class="stuffbox">
            <h3><label><?php echo (empty(esc_attr($connection['title'])))? esc_html__('Add New Connection', 'smio-push-notification') : esc_attr($connection['title']);?></label></h3>
            <div class="inside">
               <table class="form-table">
                <tbody>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Title', 'smio-push-notification')?></td>
                     <td><input name="title" type="text" size="40" value="<?php echo esc_attr($connection['title']);?>" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Description', 'smio-push-notification')?></td>
                     <td><textarea name="description" rows="5" cols="40"><?php echo esc_attr($connection['description']);?></textarea></td>
                  </tr>
                  <?php if(esc_attr($connection['dbtype']) == ''){?>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Connection Type', 'smio-push-notification')?></td>
                     <td>
                     <select name="type" onchange="if(this.value=='remote'){jQuery('.smpush_select_conn').show()}else{jQuery('.smpush_select_conn').hide()}">
                        <option value="localhost"><?php echo esc_html__('Wordpress Database', 'smio-push-notification')?></option>
                        <option value="remote"><?php echo esc_html__('Remote Connection', 'smio-push-notification')?> <?php echo esc_html__('[Deprecated]', 'smio-push-notification')?></option>
                     </select>
                     </td>
                  </tr>
                  <?php }$style = (esc_attr($connection['dbtype']) == 'remote')?'':'style="display:none;"';?>
                  <tr valign="top" class="smpush_select_conn" <?php echo $style;?>>
                     <td class="first"><?php echo esc_html__('DB Host', 'smio-push-notification')?></td>
                     <td class="form-required"><input name="dbhost" value="<?php echo esc_attr($connection['dbhost']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top" class="smpush_select_conn" <?php echo $style;?>>
                     <td class="first"><?php echo esc_html__('DB Name', 'smio-push-notification')?></td>
                     <td class="form-required"><input name="dbname" value="<?php echo esc_attr($connection['dbname']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top" class="smpush_select_conn" <?php echo $style;?>>
                     <td class="first"><?php echo esc_html__('DB Username', 'smio-push-notification')?></td>
                     <td class="form-required"><input name="dbuser" value="<?php echo esc_attr($connection['dbuser']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top" class="smpush_select_conn" <?php echo $style;?>>
                     <td class="first"><?php echo esc_html__('DB Password', 'smio-push-notification')?></td>
                     <td><input name="dbpass" value="<?php echo esc_attr($connection['dbpass']);?>" type="password" size="40"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Table Name', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="tbname" value="<?php echo esc_attr($connection['tbname']);?>" type="text" size="40" aria-required="true">
                     <p class="description"><?php echo esc_html__('Use', 'smio-push-notification')?> {wp_prefix} <?php echo esc_html__('for the Wordpress prefix table value', 'smio-push-notification')?></p>
                	 </td>
                  </tr>
                  <tr valign="top"><th colspan="2"><?php echo esc_html__('Column Names', 'smio-push-notification')?></th></tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('ID', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="id_name" value="<?php echo esc_attr($connection['id_name']);?>" type="text" size="40" aria-required="true">
                     <p class="description"><?php echo esc_html__('The table primary key name', 'smio-push-notification')?></p>
                	 </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Device Token', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="token_name" value="<?php echo esc_attr($connection['token_name']);?>" type="text" size="40" aria-required="true">
                     <p class="description"><?php echo esc_html__('Table column that stores the devices token value', 'smio-push-notification')?></p>
                	 </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('MD5 Device Token', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="md5token_name" value="<?php echo esc_attr($connection['md5token_name']);?>" type="text" size="40" aria-required="true">
                     <p class="description"><?php echo esc_html__('Table column that stores the devices token value  as MD5 string for optimized queries later', 'smio-push-notification')?></p>
                	 </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Active', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="active_name" value="<?php echo esc_attr($connection['active_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores the devices status 1 or 0', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Firebase', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="firebase_name" value="<?php echo esc_attr($connection['firebase_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores if the device is Firebase token or not 1 or 0', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Latitude', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="latitude_name" value="<?php echo esc_attr($connection['latitude_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores the devices GPS location latitude point', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Longitude', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="longitude_name" value="<?php echo esc_attr($connection['longitude_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores the devices GPS location longitude point', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('GPS update time', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="gpstime_name" value="<?php echo esc_attr($connection['gpstime_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores GPS update time', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('GPS timeout', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="geotimeout_name" value="<?php echo esc_attr($connection['geotimeout_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores GPS timeout', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Information', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="info_name" value="<?php echo esc_attr($connection['info_name']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('The table column that stores the devices information like device name, version and model', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Added Time', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                     <td><input name="postdate" value="<?php echo esc_attr($connection['postdate']);?>" type="text" size="40">
                     <p class="description"><?php echo esc_html__('The table column that stores the devices added time', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Counter', 'smio-push-notification')?><br />(<?php echo esc_html__('optional', 'smio-push-notification')?>)</td>
                    <td><input name="counter_name" value="<?php echo esc_attr($connection['counter_name']);?>" type="text" size="40">
                      <p class="description"><?php echo esc_html__('The table column that stores the number of times device receive messages', 'smio-push-notification')?></p></td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Device Type', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="type_name" value="<?php echo esc_attr($connection['type_name']);?>" type="text" size="40" aria-required="true">
                     <p class="description"><?php echo esc_html__('Name of the table column that stores the devices type', 'smio-push-notification')?></p>
                	 </td>
                  </tr>
                  <tr valign="top"><th colspan="2"><?php echo esc_html__('Device Type Values', 'smio-push-notification')?></th></tr>
                  <tr valign="top">
                     <td class="first">iOS</td>
                     <td class="form-required"><input name="ios_name" value="<?php echo esc_attr($connection['ios_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">iOS FCM</td>
                     <td class="form-required"><input name="iosfcm_name" value="<?php echo esc_attr($connection['iosfcm_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Android</td>
                     <td class="form-required"><input name="android_name" value="<?php echo esc_attr($connection['android_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Windows Phone 8</td>
                     <td class="form-required"><input name="wp_name" value="<?php echo esc_attr($connection['wp_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Windows 10</td>
                     <td class="form-required"><input name="wp10_name" value="<?php echo esc_attr($connection['wp10_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">BlackBerry</td>
                     <td class="form-required"><input name="bb_name" value="<?php echo esc_attr($connection['bb_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Chrome</td>
                     <td class="form-required"><input name="chrome_name" value="<?php echo esc_attr($connection['chrome_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Safari</td>
                     <td class="form-required"><input name="safari_name" value="<?php echo esc_attr($connection['safari_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Firefox</td>
                     <td class="form-required"><input name="firefox_name" value="<?php echo esc_attr($connection['firefox_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Opera</td>
                     <td class="form-required"><input name="opera_name" value="<?php echo esc_attr($connection['opera_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Edge</td>
                     <td class="form-required"><input name="edge_name" value="<?php echo esc_attr($connection['edge_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Samsung Browser</td>
                     <td class="form-required"><input name="samsung_name" value="<?php echo esc_attr($connection['samsung_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Viber</td>
                     <td class="form-required"><input name="viber_name" value="<?php echo esc_attr($connection['viber_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Facebook Messenger</td>
                     <td class="form-required"><input name="fbmsn_name" value="<?php echo esc_attr($connection['fbmsn_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Facebook Notification</td>
                     <td class="form-required"><input name="fbnotify_name" value="<?php echo esc_attr($connection['fbnotify_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                     <td class="first">Newsletter</td>
                     <td class="form-required"><input name="email_name" value="<?php echo esc_attr($connection['email_name']);?>" type="text" size="40" aria-required="true"></td>
                  </tr>
                  <tr valign="top">
                      <td colspan="2"><input type="submit" name="submit" id="smio-submit" class="button button-primary" style="width: 120px;" value="<?php echo esc_html__('Save Changes', 'smio-push-notification')?>">
                      <img src="<?php echo smpush_imgpath;?>/wpspin_light.gif" class="smpush_process" alt="" /></td>
                   </tr>
                </tbody>
              </table>
            </div>
         </div>
      </div>
   </div>
</form>
