<form action="<?php echo esc_url($pageurl);?>&noheader=1" method="post" id="smpush_jform" class="validate">
  <div id="smpush_errors_holder"></div>
<input type="hidden" name="id" value="<?php echo esc_attr($event['id']);?>">
   <div id="post-body" class="metabox-holder columns-2">
      <div id="post-body-content" class="edit-form-section">
         <div id="namediv" class="stuffbox">
            <h3><label><?php echo (empty(esc_attr($event['title'])))? esc_html__('Add New Event', 'smio-push-notification') : esc_attr($event['title']);?></label></h3>
            <div class="inside">
               <table class="form-table">
                <tbody>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Title', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="title" type="text" size="60" value="<?php echo esc_attr($event['title']);?>" aria-required="true">
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Event Type', 'smio-push-notification')?></td>
                     <td>
                     <select name="event_type">
                        <option value="publish"><?php echo esc_html__('Published for first time', 'smio-push-notification')?></option>
                        <option value="approve" <?php if(esc_attr($event['event_type']) == 'approve'){?>selected="selected"<?php }?>><?php echo esc_html__('Get approval to publish', 'smio-push-notification')?></option>
                        <option value="update" <?php if(esc_attr($event['event_type']) == 'update'){?>selected="selected"<?php }?>><?php echo esc_html__('Get new changes or updates', 'smio-push-notification')?></option>
                     </select>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Post Type', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <select name="event_post_type" class="smpushPostType" aria-required="true">
                       <option value=""><?php echo esc_html__('Select Post Type', 'smio-push-notification')?></option>
                      <?php foreach(get_post_types('', 'names') as $post_type): ?>
                        <option value="<?php echo esc_attr($post_type)?>" <?php if(esc_attr($event['post_type']) == $post_type){?>selected="selected"<?php }?>><?php echo esc_attr($post_type) ?></option>
                      <?php endforeach; ?>
                     </select>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Message Template', 'smio-push-notification')?></td>
                     <td>
                      <select name="msg_template">
                       <option value="0"><?php echo esc_html__('Select Message Template', 'smio-push-notification')?></option>
                      <?php if(!empty($templates)):foreach($templates as $template): ?>
                        <option value="<?php echo esc_attr($template['id']) ?>" <?php if(esc_attr($event['msg_template']) == $template['id']){?>selected="selected"<?php }?>><?php echo esc_attr($template['id'].'- '.$template['name']) ?></option>
                      <?php endforeach;endif; ?>
                      </select>
                     </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Title', 'smio-push-notification')?></td>
                    <td>
                      <div id="smpush-msg-subject" class="tabs-panel">
                        <?php include('event_form_quickadd.php')?>
                        <br class="clear">
                        <input name="subject" id="smpushEventSubject" class="smpushEventMessage" value="<?php echo esc_attr($event['subject']);?>" size="60" />
                      </div>
                    </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Notification Message', 'smio-push-notification')?></td>
                     <td>
                       <div class="categorydiv smpush_tabs">
                          <ul class="category-tabs">
                            <li><a href="#smpush-msg-desktop"><?php echo esc_html__('Web & Mobile', 'smio-push-notification')?></a></li>
                            <li><a href="#smpush-msg-fbmsn"><?php echo esc_html__('FB Messenger', 'smio-push-notification')?></a></li>
                            <li><a href="#smpush-msg-fbnotify"><?php echo esc_html__('FB Notification', 'smio-push-notification')?></a></li>
                            <li><a href="#smpush-msg-viber"><?php echo esc_html__('Viber', 'smio-push-notification')?></a></li>
                            <li><a href="#smpush-msg-email"><?php echo esc_html__('Newsletter', 'smio-push-notification')?></a></li>
                          </ul>
                          <div id="smpush-msg-desktop" class="tabs-panel">
                            <table class="form-table">
                                <tr valign="top">
                                  <td>
                                    <?php include('event_form_quickadd.php')?>
                                    <br class="clear">
                                    <textarea name="message" rows="6" cols="40" style="width:95%" id="smpushEventMessageWeb" class="smpushEventMessage" aria-required="true"><?php echo esc_attr($event['message']);?></textarea>
                                  </td>
                                </tr>
                            </table>
                          </div>
                          <div id="smpush-msg-fbmsn" class="tabs-panel">
                            <table class="form-table">
                                <tr valign="top">
                                  <td>
                                    <?php include('event_form_quickadd.php')?>
                                    <br class="clear">
                                    <textarea name="fbmsn_message" rows="6" cols="40" style="width:95%" id="smpushEventMessageMsn" class="smpushEventMessage" aria-required="true"><?php echo esc_attr($event['fbmsn_message']);?></textarea>
                                  </td>
                                </tr>
                            </table>
                          </div>
                         <div id="smpush-msg-fbnotify" class="tabs-panel">
                            <table class="form-table">
                                <tr valign="top">
                                  <td>
                                    <?php include('event_form_quickadd.php')?>
                                    <br class="clear">
                                    <textarea name="fbnotify_message" rows="6" cols="40" style="width:95%" id="smpushEventMessageFBNotify" class="smpushEventMessage" aria-required="true"><?php echo esc_attr($event['fbnotify_message']);?></textarea>
                                  </td>
                                </tr>
                            </table>
                          </div>
                         <div id="smpush-msg-email" class="tabs-panel">
                            <table class="form-table">
                                <tr valign="top">
                                  <td>
                                    <?php include('event_form_quickadd.php')?>
                                    <br class="clear">
                                    <textarea name="email_message" rows="30" cols="40" style="width:95%" id="smpushEventMessageEmail" class="smpushEventMessage" aria-required="true"><?php echo esc_attr($event['email_message']);?></textarea>
                                  </td>
                                </tr>
                            </table>
                          </div>
                         <div id="smpush-msg-viber" class="tabs-panel">
                            <table class="form-table">
                                <tr valign="top">
                                  <td>
                                    <?php include('event_form_quickadd.php')?>
                                    <br class="clear">
                                    <textarea name="viber_message" rows="6" cols="40" style="width:95%" id="smpushEventMessageViber" class="smpushEventMessage" aria-required="true"><?php echo esc_attr($event['viber_message']);?></textarea>
                                  </td>
                                </tr>
                            </table>
                          </div>
                      </div>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Mobile Payload', 'smio-push-notification')?></td>
                     <td>
                       <input type="text" id="smpushPayloadTitle" size="15" placeholder="<?php echo esc_html__('Parameter Name', 'smio-push-notification')?>" style="float:left;margin:0 5px 10px 0">
                       <select id="smpushPayload" class="smpushPostAttriSelector" style="width:150px;float:left;margin:0 5px 10px 0">
                          <option value=""><?php echo esc_html__('Choose Attribute', 'smio-push-notification')?></option>
                        </select>
                       <select id="smpushPayloadFormat" style="float:left;margin:0 5px 10px 0">
                          <option value="regular"><?php echo esc_html__('Select Format', 'smio-push-notification')?></option>
                          <option value="CapitalizeFirst">CapitalizeFirst</option>
                          <option value="CapitalizeAllFirst">CapitalizeAllFirst</option>
                          <option value="UPPERCASE">UPPERCASE</option>
                          <option value="lowercase">lowercase</option>
                          <option value="datetime">Date Time</option>
                          <option value="date">Date</option>
                          <option value="regular">Regular</option>
                        </select>
                       <select id="smpushPayloadFunction" class="smpushPostFunctions" style="float:left;margin:0 5px 10px 0">
                          <option value=""><?php echo esc_html__('Pass ID To Function And Get', 'smio-push-notification')?></option>
                        </select>
                       <input type="text" id="smpushPayloadDefault" size="15" placeholder="<?php echo esc_html__('Default Value', 'smio-push-notification')?>" style="float:left;margin:0 5px 10px 0">
                       <input type="button" class="smpushInsertPayload button button-primary" style="float:left;margin:0 5px 5px 0" value="<?php echo esc_html__('Insert', 'smio-push-notification')?>">
                       <br class="clear">
                       <div id="smpushPayloadFields">
                         <?php if(!empty($event['payload_fields'])): foreach($event['payload_fields']['field'] as $key => $field): ?>
                         <p class="smpush-clear">
                          <input name="payload[field][]" value="<?php echo esc_attr($event['payload_fields']['field'][$key]) ?>" type="text" size="15" style="float:left;margin:0 5px">
                          <input name="payload[value][]" value="<?php echo esc_attr($event['payload_fields']['value'][$key]) ?>" type="text" size="30" style="float:left;margin:0 5px">
                          <input type="button" class="button button-primary" onclick="jQuery(this).closest('p').remove();" style="float:left;margin:0 5px" value="<?php echo esc_html__('Remove', 'smio-push-notification')?>">
                         </p>
                         <?php endforeach; endif; ?>
                       </div>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Ignore Case', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="ignore" type="checkbox" <?php if(esc_attr($event['ignore']) == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Ignore sending the message if one of its variables is empty or equal zero value .', 'smio-push-notification')?></label>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Conditions', 'smio-push-notification')?></td>
                     <td class="smpushEventConditions">
                       <?php if(!empty($event['conditions'])): foreach($event['conditions']['attri'] as $key => $condition): ?>
                       <p class="smpush-clear">
                          <input name="conditions[attri][]" value="<?php echo esc_attr($event['conditions']['attri'][$key]) ?>" type="text" size="15" style="float:left;margin:0 5px">
                          <input name="conditions[sign][]" value="<?php echo esc_attr($event['conditions']['sign'][$key]) ?>" type="text" size="15" style="float:left;margin:0 5px">
                          <input name="conditions[value][]" value="<?php echo esc_attr($event['conditions']['value'][$key]) ?>" type="text" size="25" style="float:left;margin:0 5px">
                          <input type="button" class="button button-primary" onclick="jQuery(this).closest('p').remove();" style="float:left;margin:0 5px" value="<?php echo esc_html__('Remove', 'smio-push-notification')?>">
                       </p>
                       <?php endforeach; endif; ?>
                       <div class="smpush-clear">
                          <select name="conditions[attri][]" class="smpushPostAttriSelector" style="width:150px;float:left;margin:0 5px">
                             <option value=""><?php echo esc_html__('Choose Attribute', 'smio-push-notification')?></option>
                           </select>
                         <select name="conditions[sign][]" style="width:120px;float:left;margin:0 5px 5px 0" onchange="smpushUpdateValueField(this)">
                            <option data-placeholder="<?php echo esc_html__('Write Value', 'smio-push-notification')?>" value=""><?php echo esc_html__('Choose Sign', 'smio-push-notification')?></option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>">></option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>">>=</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>"><</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>"><=</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>">=</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 or Now() or Date()', 'smio-push-notification')?>">NOT =</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 , value , value , 3', 'smio-push-notification')?>">IN</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 , value , value , 3', 'smio-push-notification')?>">NOT IN</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 , value , value , 3', 'smio-push-notification')?>">INTERSECT</option>
                             <option data-placeholder="<?php echo esc_html__('e.g. 1 , value , value , 3', 'smio-push-notification')?>">NOT INTERSECT</option>
                           </select>
                         <input name="conditions[value][]" class="smpushPostAttriSelectorValue" type="text" size="25" placeholder="<?php echo esc_html__('Write Value', 'smio-push-notification')?>" style="float:left;margin:0 5px">
                          <input type="button" class="button button-primary" onclick="smpushEventAddRow(this)" style="float:left;margin:0 5px" value="<?php echo esc_html__('AND', 'smio-push-notification')?>">
                          <input type="button" class="button button-primary" onclick="smpushEventDelRow(this)" style="float:left;margin:0 5px" value="<?php echo esc_html__('Remove', 'smio-push-notification')?>">
                       </div>
                     </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Subscription Page', 'smio-push-notification')?></td>
                    <td>
                      <select name="subs_filter">
                        <option value="all"><?php echo esc_html__('Send to all', 'smio-push-notification')?></option>
                        <option value="only_have" <?php if(esc_attr($event['subs_filter']) == 'only_have'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Send to users that have a subscription only', 'smio-push-notification')?></option>
                        <option value="not_have" <?php if(esc_attr($event['subs_filter']) == 'not_have'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Send to all users except users that have a subscription', 'smio-push-notification')?></option>
                      </select>
                    </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Notify Segment', 'smio-push-notification')?></td>
                     <td>
                       <select name="notify_segment" onchange="if(this.value == 'custom'){jQuery('.smpush_userid_field').show();}else{jQuery('.smpush_userid_field').hide();}">
                         <option value="all"><?php echo esc_html__('All Registered Users', 'smio-push-notification')?></option>
                         <option value="post_owner" <?php if(esc_attr($event['notify_segment']) == 'post_owner'):?>selected="selected"<?php endif;?>><?php echo esc_html__('User that published the post', 'smio-push-notification')?></option>
                         <option value="post_commenters" <?php if(esc_attr($event['notify_segment']) == 'post_commenters'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Users add a comment in the post', 'smio-push-notification')?></option>
                         <option value="comment_mentions" <?php if(esc_attr($event['notify_segment']) == 'comment_mentions'):?>selected="selected"<?php endif;?>><?php echo esc_html__('[bbPress] Users that mentioned in the comment', 'smio-push-notification')?></option>
                         <option value="quoted_comment" <?php if(esc_attr($event['notify_segment']) == 'quoted_comment'):?>selected="selected"<?php endif;?>><?php echo esc_html__('[bbPress] User that has been replied on his comment', 'smio-push-notification')?></option>
                         <option value="tev_attendees" <?php if(esc_attr($event['notify_segment']) == 'tev_attendees'):?>selected="selected"<?php endif;?>><?php echo esc_html__('[The Events Calendar] Tickets orders and attendees', 'smio-push-notification')?></option>
                         <option value="custom" <?php if(esc_attr($event['notify_segment']) == 'custom'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Specify a user ID attribute', 'smio-push-notification')?></option>
                        </select>
                     </td>
                  </tr>
                  <tr valign="top" class="smpush_userid_field" <?php if(esc_attr($event['notify_segment']) != 'custom'):?>style="display:none"<?php endif;?>>
                     <td class="first"><?php echo esc_html__('User ID Device', 'smio-push-notification')?></td>
                     <td class="form-required">
                       <input name="userid_field" value="<?php echo esc_attr($event['userid_field']) ?>" type="text" id="smpushUserAttriValue" size="22">
                       <select class="smpushPostAttriSelector" style="width:150px;" onchange="jQuery('#smpushUserAttriValue').val(jQuery(this).val())">
                           <option value=""><?php echo esc_html__('Choose Attribute', 'smio-push-notification')?></option>
                        </select>
                       <p class="description"><?php echo esc_html__('Select the userID attribute to send the device that is related to this userID value only .', 'smio-push-notification')?></p>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('One Time Push', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="once_notify" type="checkbox" <?php if(esc_attr($event['once_notify']) == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Each user receive one notification only about the same post.', 'smio-push-notification')?></label>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Desktop Push Link', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="desktop_link" type="checkbox" <?php if(esc_attr($event['desktop_link']) == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable open the post link when click on desktop push notification', 'smio-push-notification')?></label>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Newsletter', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="email" type="checkbox" <?php if(esc_attr($event['email']) == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Send email notifications to all WordPress users', 'smio-push-notification')?></label>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Status', 'smio-push-notification')?></td>
                     <td>
                      <input name="status" type="checkbox" <?php if(esc_attr($event['status']) == 1) { ?>checked="checked"<?php } ?>>
                     </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2"><input type="submit" name="submit" id="smio-submit" class="button button-primary" style="width: 120px;" value="<?php echo esc_html__('Save Changes', 'smio-push-notification')?>">
                    <img src="<?php echo smpush_imgpath;?>/wpspin_light.gif" class="smpush_process" alt="" /></td>
                 </tr>
                </tbody>
              </table>
            </div>
         </div>
      </div>
   </div>
</form>
<script type="text/javascript">
jQuery(document).ready(function() {
  "use strict";
  
  smpushAutoLoad("#smpush_jform");
  
jQuery(".smpushInsertPayload").on("click", function(){
   if(jQuery("#smpushPayload").val() == "" || jQuery("#smpushPayloadTitle").val() == ""){
     return;
   }
   let title = jQuery("#smpushPayloadTitle").val();
   let insert = "{$"+jQuery("#smpushPayload").val();
   if(jQuery("#smpushPayloadFormat").val() != ""){
     insert += "|"+jQuery("#smpushPayloadFormat").val();
   }
   if(jQuery("#smpushPayloadDefault").val() != ""){
     let defValue = jQuery("#smpushPayloadDefault").val();
     defValue = defValue.replace("{", "");
     defValue = defValue.replace("}", "");
     defValue = defValue.replace("$", "");
     insert += "|"+defValue;
   }
   else{
     insert += "|null";
   }
   if(jQuery("#smpushPayloadFunction").val() != ""){
     insert += "|"+jQuery("#smpushPayloadFunction").val();
   }
   insert += "}";
   let html = '<p class="smpush-clear">';
   html += '<input name="payload[field][]" value="'+title+'" type="text" size="15" style="float:left;margin:0 5px">';
   html += '<input name="payload[value][]" value="'+insert+'" type="text" size="30" style="float:left;margin:0 5px">';
   html += '<input type="button" class="button button-primary" onclick="jQuery(this).closest(\'p\').remove();" style="float:left;margin:0 5px" value="<?php echo esc_html__('Remove', 'smio-push-notification')?>">';
   html += '</p>';
   jQuery("#smpushPayloadFields").append(html);
 });
 
 jQuery(".smpushInsertAtrri").on("click", function(){
   let container = jQuery("#"+jQuery(this).closest("div.tabs-panel").attr("id"));
   
   if(container.find(".smpushPostAttri").val() == ""){
     return;
   }
   let insert = "{$"+container.find(".smpushPostAttri").val();
   if(container.find(".smpushPostAttriFormat").val() != ""){
     insert += "|"+container.find(".smpushPostAttriFormat").val();
   }
   if(container.find(".smpushPostAttriDefault").val() != ""){
     let defValue = container.find(".smpushPostAttriDefault").val();
     defValue = defValue.replace("{", "");
     defValue = defValue.replace("}", "");
     defValue = defValue.replace("$", "");
     insert += "|"+defValue;
   }
   else{
     insert += "|null";
   }
   if(container.find(".smpushPostAttriFunction").val() != ""){
     insert += "|"+container.find(".smpushPostAttriFunction").val();
   }
   insert += "}";
   smpushInsertAtCaret(container.find(".smpushEventMessage").attr("id"), insert);
   container.find(".smpushPostAttriFormat").val("regular");
   container.find(".smpushPostAttriFunction").val("");
   container.find(".smpushPostAttriDefault").val("");
 });
 
 jQuery(".smpushPostType").on("change", function(){
   if(jQuery(this).val() == ""){
     return;
   }
   jQuery(".smpush_service_-1_loading").show();
   jQuery.get("<?php echo esc_url($pageurl)?>&loadAttri=1", {"noheader": 1, "smpush_post_type" : jQuery(this).val()}, function(data){
     jQuery(".smpush_service_-1_loading").hide();
     data = JSON.parse(data);
     if(data["status"] == 0){
       alert(smpush_jslang.event_no_post);
       return;
     }
     jQuery(".smpushPostFunctions").html(data["postFuncs"]);
     jQuery(".smpushPostAttriSelector").html(data["postAttrs"]);
   });
 });
 if(jQuery(".smpushPostType").val() != ""){
   jQuery(".smpushPostType").trigger("change");
 }
});
</script>
