<form action="<?php echo esc_url($pageurl);?>&noheader=1" method="post" id="smpush_jform" class="validate">
<input type="hidden" name="id" value="<?php echo esc_attr($source['id']);?>">
   <div id="post-body" class="metabox-holder columns-2">
      <div id="post-body-content" class="edit-form-section">
         <div id="namediv" class="stuffbox">
            <h3><label><?php echo (empty(esc_attr($source['title'])))? esc_html__('Add New Source', 'smio-push-notification') : esc_attr($source['title']);?></label></h3>
            <div class="inside">
               <table class="form-table">
                <tbody>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Title', 'smio-push-notification')?></td>
                     <td class="form-required">
                     <input name="title" type="text" size="40" value="<?php echo esc_attr($source['title']);?>" aria-required="true">
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('RSS Link', 'smio-push-notification')?></td>
                     <td class="form-required">
                       <input name="link" type="url" size="60" value="<?php echo urldecode(esc_attr($source['link']));?>" aria-required="true">
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Message Template', 'smio-push-notification')?></td>
                     <td>
                     <select name="campid" aria-required="true">
                       <option value="0"><?php echo esc_html__('Select Message Template', 'smio-push-notification')?></option>
                      <?php if(!empty($templates)):foreach($templates as $template): ?>
                        <option value="<?php echo esc_attr($template['id']) ?>" <?php if(esc_attr($source['campid']) == $template['id']){?>selected="selected"<?php }?>><?php echo esc_attr($template['id'].'- '.$template['name']) ?></option>
                      <?php endforeach;endif; ?>
                     </select>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Text Limit', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="text_limit" type="number" size="6" value="<?php echo esc_attr($source['text_limit']);?>"> <?php echo esc_html__('Limit number of characters for the content of feed items.', 'smio-push-notification')?></label>
                       <p class="description"><?php echo esc_html__('Set it 0 for unlimited number of new fetched items.', 'smio-push-notification')?></p>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Read Limit', 'smio-push-notification')?></td>
                     <td>
                       <label><input name="read_limit" type="number" size="6" value="<?php echo esc_attr($source['read_limit']);?>"> <?php echo esc_html__('Limit number of new fetched items each time.', 'smio-push-notification')?></label>
                       <p class="description"><?php echo esc_html__('Set it 0 for unlimited number of new fetched items.', 'smio-push-notification')?></p>
                     </td>
                  </tr>
                  <tr valign="top">
                     <td class="first"><?php echo esc_html__('Status', 'smio-push-notification')?></td>
                     <td>
                      <input name="active" type="checkbox" <?php if(esc_attr($source['active']) == 1) { ?>checked="checked"<?php } ?>>
                     </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2"><input type="submit" name="submit" id="smio-submit" class="button button-primary" style="width: 120px;" value="<?php echo esc_html__('Save Changes', 'smio-push-notification')?>">
                    <img src="<?php echo smpush_imgpath;?>/wpspin_light.gif" class="smpush_process" alt="" /></td>
                 </tr>
                </tbody>
              </table>
            </div>
         </div>
      </div>
   </div>
</form>
