<div class="wrap">
  <div id="smpush-icon-devsetting" class="icon32"><br></div>
  <h2><?php echo esc_html__('Smart Notification Settings', 'smio-push-notification')?></h2>

  <p class="description" style="color:red;text-align: right"><?php echo esc_html__('Notice: Please reset your cache plugin and purge all cache after changing any options. still face problems please check our', 'smio-push-notification')?> <a href="https://smartiolabs.com/product/push-notification-system/documentation#faq" target="_blank"><?php echo esc_html__('FAQ', 'smio-push-notification')?></a></p>

  <div id="col-container" class="smpush-settings-page">
    <form action="<?php echo $page_url; ?>" method="post" id="smpush_jform" class="validate">
      
      <input class="smpush_jradio" name="selectDIV" value="general" type="radio" data-icon="<?php echo smpush_imgpath; ?>/cogs.png" data-labelauty='<?php echo esc_html__('General', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="mobile" type="radio" data-icon="<?php echo smpush_imgpath; ?>/mobile.png" data-labelauty='<?php echo esc_html__('Mobile Push', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="web" type="radio" data-icon="<?php echo smpush_imgpath; ?>/web.png" data-labelauty='<?php echo esc_html__('Web Push', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="messenger" type="radio" data-icon="<?php echo smpush_imgpath; ?>/messenger.png" data-labelauty='<?php echo esc_html__('Messenger', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="viber" type="radio" data-icon="<?php echo smpush_imgpath; ?>/viber.png" data-labelauty='<?php echo esc_html__('Viber', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="facebook" type="radio" data-icon="<?php echo smpush_imgpath; ?>/facebook.png" data-labelauty='<?php echo esc_html__('Notifications', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="email" type="radio" data-icon="<?php echo smpush_imgpath; ?>/email.png" data-labelauty='<?php echo esc_html__('Newsletter', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="subs_page" type="radio" data-icon="<?php echo smpush_imgpath; ?>/form.png" data-labelauty='<?php echo esc_html__('Subscription Page', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="events" type="radio" data-icon="<?php echo smpush_imgpath; ?>/events.png" data-labelauty='<?php echo esc_html__('Events', 'smio-push-notification')?>' />
      <input class="smpush_jradio" name="selectDIV" value="gdpr" type="radio" data-icon="<?php echo smpush_imgpath; ?>/gdpr.png" data-labelauty='GDPR' />

      <div id="col-left" class="smpush-tabs-mobile smpush-tabs-ios smpush-tabs-android smpush-tabs-windows smpush-tabs-blackberry smpush-radio-tabs" style="display:none">
        <input class="smpush_jradio" name="selectDIV" value="ios" type="radio" data-icon="<?php echo smpush_imgpath; ?>/apple.png" data-labelauty='<?php echo esc_html__('iOS', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="android" type="radio" data-icon="<?php echo smpush_imgpath; ?>/android.png" data-labelauty='<?php echo esc_html__('Android', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="windows" type="radio" data-icon="<?php echo smpush_imgpath; ?>/wp.png" data-labelauty='<?php echo esc_html__('WP', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="blackberry" type="radio" data-icon="<?php echo smpush_imgpath; ?>/blackberry.png" data-labelauty='<?php echo esc_html__('BlackBerry', 'smio-push-notification')?>' />
      </div>
      
      <div id="col-left" class="smpush-tabs-web smpush-tabs-desktop smpush-tabs-popup smpush-tabs-chrome smpush-tabs-firefox smpush-tabs-safari smpush-tabs-opera smpush-tabs-edge smpush-tabs-samsung smpush-tabs-amp smpush-tabs-welcmsg smpush-radio-tabs" style="display:none">
        <input class="smpush_jradio" name="selectDIV" value="desktop" type="radio" data-icon="<?php echo smpush_imgpath; ?>/desktop.png" data-labelauty='<?php echo esc_html__('General', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="popup" type="radio" data-icon="<?php echo smpush_imgpath; ?>/popup.png" data-labelauty='<?php echo esc_html__('Pop-up', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="chrome" type="radio" data-icon="<?php echo smpush_imgpath; ?>/chrome.png" data-labelauty='<?php echo esc_html__('Chrome', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="firefox" type="radio" data-icon="<?php echo smpush_imgpath; ?>/firefox.png" data-labelauty='<?php echo esc_html__('Firefox', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="safari" type="radio" data-icon="<?php echo smpush_imgpath; ?>/safari.png" data-labelauty='<?php echo esc_html__('Safari', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="opera" type="radio" data-icon="<?php echo smpush_imgpath; ?>/opera.png" data-labelauty='<?php echo esc_html__('Opera', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="edge" type="radio" data-icon="<?php echo smpush_imgpath; ?>/edge.png" data-labelauty='<?php echo esc_html__('Edge', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="samsung" type="radio" data-icon="<?php echo smpush_imgpath; ?>/samsung.png" data-labelauty='<?php echo esc_html__('Samsung', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="amp" type="radio" data-icon="<?php echo smpush_imgpath; ?>/amp.png" data-labelauty='<?php echo esc_html__('AMP', 'smio-push-notification')?>' />
        <input class="smpush_jradio" name="selectDIV" value="welcmsg" type="radio" data-icon="<?php echo smpush_imgpath; ?>/welcome.png" data-labelauty='<?php echo esc_html__('Welcome', 'smio-push-notification')?>' />
      </div>
      
      <div id="col-left" class="smpush-tabs-general smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><span><?php echo esc_html__('General Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <?php if(!empty($params['canEditApiKeys'])): ?>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Authentication Key', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="auth_key" type="text" value="<?php echo esc_attr(self::$apisetting['auth_key']); ?>" size="50" class="regular-text">
                        <p class="description"><?php echo __('Send this key with any request with a parameter called <code>auth_key</code> to prevent access to API from outside .', 'smio-push-notification')?></p>
                        <p class="description"><?php echo __('Also you can send this key in the header of each request in a parameter called <code>auth_key</code> for more security .', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Leave it empty to disable this feature .', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                  <?php endif; ?>
                    <?php if (self::$apisetting['complex_auth'] == 1) { ?>
                    <tr valign="top">
                      <td class="first">Complex Authentication</td>
                      <td>
                        <label><input name="complex_auth" type="checkbox" value="1" <?php if (self::$apisetting['complex_auth'] == 1) { ?>checked="checked"<?php } ?>> Put the authentication key into an encrypted string</label>
                        <p class="description">The encrypted string will be in the following format <a href="http://en.wikipedia.org/wiki/MD5" target="_blank">MD5</a>(Date in m/d/y - Your auth key - Time in H:m)</p>
                        <p class="description">For example <a href="http://en.wikipedia.org/wiki/MD5" target="_blank">MD5</a>(<?php echo date('m/d/Y').self::$apisetting['auth_key'].date('H:i'); ?>)</p>
                      </td>
                    </tr>
                    <?php } ?>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('API Base Name', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="push_basename" type="text" value="<?php echo esc_attr(self::$apisetting['push_basename']); ?>" class="regular-text">
                        <p class="description"><span><code><?php echo get_bloginfo('wpurl') ; ?>/</code><abbr>API_BASE_NAME<code>/</code></abbr></span></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Messages Limitation', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="msgs_interval" type="number" value="<?php echo esc_attr(self::$apisetting['msgs_interval']); ?>" class="regular-text" min="0" size="10">
                        <p class="description"><?php echo esc_html__('Number of minutes between each message that every device can receive. system will ignore any messages in the unallowed time.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Processed Limitation', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="cron_limit" type="number" value="<?php echo esc_attr(self::$apisetting['cron_limit']); ?>" class="regular-text" min="0" size="10">
                        <p class="description"><?php echo esc_html__('Number of processed campaigns in each cron-job time. Set it 0 to be unlimited.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Default Connection', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="def_connection" class="postform">
                          <?php foreach ($params['connections'] AS $connection) { ?>
                            <option value="<?php echo esc_attr($connection->id); ?>" <?php if ($connection->id == self::$apisetting['def_connection']) { ?>selected="selected"<?php } ?>><?php echo $connection->title; ?></option>
                          <?php } ?>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Auto Geolocation', 'smio-push-notification')?></td>
                      <td><label><input name="auto_geo" type="checkbox" value="1" <?php if (self::$apisetting['auto_geo'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable auto collecting the device location from its connection point if system does not receive the location parameters (Not 100% Accurate)', 'smio-push-notification')?></label></td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Geolocation Provider', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="geo_provider" onchange="if (this.value == 'db-ip.com' || this.value == 'telize.com') { jQuery('.smio_dbip_apikey').show(); } else { jQuery('.smio_dbip_apikey').hide(); }">
                          <option value="db-ip.com" <?php if (self::$apisetting['geo_provider'] == 'db-ip.com') { ?>selected="selected"<?php } ?>>db-ip.com</option>
                          <option value="telize.com" <?php if (self::$apisetting['geo_provider'] == 'telize.com') { ?>selected="selected"<?php } ?>>telize.com</option>
                          <option value="ip-api.com" <?php if (self::$apisetting['geo_provider'] == 'ip-api.com') { ?>selected="selected"<?php } ?>>ip-api.com [Free]</option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="smio_dbip_apikey" <?php if (self::$apisetting['geo_provider'] != 'db-ip.com' && self::$apisetting['geo_provider'] != 'telize.com') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label>db-ip.com <?php echo esc_html__('API Key', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="db_ip_apikey" type="text" value="<?php echo esc_attr(self::$apisetting['db_ip_apikey']); ?>" class="regular-text" size="50">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Google Maps API Key', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="gmaps_apikey" type="text" value="<?php echo esc_attr(self::$apisetting['gmaps_apikey']); ?>" class="regular-text" size="50">
                      </td>
                    </tr>
                  <!--
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Fast Bridge', 'smio-push-notification')?></td>
                      <td><label><input name="fast_bridge" type="checkbox" value="1" <?php if (self::$apisetting['fast_bridge'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Smart trick to bypass WordPress huge loading time for plugin requests only.', 'smio-push-notification')?></label></td>
                    </tr>-->
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Apple API Version', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="apple_api_ver" type="radio" value="http2" <?php if (self::$apisetting['apple_api_ver'] == 'http2') { ?>checked="checked"<?php } ?>> <?php echo esc_html__('New Apple API version uses new HTTP/2 protocol [Recommended]', 'smio-push-notification') ?></label><br />
                        <label><input name="apple_api_ver" disabled type="radio" value="ssl" <?php if (self::$apisetting['apple_api_ver'] == 'ssl') { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Old Apple API version uses SSL connection', 'smio-push-notification') ?> <?php echo esc_html__('[Deprecated by Apple in March]', 'smio-push-notification') ?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Metabox Option', 'smio-push-notification')?></td>
                      <td><label><input name="metabox_check_status" type="checkbox" value="1" <?php if (self::$apisetting['metabox_check_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Default status for the mute notification checkbox when creating new posts is activated', 'smio-push-notification')?></label></td>
                    </tr>
                  <tr valign="top">
                    <td class="first"><label><?php echo __('Who Can Use', 'spns-admin-lang')?></label></td>
                    <td>
                      <select name="who_use[]" multiple="multiple" size="5" style="width: 200px">
                        <option value="administrator" <?php if (in_array('administrator', self::$apisetting['who_use'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Administrator')?></option>
                        <option value="editor" <?php if (in_array('editor', self::$apisetting['who_use'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Editor')?></option>
                        <option value="author" <?php if (in_array('author', self::$apisetting['who_use'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Author')?></option>
                        <option value="contributor" <?php if (in_array('contributor', self::$apisetting['who_use'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Contributor')?></option>
                        <option value="subscriber" <?php if (in_array('subscriber', self::$apisetting['who_use'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Subscriber')?></option>
                      </select>
                    </td>
                  </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Uninstall Plugin', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="uninstall_action" type="radio" value="files" <?php if (self::$apisetting['uninstall_action'] == 'files') { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Remove plugin files only.', 'smio-push-notification')?></label><br />
                        <label><input name="uninstall_action" type="radio" value="data" <?php if (self::$apisetting['uninstall_action'] == 'data') { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Remove plugin files and all data except plugin settings and configurations.', 'smio-push-notification')?></label><br />
                        <label><input name="uninstall_action" type="radio" value="destroy" <?php if (self::$apisetting['uninstall_action'] == 'destroy') { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Completely remove plugin files, options and all data.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-ios smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/apple.png" alt="" /> <span><?php echo esc_html__('Apple Connection Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Certification Type', 'smio-push-notification')?></td>
                      <td><label><input name="apple_sandbox" type="checkbox" value="1" <?php if (self::$apisetting['apple_sandbox'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable Apple sandbox server for development certification type', 'smio-push-notification')?></label></td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('App ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_appid" type="text" value="<?php echo esc_attr(self::$apisetting['apple_appid']); ?>" class="regular-text">
                        <p class="description"><?php echo esc_html__('App ID under App IDs page in Identifiers block.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Certification Type', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="apple_cert_type" onchange="if (this.value === 'pem') { jQuery('.ios_cert_p8_fields').hide();jQuery('.ios_cert_pem_fields').show(); } else { jQuery('.ios_cert_pem_fields').hide();jQuery('.ios_cert_p8_fields').show(); }">
                          <option value=""><?php echo esc_html__('Select Certification Type', 'smio-push-notification')?></option>
                          <option value="pem" <?php if (self::$apisetting['apple_cert_type'] == 'pem') { ?>selected="selected"<?php } ?>><?php echo esc_html__('Old PEM Certification', 'smio-push-notification')?></option>
                          <option value="p8" <?php if (self::$apisetting['apple_cert_type'] == 'p8') { ?>selected="selected"<?php } ?>><?php echo esc_html__('New P8 Certification', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="ios_cert_p8_fields" <?php if (self::$apisetting['apple_cert_type'] != 'p8') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Team ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_teamid" type="text" value="<?php echo esc_attr(self::$apisetting['apple_teamid']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top" class="ios_cert_p8_fields" <?php if (self::$apisetting['apple_cert_type'] != 'p8') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Key ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_keyid" type="text" value="<?php echo esc_attr(self::$apisetting['apple_keyid']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top" class="ios_cert_p8_fields" <?php if (self::$apisetting['apple_cert_type'] != 'p8') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Certification .P8 File', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_certp8_path" type="text" value="<?php echo esc_attr(self::$apisetting['apple_certp8_path']); ?>" size="60" class="regular-text">
                        <input name="apple_certp8_upload" type="file">
                      </td>
                    </tr>
                    <?php if (empty(self::$apisetting['apple_cert_path']) || !empty(self::$apisetting['apple_certp12_path'])): ?>
                    <tr valign="top" class="ios_cert_pem_fields" <?php if (self::$apisetting['apple_cert_type'] != 'pem') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Certification .P12 File', 'smio-push-notification')?></label></td>
                      <td>
                        <input type="hidden" name="apple_cert_path" value="<?php echo esc_attr(self::$apisetting['apple_cert_path']); ?>" />
                        <input name="apple_certp12_path" type="text" value="<?php echo esc_attr(self::$apisetting['apple_certp12_path']); ?>" size="60" class="regular-text">
                        <input name="apple_certp12_upload" type="file">
                      </td>
                    </tr>
                    <?php endif; ?>
                    <?php if (empty(self::$apisetting['apple_certp12_path'])): ?>
                    <tr valign="top" class="ios_cert_pem_fields" <?php if (self::$apisetting['apple_cert_type'] != 'pem') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Certification .PEM File', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_cert_path" type="text" value="<?php echo esc_attr(self::$apisetting['apple_cert_path']); ?>" size="60" class="regular-text">
                        <input name="apple_cert_upload" type="file">
                      </td>
                    </tr>
                    <?php endif; ?>
                    <tr valign="top" class="ios_cert_pem_fields" <?php if (self::$apisetting['apple_cert_type'] != 'pem') { ?>style="display:none;"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Password Phrase', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="apple_passphrase" type="text" value="<?php echo esc_attr(self::$apisetting['apple_passphrase']); ?>" class="regular-text">
                        <p class="description"><?php echo esc_html__('Apple password phrase for sending push notification.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('APN Compatibility', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="ios_compatibility" class="postform" onchange="if(this.value === 'expo') jQuery('#iOSExpoID').show(); else jQuery('#iOSExpoID').hide();">
                          <option value="standard" <?php if (self::$apisetting['ios_compatibility'] == 'standard') { ?>selected="selected"<?php } ?>><?php echo __("Standard", 'smio-push-notification')?></option>
                          <option value="corona" <?php if (self::$apisetting['ios_compatibility'] == 'corona') { ?>selected="selected"<?php } ?>>Corona</option>
                          <option value="expo" <?php if (self::$apisetting['ios_compatibility'] == 'expo') { ?>selected="selected"<?php } ?>>Expo</option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" id="iOSExpoID" <?php if (self::$apisetting['ios_compatibility'] != 'expo') { ?>style="display: none"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Expo Experience ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="ios_expo_id" type="text" value="<?php echo esc_attr(self::$apisetting['ios_expo_id']); ?>" placeholder="@username/projectSlug" class="regular-text" size="40">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Badge', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="ios_badge" type="text" value="<?php echo esc_attr(self::$apisetting['ios_badge']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('The number to display as the badge of the application icon.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Badge Counter', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="ios_msg_counter" type="checkbox" value="1" <?php if (self::$apisetting['ios_msg_counter'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Automatically count number of messages that device receive it', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Launch Image', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="ios_launch" type="text" value="<?php echo esc_attr(self::$apisetting['ios_launch']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('The filename of an image file in the application bundle.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Sound', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="ios_sound" type="text" value="<?php echo esc_attr(self::$apisetting['ios_sound']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('The name of a sound file in the application bundle.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Message Truncate', 'smio-push-notification')?></td>
                      <td><label><input name="stop_summarize" type="checkbox" value="1" <?php if (self::$apisetting['stop_summarize'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Disable truncate iOS push message if exceeds the allowed payload', 'smio-push-notification')?></label></td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Titanium Compatibility', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="ios_titanium_payload" type="checkbox" value="1" <?php if (self::$apisetting['ios_titanium_payload'] == 1) { ?>checked="checked"<?php } ?>> <?php echo __("Make iOS's payload compatible with Titanium platform", 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('One By One', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="ios_onebyone" type="checkbox" value="1" <?php if (self::$apisetting['ios_onebyone'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Send devices to Apple one by one instead of 1000 devices in each connection', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('Apple closes connection when receive number of invalid devices.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Enable this option when you do not receive the push message on number of devices.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Use new Apple API provider HTTP/2 to avoid this problem.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-android smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/android.png" alt="" /> <span><?php echo esc_html__('Android Connection Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <?php if(!empty($params['canEditApiKeys'])): ?>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('API Key', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="google_apikey" type="text" value="<?php echo esc_attr(self::$apisetting['google_apikey']); ?>" class="regular-text" size="70">
                        <p class="description"><?php echo esc_html__('Google API key for sending Android push notification.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Firebase Compatibility', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="fcm_compatibility" class="postform" onchange="if(this.value === 'expo') jQuery('#FCMExpoID').show(); else jQuery('#FCMExpoID').hide();">
                          <option value="fcm_notification" <?php if (self::$apisetting['fcm_compatibility'] == 'fcm_notification') { ?>selected="selected"<?php } ?>><?php echo __("Notification message", 'smio-push-notification')?></option>
                          <option value="fcm_data" <?php if (self::$apisetting['fcm_compatibility'] == 'fcm_data') { ?>selected="selected"<?php } ?>><?php echo __("Data message", 'smio-push-notification')?></option>
                          <option value="titanium" <?php if (self::$apisetting['fcm_compatibility'] == 'titanium') { ?>selected="selected"<?php } ?>>Titanium</option>
                          <option value="expo" <?php if (self::$apisetting['fcm_compatibility'] == 'expo') { ?>selected="selected"<?php } ?>>Expo</option>
                          <option value="corona" <?php if (self::$apisetting['fcm_compatibility'] == 'corona') { ?>selected="selected"<?php } ?>>Corona</option>
                        </select>
                        <p class="description"><?php echo esc_html__('Read more about Firebase message types', 'smio-push-notification')?> <a href="https://firebase.google.com/docs/cloud-messaging/concept-options#notifications_and_data_messages" target="_blank"><?php echo __("here", 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top" id="FCMExpoID" <?php if (self::$apisetting['fcm_compatibility'] != 'expo') { ?>style="display: none"<?php } ?>>
                      <td class="first"><label><?php echo esc_html__('Expo Experience ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="fcm_expo_id" type="text" value="<?php echo esc_attr(self::$apisetting['fcm_expo_id']); ?>" placeholder="@username/projectSlug" class="regular-text" size="40">
                      </td>
                    </tr>
                  <?php endif; ?>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Title', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="android_title" type="text" value="<?php echo esc_attr(self::$apisetting['android_title']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('Title of notification appears above the message body.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Icon', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="android_icon" type="text" value="<?php echo esc_attr(self::$apisetting['android_icon']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('Set icon file name to customize the push message icon.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Sound', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="android_sound" type="text" value="<?php echo esc_attr(self::$apisetting['android_sound']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('The sound to play when the device receives the notification.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Counter', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="android_msg_counter" type="checkbox" value="1" <?php if (self::$apisetting['android_msg_counter'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Automatically count number of messages that device receive it', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-windows smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/wp.png" alt="" /> <span><?php echo esc_html__('Windows Phone 8 Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Authenticated', 'smio-push-notification')?></td>
                      <td><label><input name="wp_authed" type="checkbox" value="1" <?php if (self::$apisetting['wp_authed'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Windows Phone 8 authenticated apps have no limit quota for sending daily.', 'smio-push-notification')?></label></td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Certificate File', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="wp_cert" type="file" class="regular-text"><?php if (!empty(self::$apisetting['wp_cert'])): ?> <img title="Uploaded" src="<?php echo smpush_imgpath; ?>/valid.png" alt="" /><?php endif; ?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Private key', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="wp_pem" type="file" class="regular-text"><?php if (!empty(self::$apisetting['wp_pem'])): ?> <img title="Uploaded" src="<?php echo smpush_imgpath; ?>/valid.png" alt="" /><?php endif; ?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('CA Info', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="wp_cainfo" type="file" class="regular-text"><?php if (!empty(self::$apisetting['wp_cainfo'])): ?> <img title="Uploaded" src="<?php echo smpush_imgpath; ?>/valid.png" alt="" /><?php endif; ?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-windows smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/wp.png" alt="" /> <span><?php echo esc_html__('Universal Windows 10 Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Package SID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="wp10_pack_sid" type="text" size="80" value="<?php echo self::$apisetting['wp10_pack_sid']?>" placeholder="e.g. ms-app://S-1-15-2-2972962901-2322836549-3722629029" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Client Secret', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="wp10_client_secret" type="text" size="60" value="<?php echo self::$apisetting['wp10_client_secret']?>" placeholder="e.g. Vex8L9WOFZuj95euaLrvSH7XyoDhLJc7" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-blackberry smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/blackberry.png" alt="" /> <span><?php echo esc_html__('BlackBerry Connection Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Development Mode', 'smio-push-notification')?></td>
                      <td><label><input name="bb_dev_env" type="checkbox" value="1" <?php if (self::$apisetting['bb_dev_env'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable development mode', 'smio-push-notification')?></label></td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Application ID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="bb_appid" type="text" value="<?php echo esc_attr(self::$apisetting['bb_appid']); ?>" class="regular-text" size="50">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Password', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="bb_password" type="text" value="<?php echo esc_attr(self::$apisetting['bb_password']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('CPID', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="bb_cpid" type="text" value="<?php echo esc_attr(self::$apisetting['bb_cpid']); ?>" class="regular-text">
                        <p class="description"><?php echo esc_html__('Content Provider ID is provided by BlackBerry in the email you received.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-desktop smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/desktop.png" alt="" /> <span><?php echo esc_html__('Desktop Notifications', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Title', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="desktop_title" type="text" value="<?php echo esc_attr(self::$apisetting['desktop_title']); ?>" class="regular-text" size="40">
                        <p class="description"><?php echo esc_html__('Title of notification appears above the message body.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_gps_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_gps_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable GPS location detector', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="real_webpush_views" type="checkbox" value="1" <?php if (self::$apisetting['real_webpush_views'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable web push real views calculations [causes a lot of requests on server]', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_debug" type="checkbox" value="1" <?php if (self::$apisetting['desktop_debug'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable debug mode to track any errors in the browser console', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="logs_mode" type="checkbox" value="1" <?php if (self::$apisetting['logs_mode'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable the logs mode to tracking the plugin backend process', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_logged_only" type="checkbox" value="1" <?php if (self::$apisetting['desktop_logged_only'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable for logged users only', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_admins_only" type="checkbox" value="1" <?php if (self::$apisetting['desktop_admins_only'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable for administrators only', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-popup smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/desktop.png" alt="" /> <span><?php echo esc_html__('Popup Box Settings', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Request Type', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_request_type" class="smpushReuqestTypePicker_DISABLED">
                          <option value="native"><?php echo esc_html__('Native Opt-in', 'smio-push-notification')?></option>
                          <option value="subs_page" <?php if (self::$apisetting['desktop_request_type'] == 'subs_page'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Subscription Page', 'smio-push-notification')?></option>
                          <option value="popup" <?php if (self::$apisetting['desktop_request_type'] == 'popup'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Popup Box', 'smio-push-notification')?></option>
                          <option value="icon" <?php if (self::$apisetting['desktop_request_type'] == 'icon'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Icon', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top">
                      <th class="first smpush_table_head" colspan="2"><?php echo esc_html__('Customize Popup', 'smio-push-notification')?></th>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Layout', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_popup_layout">
                          <option value="modern"><?php echo esc_html__('Modern', 'smio-push-notification')?></option>
                          <option value="native" <?php if (self::$apisetting['desktop_popup_layout'] == 'native'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Like Native', 'smio-push-notification')?></option>
                          <option value="flat" <?php if (self::$apisetting['desktop_popup_layout'] == 'flat'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Flat Design', 'smio-push-notification')?></option>
                          <option value="fancy" <?php if (self::$apisetting['desktop_popup_layout'] == 'fancy'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Fancy Layout', 'smio-push-notification')?></option>
                          <option value="dark" <?php if (self::$apisetting['desktop_popup_layout'] == 'dark'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Dark', 'smio-push-notification')?></option>
                          <option value="ocean" <?php if (self::$apisetting['desktop_popup_layout'] == 'ocean'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Light Ocean', 'smio-push-notification')?></option>
                          <option value="news" <?php if (self::$apisetting['desktop_popup_layout'] == 'news'):?>selected="selected"<?php endif;?>><?php echo esc_html__('News Look', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Position', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_popup_position">
                          <option value="center"><?php echo esc_html__('Center of screen', 'smio-push-notification')?></option>
                          <option value="topcenter" <?php if (self::$apisetting['desktop_popup_position'] == 'topcenter'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Top center', 'smio-push-notification')?></option>
                          <option value="topright" <?php if (self::$apisetting['desktop_popup_position'] == 'topright'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Top right', 'smio-push-notification')?></option>
                          <option value="topleft" <?php if (self::$apisetting['desktop_popup_position'] == 'topleft'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Top left', 'smio-push-notification')?></option>
                          <option value="bottomright" <?php if (self::$apisetting['desktop_popup_position'] == 'bottomright'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Bottom right', 'smio-push-notification')?></option>
                          <option value="bottomleft" <?php if (self::$apisetting['desktop_popup_position'] == 'bottomleft'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Bottom left', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Modal Head Title', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="desktop_modal_title" value="<?php echo esc_attr(self::$apisetting['desktop_modal_title']); ?>" class="regular-text" size="40" />
                      </td>
                    </tr>
                    <tr valign="middle" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Modal Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_modal_message" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_modal_message'], smpush_allowed_html); ?></textarea>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Subscribe Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="desktop_btn_subs_text" value="<?php echo esc_attr(self::$apisetting['desktop_btn_subs_text']); ?>" class="regular-text" size="40" />
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Unsubscribe Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="desktop_btn_unsubs_text" value="<?php echo esc_attr(self::$apisetting['desktop_btn_unsubs_text']); ?>" class="regular-text" size="40" />
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Ignore Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="desktop_modal_cancel_text" value="<?php echo esc_attr(self::$apisetting['desktop_modal_cancel_text']); ?>" class="regular-text" size="20" />
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-popup-settings" <?php if(self::$apisetting['desktop_request_type'] != 'popup'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Saved Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="desktop_modal_saved_text" value="<?php echo esc_attr(self::$apisetting['desktop_modal_saved_text']); ?>" class="regular-text" size="20" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Logo Icon', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_popupicon" type="url" size="50" name="desktop_popupicon" value="<?php echo esc_attr(self::$apisetting['desktop_popupicon']); ?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_popupicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                        <p class="description"><?php echo esc_html__('Set a website logo to appear in the pop-up body.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <th class="first smpush_table_head" colspan="2"><?php echo esc_html__('Customize Icon', 'smio-push-notification')?></th>
                    </tr>
                    <tr valign="top" class="smpush-icon-settings" <?php if(self::$apisetting['desktop_request_type'] != 'icon'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Position', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_icon_position">
                          <option value="topright" <?php if (self::$apisetting['desktop_icon_position'] == 'topright'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Top right', 'smio-push-notification')?></option>
                          <option value="topleft" <?php if (self::$apisetting['desktop_icon_position'] == 'topleft'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Top left', 'smio-push-notification')?></option>
                          <option value="bottomright" <?php if (self::$apisetting['desktop_icon_position'] == 'bottomright'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Bottom right', 'smio-push-notification')?></option>
                          <option value="bottomleft" <?php if (self::$apisetting['desktop_icon_position'] == 'bottomleft'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Bottom left', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-icon-settings" <?php if(self::$apisetting['desktop_request_type'] != 'icon'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Subscribe Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_icon_message" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_icon_message'], smpush_allowed_html); ?></textarea>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush-icon-settings" <?php if(self::$apisetting['desktop_request_type'] != 'icon'):?>style="display:"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Unsubscribe Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_icon_unsubs_text" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_icon_unsubs_text'], smpush_allowed_html); ?></textarea>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Icon Image', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_iconimage" type="url" size="50" name="desktop_iconimage" value="<?php echo esc_attr(self::$apisetting['desktop_iconimage']); ?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_iconimage" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                        <p class="description"><?php echo esc_html__('Set a custom icon image instead of the default bell image. Recommended size 48x48 px', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <th class="first smpush_table_head" colspan="2"><?php echo esc_html__('Additional Customization', 'smio-push-notification')?></th>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Custom CSS', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_popup_css" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_popup_css'], smpush_allowed_html); ?></textarea>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Black Overlay', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="black_overlay" type="checkbox" value="1" <?php if (self::$apisetting['black_overlay'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Display black overlay when the popup appears.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Delay Time', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_delay" type="number" value="<?php echo esc_attr(self::$apisetting['desktop_delay']); ?>" class="regular-text" style="width:70px"> <?php echo esc_html__('Number of seconds to delay appearing the request permissions for visitors.', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Request Again', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_reqagain" type="number" value="<?php echo esc_attr(self::$apisetting['desktop_reqagain']); ?>" class="regular-text" style="width:70px"> <?php echo esc_html__('Number of days to request the permissions again from users when click on ignore button.', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="middle">
                      <td class="first"><?php echo esc_html__('Not Supported Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_notsupport_msg" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_notsupport_msg'], smpush_allowed_html); ?></textarea>
                        <p class="description"><?php echo esc_html__('Show a message if user visits website with browser does not support web push notification.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Show In', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_run_places[]" multiple="multiple" size="7" style="width:250px">
                          <option value="noplace" <?php if (in_array('noplace', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('No Place', 'smio-push-notification')?></option>
                          <option value="all" <?php if (in_array('all', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('All Places', 'smio-push-notification')?></option>
                          <option value="homepage" <?php if (in_array('homepage', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Homepage', 'smio-push-notification')?></option>
                          <option value="post" <?php if (in_array('post', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Post', 'smio-push-notification')?></option>
                          <option value="page" <?php if (in_array('page', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Page', 'smio-push-notification')?></option>
                          <option value="category" <?php if (in_array('category', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Category', 'smio-push-notification')?></option>
                          <option value="taxonomy" <?php if (in_array('taxonomy', self::$apisetting['desktop_run_places'])):?>selected="selected"<?php endif;?>><?php echo esc_html__('Taxonomy', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Show In Specific IDs', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_showin_pageids" type="text" value="<?php echo esc_attr(self::$apisetting['desktop_showin_pageids']); ?>" placeholder="44,1,32,48,3,56,8,43,1713" size="50" class="regular-text">
                        <p class="description"><?php echo esc_html__('Put each page, category, post or taxonomy ID separated by (,) to request the web push permissions through them only.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-popup smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/desktop.png" alt="" /> <span><?php echo esc_html__('Pay To Read', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Status', 'smio-push-notification')?></td>
                      <td>
                        <select name="desktop_paytoread" onchange="smpushPayToSelector(this.value)">
                          <option value="0"><?php echo esc_html__('Disabled', 'smio-push-notification')?></option>
                          <option value="1" <?php if (self::$apisetting['desktop_paytoread'] == 1):?>selected="selected"<?php endif;?>><?php echo esc_html__('Popup without dismiss option', 'smio-push-notification')?></option>
                          <option value="2" <?php if (self::$apisetting['desktop_paytoread'] == 2):?>selected="selected"<?php endif;?>><?php echo esc_html__('Truncate post contents', 'smio-push-notification')?></option>
                        </select>
                        <p class="description"><?php echo esc_html__('Force the visitor to subscribe to continue browsing your content.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="middle" class="paytoreadOptions1" <?php if (self::$apisetting['desktop_paytoread'] != 1):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="desktop_paytoread_message" rows="8" cols="70" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_paytoread_message'], smpush_allowed_html); ?></textarea>
                        <p class="description"><?php echo esc_html__('Show a message if pay to read option is enabled and visitor blocked the push permissions.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top" class="paytoreadOptions1" <?php if (self::$apisetting['desktop_paytoread'] != 1):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Darkness Grade', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_paytoread_darkness" type="number" min="1" max="10" value="<?php echo esc_attr(self::$apisetting['desktop_paytoread_darkness']); ?>" class="regular-text" style="width:70px"> <?php echo esc_html__('Pay To Read darkness grade from 1 to 10.', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top" class="paytoreadOptions2" <?php if (self::$apisetting['desktop_paytoread'] != 2):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Text Size', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_paytoread_textsize" type="number" step="50" value="<?php echo esc_attr(self::$apisetting['desktop_paytoread_textsize']); ?>" class="regular-text" style="width:70px"> <?php echo esc_html__('Number of allowed characters for post contents before cutting.', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top" class="paytoreadOptions2" <?php if (self::$apisetting['desktop_paytoread'] != 2):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Subscribe Message', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_paytoread_substext" type="text" value="<?php echo esc_attr(self::$apisetting['desktop_paytoread_substext']); ?>" class="regular-text" size="80">
                        <p class="description"><?php echo esc_html__('Write a message for user to know about why can not see the complete post contents.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-chrome smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/chrome.png" alt="" /> <span>Chrome</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_chrome_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_chrome_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Chrome browser', 'smio-push-notification')?></label>
                        <p class="description">
                          <?php echo __('Chrome push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                          <a href="//namecheap.pxf.io/c/477005/386535/5618" target="_blank"><?php echo esc_html__('Buy one for $9 only', 'smio-push-notification')?></a>
                        </p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Firebase Config', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="firebase_config" rows="8" style="width:80%;max-width:500px" placeholder='{
  apiKey: "AIzaSyDUHaVe7icRc1Z2daycalv_cveWQER_mK4",
  authDomain: "push-notification-bcc8d.firebaseapp.com",
  databaseURL: "https://push-notification-bcc8d.firebaseio.com",
  projectId: "push-notification-bcc8d",
  storageBucket: "push-notification-bcc8d.appspot.com",
  messagingSenderId: "711898931966",
  appId: "1:711898931966:web:c2c73a13c66a72d0a5d9f6"
}' class="regular-text"><?php echo wp_kses(self::$apisetting['firebase_config'], smpush_allowed_html); ?></textarea>
                        <p class="description"><?php echo esc_html__('For how to setup web push notification', 'smio-push-notification')?> <a href="https://smartiolabs.com/product/push-notification-system/documentation#web-configurations" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Firebase Authentication File', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" size="50" name="firebase_auth_file" value="<?php echo esc_attr(self::$apisetting['firebase_auth_file']); ?>" />
                        <input type="file" name="firebase_auth_file_upload" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first">Firebase <?php echo esc_html__('Server Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="chrome_apikey" value="<?php echo esc_attr(self::$apisetting['chrome_apikey']); ?>" class="regular-text" size="80" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first">Firebase <?php echo esc_html__('Sender ID', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="chrome_projectid" value="<?php echo esc_attr(self::$apisetting['chrome_projectid']); ?>" class="regular-text" placeholder="<?php echo esc_html__('e.g. 590173865545', 'smio-push-notification')?>" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('OneSignal Compliant', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="webpush_onesignal_payload" type="checkbox" value="1" <?php if (self::$apisetting['webpush_onesignal_payload'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable this option if you import some subscribers from OneSignal.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Offline Messages', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="desktop_offline" type="checkbox" value="1" <?php if (self::$apisetting['desktop_offline'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Show offline messages when user opens his browser again', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('No Disturb', 'smio-push-notification')?></td>
                      <td>
                        <label><input name="no_disturb" type="checkbox" value="1" <?php if (self::$apisetting['no_disturb'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Always show the last notification only and cancel any old notifications', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Default Icon', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_deskicon" type="url" size="50" name="desktop_deficon" value="<?php echo esc_attr(self::$apisetting['desktop_deficon']); ?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_deskicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                        <p class="description"><?php echo esc_html__('Choose an icon in a standard size 192x192 px', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Additional Manifest', 'smio-push-notification')?></td>
                      <td>
                        <textarea name="chrome_manifest" rows="8" cols="70" placeholder='e.g. {"start_url":"/index.html","display":"standalone"}' class="regular-text"><?php echo wp_kses(self::$apisetting['chrome_manifest'], smpush_allowed_html); ?></textarea>
                        <p class="description"><?php echo esc_html__('Plugin cancels other Manifest files so add here any Manifest configurations in JSON format you want to load.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-firefox smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/firefox.png" alt="" /> <span>Firefox</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_firefox_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_firefox_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Firefox browser', 'smio-push-notification')?></label>
                        <p class="description">
                          <?php echo __('Firefox push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                          <a href="//namecheap.pxf.io/c/477005/386535/5618" target="_blank"><?php echo esc_html__('Buy one for $9 only', 'smio-push-notification')?></a>
                        </p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-opera smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/opera.png" alt="" /> <span>Opera</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_opera_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_opera_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Opera browser', 'smio-push-notification')?></label>
                        <p class="description">
                          <?php echo esc_html__('Opera push notification depends on Chrome configurations to work .', 'smio-push-notification')?>
                        </p>
                        <?php echo __('Opera push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-edge smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/edge.png" alt="" /> <span>Edge</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_edge_status" type="checkbox" <?php if (self::$apisetting['desktop_webpush'] == 0): ?>disabled="disabled"<?php endif; ?> value="1" <?php if (self::$apisetting['desktop_edge_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Edge browser', 'smio-push-notification')?></label>
                        <p class="description">
                          <?php echo esc_html__('Edge push notification depends on Chrome configurations to work .', 'smio-push-notification')?>
                        </p>
                        <?php echo __('Edge push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-samsung smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/samsung.png" alt="" /> <span>Samsung Browser</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_samsung_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_samsung_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Samsung Browser', 'smio-push-notification')?></label>
                        <p class="description">
                          <?php echo esc_html__('Samsung Browser push notification depends on Chrome configurations to work .', 'smio-push-notification')?>
                        </p>
                        <?php echo __('Samsung Browser push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-amp smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/amp.png" alt="" /> <span>AMP</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Enable SuperPWA Support', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="pwa_support" type="checkbox" value="1" <?php if (self::$apisetting['pwa_support'] == 1) { ?>checked="checked"<?php } ?>>
                          <?php echo esc_html__('Enable PWA support for', 'smio-push-notification')?> <a href="https://wordpress.org/plugins/super-progressive-web-apps/" target="_blank">SuperPWA</a> <?php echo esc_html__('plugin', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Enable PWA for WP Support', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="pwaforwp_support" type="checkbox" value="1" <?php if (self::$apisetting['pwaforwp_support'] == 1) { ?>checked="checked"<?php } ?>>
                          <?php echo esc_html__('Enable PWA support for', 'smio-push-notification')?> <a href="https://wordpress.org/plugins/pwa-for-wp/" target="_blank">PWA for WP & AMP</a> <?php echo esc_html__('plugin', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <input name="pwa_kaludi_support" type="hidden" value="0">
                    <!--<tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Enable PWA Support', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="pwa_kaludi_support" type="checkbox" value="1" <?php if (self::$apisetting['pwa_kaludi_support'] == 1) { ?>checked="checked"<?php } ?>>
                        <?php echo esc_html__('Enable PWA support for', 'smio-push-notification')?> <a href="https://wordpress.org/plugins/pwa-for-wp/" target="_blank">PWA for WP</a> <?php echo esc_html__('plugin', 'smio-push-notification')?>
                      </td>
                    </tr>-->
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('VAPID Public Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="chrome_vapid_public" value="<?php echo esc_attr(self::$apisetting['chrome_vapid_public']); ?>" class="regular-text" size="80" />
                        <p class="description"><?php echo esc_html__('Get your own VAPID keys using this tool', 'smio-push-notification')?> <a href="https://tools.reactpwa.com/vapid?email=<?php echo urlencode(get_bloginfo('admin_email'))?>" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('VAPID Private Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="chrome_vapid_private" value="<?php echo esc_attr(self::$apisetting['chrome_vapid_private']); ?>" class="regular-text" size="50" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Enable AMP Support', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="amp_support" type="checkbox" value="1" <?php if (self::$apisetting['amp_support'] == 1) { ?>checked="checked"<?php } ?> <?php if (empty(self::$apisetting['chrome_vapid_public'])) { ?>disabled="disabled"<?php } ?>>
                        <?php if (empty(self::$apisetting['chrome_vapid_public'])): ?>
                          <code><?php echo esc_html__('Set VAPID keys first to enable AMP support.', 'smio-push-notification')?></code>
                        <?php endif; ?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('AMP Post Widget', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="amp_post_widget" type="checkbox" value="1" <?php if (self::$apisetting['amp_post_widget'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable showing AMP opt-in buttons under post content.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('AMP Page Widget', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="amp_page_widget" type="checkbox" value="1" <?php if (self::$apisetting['amp_page_widget'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable showing AMP opt-in buttons under page content.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('AMP Post Shortcode', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="amp_post_shortcode" type="checkbox" value="1" <?php if (self::$apisetting['amp_post_shortcode'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable showing AMP opt-in shortcode buttons for posts.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('AMP Page Shortcode', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input name="amp_page_shortcode" type="checkbox" value="1" <?php if (self::$apisetting['amp_page_shortcode'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable showing AMP opt-in shortcode buttons for pages.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('AMP Buttons Shortcode', 'smio-push-notification')?></label></td>
                      <td>
                        <label><input type="text" size="80" value="[smart_amp_optin subscribe='Subscribe to Notifications' unsubscribe='Opt-out from Notifications']" class="regular-text" onfocus="jQuery(this).select()" readonly>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-safari smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/safari.png" alt="" /> <span>Safari</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label>
                          <input name="desktop_safari_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_safari_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification listener for Safari browser', 'smio-push-notification')?>
                        </label>
                        <p class="description">
                          <?php echo __('Safari push notification requires your site working under <code>HTTPS</code> protocol .', 'smio-push-notification')?>
                          <a href="//namecheap.pxf.io/c/477005/386535/5618" target="_blank"><?php echo esc_html__('Buy one for $9 only', 'smio-push-notification')?></a>
                        </p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Certification .P12 File', 'smio-push-notification')?></td>
                      <td>
                        <input type="hidden" name="safari_cert_path" value="<?php echo esc_attr(self::$apisetting['safari_cert_path']); ?>" />
                        <input type="text" size="50" name="safari_certp12_path" value="<?php echo esc_attr(self::$apisetting['safari_certp12_path']); ?>" />
                        <input type="file" name="safari_certp12_upload" />
                        <p class="description"><?php echo esc_html__('Do not have Apple developer account?', 'smio-push-notification').' '.esc_html__('We provide a paid service to generate your certificates for $10 only', 'smio-push-notification')?> <a href="https://smartiolabs.com/support" target="_blank"><?php echo esc_html__('request now', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Password Phrase', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="safari_passphrase" type="text" value="<?php echo esc_attr(self::$apisetting['safari_passphrase']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Website Push ID', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" size="30" name="safari_web_id" placeholder="e.g. web.com.example.domain" value="<?php echo esc_attr(self::$apisetting['safari_web_id']); ?>" />
                        <p class="description"><?php echo esc_html__('The Website Push ID, as specified in your registration with the Member Center.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Push Icon', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_safariicon" type="url" size="50" name="safari_icon" value="<?php echo esc_attr(self::$apisetting['safari_icon']); ?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_safariicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                        <p class="description"><?php echo esc_html__('Choose an icon in a standard size 256x256 px', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Authentication', 'smio-push-notification')?></td>
                      <td>
                        <a href="<?php echo rtrim(get_bloginfo('wpurl'), '/') ?>/<?php echo self::$apisetting['push_basename'] ?>/safari/v1/<?php echo (empty(self::$apisetting['safari_web_id']))? 'web' : self::$apisetting['safari_web_id'] ?>/pushPackages/" class="button" target="_blank"><?php echo esc_html__('Check Authentication Result', 'smio-push-notification')?></a>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-messenger smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/messenger.png" alt="" /> <span>Messenger</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Webhook Callback URL', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="<?php echo get_bloginfo('wpurl').'/'.esc_attr(self::$apisetting['push_basename']); ?>/facebook/?action=callback" class="regular-text" size="80" onclick="jQuery(this).select()" readonly />
                        <p class="description"><?php echo esc_html__('For how to setup Facebook Messenger', 'smio-push-notification')?> <a href="https://smartiolabs.com/product/push-notification-system/documentation#messenger-configurations" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                        <p class="description">
                          <?php echo esc_html__('Whitelist your domain in your Facebook page in the Whitelisted Domains section is a must to display Messenger opt-in button.', 'smio-push-notification')?>
                          <?php echo esc_html__('For further info', 'smio-push-notification')?> <a href="https://developers.facebook.com/docs/messenger-platform/reference/messenger-profile-api/domain-whitelisting" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a>
                        </p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Webhook Verify Token', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="<?php echo self::$apisetting['msn_verify']?>" class="regular-text" size="30" onclick="jQuery(this).select()" readonly />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Login URL', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="<?php echo get_bloginfo('wpurl').'/'.esc_attr(self::$apisetting['push_basename']); ?>/facebook/?action=login" class="regular-text" size="80" onclick="jQuery(this).select()" readonly />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('App ID', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_appid" value="<?php echo esc_attr(self::$apisetting['msn_appid']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('App Secret', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_secret" value="<?php echo esc_attr(self::$apisetting['msn_secret']); ?>" class="regular-text" size="50" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Page Access Token', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_accesstoken" value="<?php echo esc_attr(self::$apisetting['msn_accesstoken']); ?>" class="regular-text" size="80" />
                        <?php if(!empty(self::$apisetting['msn_subscribe_error'])):?><?php echo esc_html__('Error while connecting with Facebook try save changes again or check the access token.', 'smio-push-notification')?><?php endif;?>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Autoresponder Message', 'smio-push-notification')?></td>
                      <td>
                        <textarea class="regular-text" name="msn_autorespond" rows="8" cols="60" placeholder="Hello dear,&#10;please send `subscribe me` command to subscribe with us and receive our last updates&#10;and `unsubscribe me` command at anytime to cancel and delete your subscription."><?php echo wp_kses(self::$apisetting['msn_autorespond'], smpush_allowed_html); ?></textarea>
                        <p class="description"><?php echo esc_html__('Send autoresponder message contains your commands once user sends you a message.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Subscribe Command', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_subs_command" placeholder="e.g. subscribe me" value="<?php echo esc_attr(self::$apisetting['msn_subs_command']); ?>" class="regular-text" size="30" />
                        <p class="description"><?php echo esc_html__('Set a word or statement when a user sends it in Messenger plugin will process his subscription.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Leave it empty if you want plugin process any user subscription automatically if he sends any message.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Unsubscribe Command', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_unsubs_command" placeholder="e.g. unsubscribe and delete my account" value="<?php echo esc_attr(self::$apisetting['msn_unsubs_command']); ?>" class="regular-text" size="30" />
                        <p class="description"><?php echo esc_html__('Set a word or statement when a user sends it in Messenger plugin will terminate his subscription.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Language', 'smio-push-notification')?></td>
                      <td>
                        <select name="msn_lang" class="regular-text">
                        <?php $fb_langs = smpush_localization::facebook_langs(); foreach($fb_langs as $locale => $lang):?>
                          <option value="<?php echo esc_attr($locale) ?>" <?php if($locale == self::$apisetting['msn_lang']):?>selected="selected"<?php endif;?>><?php echo esc_attr($lang) ?></option>
                        <?php endforeach;?>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top"><td colspan="2"><strong><?php echo esc_html__('WooCommerce Widget', 'smio-push-notification')?></strong></td></tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Checkout Page', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="msn_woo_checkout" <?php if(self::$apisetting['msn_woo_checkout'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Show widget in the checkout page to request from user subscribe to receive his order status updates', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Cart Button', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="msn_woo_cartbtn" <?php if(self::$apisetting['msn_woo_cartbtn'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Show send us button after add to cart button in the product page', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top"><td colspan="2"><strong><?php echo esc_html__('Messenger Widget', 'smio-push-notification')?></strong></td></tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Status', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="msn_widget_status" <?php if(self::$apisetting['msn_widget_status'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable Messenger widget to allow for plugin collect your subscribers when messaging you', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Facebook Page Link', 'smio-push-notification')?></td>
                      <td>
                        <input type="url" name="msn_fbpage_link" value="<?php echo esc_attr(self::$apisetting['msn_fbpage_link']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Widget Title', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_widget_title" value="<?php echo esc_attr(self::$apisetting['msn_widget_title']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top"><td colspan="2"><strong><?php echo esc_html__('Official Messenger Chat Plugin', 'smio-push-notification')?></strong></td></tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Status', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="msn_official_widget_status" <?php if(self::$apisetting['msn_official_widget_status'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable Messenger chat plugin to allow for plugin collect your subscribers and customers chating with you from website.', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('A. Facebook requires your website served over HTTPS to activate this plugin.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('B. Whitelist your domain:', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('1. Click Settings at the top of your Page.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('2. Click Messenger Platform on the left.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('3. Edit whitelisted domains for your page in the Whitelisted Domains section.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('For further info', 'smio-push-notification')?> <a href="https://developers.facebook.com/docs/messenger-platform/reference/messenger-profile-api/domain-whitelisting" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Facebook Page ID', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="msn_official_fbpage_id" value="<?php echo esc_attr(self::$apisetting['msn_official_fbpage_id']); ?>" class="regular-text" size="80" />
                        <p class="description"><?php echo esc_html__('Find your Facebook ID', 'smio-push-notification')?> <a href="https://findmyfbid.com" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top"><td colspan="2"><strong><?php echo esc_html__('Messenger Button', 'smio-push-notification')?></strong></td></tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Shortcode', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="[smart_push_messenger]" onclick="jQuery(this).select()" readonly class="regular-text" size="40" /><br />
                        <input type="text" value="[smart_push_messenger width=&quot;160&quot; height=&quot;40&quot; text=&quot;Send us message&quot; bgcolor=&quot;#0084ff&quot; color=&quot;#fff&quot;]" onclick="jQuery(this).select()" readonly class="regular-text" size="100" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Facebook Page Link', 'smio-push-notification')?></td>
                      <td>
                        <input type="url" name="msn_btn_fblink" value="<?php echo esc_attr(self::$apisetting['msn_btn_fblink']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_btn_text" value="<?php echo esc_attr(self::$apisetting['msn_btn_text']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Width', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="msn_btn_width" value="<?php echo esc_attr(self::$apisetting['msn_btn_width']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Height', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="msn_btn_height" value="<?php echo esc_attr(self::$apisetting['msn_btn_height']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Text Color', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_btn_color" value="<?php echo esc_attr(self::$apisetting['msn_btn_color']); ?>" class="smpush_color_picker" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Background Color', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="msn_btn_bgcolor" value="<?php echo esc_attr(self::$apisetting['msn_btn_bgcolor']); ?>" class="smpush_color_picker" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Icon', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_msnbtnicon" type="url" size="60" name="msn_btn_icon" value="<?php echo self::$apisetting['msn_btn_icon']?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_msnbtnicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-viber smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/viber.png" alt="" /> <span>Viber</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Access Token', 'smio-push-notification')?></td>
                    <td>
                      <input type="text" name="viber_app_key" value="<?php echo esc_attr(self::$apisetting['viber_app_key']); ?>" class="regular-text" size="80" />
                      <?php if(!empty(self::$apisetting['viber_error'])):?><?php echo esc_html__('Error while connecting with Viber, try save changes again or check the access token.', 'smio-push-notification')?><?php endif;?>
                      <p class="description"><?php echo esc_html__('Create Viber bot', 'smio-push-notification')?> <a href="https://partners.viber.com/account/create-bot-account" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a> </p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Subscribe Command', 'smio-push-notification')?></td>
                    <td>
                      <input type="text" name="viber_subs_command" placeholder="e.g. subscribe me" value="<?php echo esc_attr(self::$apisetting['viber_subs_command']); ?>" class="regular-text" size="30" />
                      <p class="description"><?php echo esc_html__('Set a word or statement when a user sends it to Viber bot will process his subscription.', 'smio-push-notification')?></p>
                      <p class="description"><?php echo esc_html__('Leave it empty if you want plugin process any user subscription automatically if he sends any message.', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Unsubscribe Command', 'smio-push-notification')?></td>
                    <td>
                      <input type="text" name="viber_unsubs_command" placeholder="e.g. unsubscribe and delete my account" value="<?php echo esc_attr(self::$apisetting['viber_unsubs_command']); ?>" class="regular-text" size="30" />
                      <p class="description"><?php echo esc_html__('Set a word or statement when a user sends it to Viber bot will terminate his subscription.', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2">
                      <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                      <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                    </td>
                  </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-facebook smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/facebook.png" alt="" /> <span>Facebook Notifications</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Canvas URL', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="<?php echo get_bloginfo('wpurl').'/'.esc_attr(self::$apisetting['push_basename']); ?>/facebook/?action=canvas" class="regular-text" size="80" onclick="jQuery(this).select()" readonly />
                        <p class="description"><?php echo esc_html__('For how to setup Facebook Notifications', 'smio-push-notification')?> <a href="https://smartiolabs.com/product/push-notification-system/documentation#facebook-notifications-configs" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Login URL', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="<?php echo get_bloginfo('wpurl').'/'.esc_attr(self::$apisetting['push_basename']); ?>/facebook/?action=login" class="regular-text" size="80" onclick="jQuery(this).select()" readonly />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('App ID', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fbnotify_appid" value="<?php echo esc_attr(self::$apisetting['fbnotify_appid']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('App Secret', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fbnotify_secret" value="<?php echo esc_attr(self::$apisetting['fbnotify_secret']); ?>" class="regular-text" size="50" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Web Game/App Link', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fbnotify_applink" value="<?php echo esc_attr(self::$apisetting['fbnotify_applink']); ?>" class="regular-text" size="80" />
                        <p class="description"><?php echo esc_html__('Enter your Facebook game or app link to open it after authenticating', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Open Method', 'smio-push-notification')?></td>
                      <td>
                        <select name="fbnotify_method" class="regular-text" onchange="if(this.value == 'iframe')jQuery('.FBnotifyFrameSize').show(); else jQuery('.FBnotifyFrameSize').hide();">
                          <option value="iframe"><?php echo esc_html__('In Iframe', 'smio-push-notification')?></option>
                          <option value="redirect" <?php if(self::$apisetting['fbnotify_method'] == 'redirect'):?>selected="selected"<?php endif;?>><?php echo esc_html__('Redirect visitor to your web link', 'smio-push-notification')?></option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top" class="FBnotifyFrameSize" <?php if(self::$apisetting['fbnotify_method'] == 'redirect'):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Frame Size', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fbnotify_width" value="<?php echo esc_attr(self::$apisetting['fbnotify_width']); ?>" class="regular-text" size="10" placeholder="<?php echo esc_html__('Width', 'smio-push-notification')?>" />
                        <input type="text" name="fbnotify_height" value="<?php echo esc_attr(self::$apisetting['fbnotify_height']); ?>" class="regular-text" size="10" placeholder="<?php echo esc_html__('Height', 'smio-push-notification')?>" />
                      </td>
                    </tr>
                    <tr valign="top"><td colspan="2"><strong><?php echo esc_html__('Login Button', 'smio-push-notification')?></strong></td></tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Shortcode', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="[smart_push_fbloign]" onclick="jQuery(this).select()" readonly class="regular-text" size="40" /><br />
                        <input type="text" value="[smart_push_fbloign width=&quot;205&quot; height=&quot;40&quot; text=&quot;Login With Facebook&quot; bgcolor=&quot;#0084ff&quot; color=&quot;#fff&quot; redirect=&quot;&quot;]" onclick="jQuery(this).select()" readonly class="regular-text" size="100" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Actions', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="fblogin_regin_newsletter" <?php if(self::$apisetting['fblogin_regin_newsletter'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Use Facebook email to register user as Newsletter subscriber', 'smio-push-notification')?></label><br>
                        <label><input type="checkbox" value="1" name="fblogin_regin_fbnotifs" <?php if(self::$apisetting['fblogin_regin_fbnotifs'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Use Facebook ID to register user as Facebook Notification subscriber', 'smio-push-notification')?></label><br>
                        <label><input type="checkbox" value="1" name="fblogin_regin_wpuser" <?php if(self::$apisetting['fblogin_regin_wpuser'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Use Facebook info to register user as WordPress user', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Redirect To', 'smio-push-notification')?></label></td>
                      <td>
                        <code><?php echo get_bloginfo('wpurl') ; ?>/</code><input name="fblogin_btn_redirect" type="text" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_redirect']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Button Text', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fblogin_btn_text" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_text']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Width', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="fblogin_btn_width" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_width']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Height', 'smio-push-notification')?></td>
                      <td>
                        <input type="number" name="fblogin_btn_height" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_height']); ?>" class="regular-text" size="60" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Text Color', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fblogin_btn_color" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_color']); ?>" class="smpush_color_picker" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Background Color', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="fblogin_btn_bgcolor" value="<?php echo esc_attr(self::$apisetting['fblogin_btn_bgcolor']); ?>" class="smpush_color_picker" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Icon', 'smio-push-notification')?></td>
                      <td>
                        <input class="smpush_upload_field_fbloginicon" type="url" size="60" name="fblogin_btn_icon" value="<?php echo self::$apisetting['fblogin_btn_icon']?>" />
                        <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_fbloginicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-email smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/email.png" alt="" /> <span>Newsletter</span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first">SMTP</td>
                      <td>
                        <label><input type="checkbox" value="1" name="smtp_status" <?php if(self::$apisetting['smtp_status'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable SMTP mail method to reach inbox easily', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('Ask your host provider about your SMTP configurations', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('SMTP Host', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="smtp_host" value="<?php echo esc_attr(self::$apisetting['smtp_host']); ?>" class="regular-text" size="40" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Secure', 'smio-push-notification')?></label></td>
                      <td>
                        <select name="smtp_secure" class="postform">
                            <option value=""><?php echo esc_html__('None', 'smio-push-notification')?></option>
                            <option value="ssl" <?php if (self::$apisetting['smtp_secure'] == 'ssl') { ?>selected="selected"<?php } ?>>SSL</option>
                            <option value="tls" <?php if (self::$apisetting['smtp_secure'] == 'tls') { ?>selected="selected"<?php } ?>>TLS</option>
                        </select>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Port', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="smtp_port" value="<?php echo esc_attr(self::$apisetting['smtp_port']); ?>" class="regular-text" size="10" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Username', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="smtp_username" value="<?php echo esc_attr(self::$apisetting['smtp_username']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Password', 'smio-push-notification')?></td>
                      <td>
                        <input type="password" name="smtp_password" value="<?php echo esc_attr(self::$apisetting['smtp_password']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-welcmsg smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/welcome.png" alt="" /> <span><?php echo esc_html__('Desktop Welcome Message', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_welc_redir" type="checkbox" value="1" <?php if (self::$apisetting['desktop_welc_redir'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable redirect user to link after successful subscription', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Redirected Link', 'smio-push-notification')?></td>
                      <td>
                        <input name="desktop_welc_redir_link" class="regular-text" type="url" size="50" value="<?php echo self::$apisetting['desktop_welc_redir_link']?>" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="desktop_welc_status" type="checkbox" value="1" <?php if (self::$apisetting['desktop_welc_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable desktop push notification welcome message', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="middle">
                      <td class="first"><?php echo esc_html__('Title', 'smio-push-notification')?></td>
                      <td>
                         <input name="desktop_welc_title" class="regular-text" type="text" size="50" value="<?php echo self::$apisetting['desktop_welc_title']?>" onkeyup="jQuery('.smpush-sample_notification_title').html(this.value)" />
                      </td>
                      <td rowspan="3">
                        <div class="smpush-sample_notification">
                          <img src="" class="smpush-sample_notification_logo">
                          <button type="button" class="smpush-close" aria-label="Close"><span aria-hidden="true">×</span></button>
                          <div class="smpush-sample_notification_title"><?php echo esc_html__('Notification Title', 'smio-push-notification')?></div>
                          <div class="smpush-sample_notification_message"><?php echo esc_html__('This is the Notification Message', 'smio-push-notification')?></div>
                          <div class="smpush-sample_notification_url"><?php echo esc_url($_SERVER['HTTP_HOST']) ?></div>
                        </div>
                      </td>
                   </tr>
                   <tr valign="top">
                      <td class="first"><?php echo esc_html__('Message', 'smio-push-notification')?></td>
                      <td>
                         <textarea name="desktop_welc_message" cols="40" rows="10" id="smpush-message" onkeyup="jQuery('.smpush-sample_notification_message').html(this.value)" class="regular-text"><?php echo wp_kses(self::$apisetting['desktop_welc_message'], smpush_allowed_html) ?></textarea>
                      </td>
                   </tr>
                   <tr valign="middle">
                      <td class="first"><?php echo esc_html__('Icon', 'smio-push-notification')?></td>
                      <td>
                         <input class="smpush_upload_field_deskicon" type="url" size="60" name="desktop_welc_icon" value="<?php echo self::$apisetting['desktop_welc_icon']?>" onchange="jQuery('.smpush-sample_notification_logo').attr('src',this.value)" />
                          <input class="smpush_upload_file_btn button action" data-container="smpush_upload_field_deskicon" type="button" value="<?php echo esc_html__('Select File', 'smio-push-notification')?>" />
                          <p class="description"><?php echo esc_html__('Choose an icon in a standard size 192x192 px', 'smio-push-notification')?></p>
                      </td>
                   </tr>
                   <tr valign="middle">
                      <td class="first"><?php echo esc_html__('Link To Open', 'smio-push-notification')?></td>
                      <td>
                         <input name="desktop_welc_link" class="regular-text" type="url" size="50" value="<?php echo self::$apisetting['desktop_welc_link']?>" />
                         <p class="description"><?php echo esc_html__('Open link when user clicks on notification message', 'smio-push-notification')?></p>
                      </td>
                   </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-subs_page smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/form.png" alt="" /> <span><?php echo esc_html__('Subscription Page', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Shortcode', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" value="[smart_subscription_page]" onclick="jQuery(this).select()" readonly class="regular-text" size="40" />
                      </td>
                    </tr>
                   <tr valign="top">
                      <td class="first"><?php echo esc_html__('Geo-Fence', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_geo_status" <?php if(self::$apisetting['subspage_geo_status'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Allow to users selecting area to receive notifications about posts that located inside it', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('Must set latitude and longitude keys from post meta keys to enable this feature', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top" class="smpush_geo_fields" <?php if(self::$apisetting['subspage_geo_status'] == 0):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Latitude Meta Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="subspage_geo_lat" value="<?php echo esc_attr(self::$apisetting['subspage_geo_lat']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top" class="smpush_geo_fields" <?php if(self::$apisetting['subspage_geo_status'] == 0):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('Longitude Meta Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="subspage_geo_lng" value="<?php echo esc_attr(self::$apisetting['subspage_geo_lng']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top" class="smpush_geo_fields" <?php if(self::$apisetting['subspage_geo_status'] == 0):?>style="display:none"<?php endif;?>>
                      <td class="first"><?php echo esc_html__('OR ACF Field Key', 'smio-push-notification')?></td>
                      <td>
                        <input type="text" name="subspage_geo_acf" value="<?php echo esc_attr(self::$apisetting['subspage_geo_acf']); ?>" class="regular-text" size="30" />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Keywords', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_keywords" <?php if(self::$apisetting['subspage_keywords'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable users entering some keywords to receive notifications about them', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Channels', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_channels" <?php if(self::$apisetting['subspage_channels'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable users choosing between the plugin channels', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Temperature', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_rating" class="smpush_toggle" toggle-elements="smio-rehub-options" <?php if(self::$apisetting['subspage_rating'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable selecting post temperature for Rehub theme', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top" class="smio-rehub-options">
                      <td class="first"><?php echo esc_html__('Temperature Grades', 'smio-push-notification')?></td>
                      <td>
                        <?php echo esc_html__('Starts from', 'smio-push-notification')?>
                        <input type="number" step="10" value="<?php echo self::$apisetting['subspage_rating_start'] ?>" min="0" name="subspage_rating_start" size="6" style="width: 60px" />
                        <?php echo esc_html__('Increases by', 'smio-push-notification')?>
                        <input type="number" step="10" value="<?php echo self::$apisetting['subspage_rating_step'] ?>" min="0" name="subspage_rating_step" size="6" style="width: 60px" />
                        <?php echo esc_html__('Ends with', 'smio-push-notification')?>
                        <input type="number" step="10" value="<?php echo self::$apisetting['subspage_rating_end'] ?>" min="0" name="subspage_rating_end" size="6" style="width: 60px" />
                      </td>
                    </tr>
                    <tr valign="top" class="smio-rehub-options">
                      <td class="first"><?php echo esc_html__('Temperature Expiration', 'smio-push-notification')?></td>
                      <td>
                        <p><?php echo esc_html__('Exclude posts before user registration by ', 'smio-push-notification')?>
                        <input type="number" step="1" value="<?php echo self::$apisetting['subspage_rating_user_expire'] ?>" min="0" name="subspage_rating_user_expire" size="6" style="width: 60px" />
                        <?php echo esc_html__(' days.', 'smio-push-notification')?></p>
                        <p><?php echo esc_html__('Exclude posts that older than ', 'smio-push-notification')?>
                        <input type="number" step="1" value="<?php echo self::$apisetting['subspage_rating_pub_expire'] ?>" min="0" name="subspage_rating_pub_expire" size="6" style="width: 60px" />
                        <?php echo esc_html__(' days.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Categories', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_cats_status" <?php if(self::$apisetting['subspage_cats_status'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Show categories for users to subscribe in its posts notifications', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Categories Images', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_show_catimages" <?php if(self::$apisetting['subspage_show_catimages'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Display categories in a grid view with images', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('To enable categories images you need to install this plugin', 'smio-push-notification')?> <a href="http://wordpress.org/plugins/categories-images/" target="_blank"><?php echo esc_html__('click here', 'smio-push-notification')?></a></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Match Case', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_matchone" <?php if(self::$apisetting['subspage_matchone'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Send to user if the notification accepts one of his categories, keywords or geo-fence entries.', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                   <tr valign="top">
                     <td class="first"><?php echo esc_html__('Categories Source', 'smio-push-notification')?></td>
                      <td>
                        <select name="subspage_post_type" onchange="smiopushPostType(this)">
                        <option value="post" <?php if(self::$apisetting['subspage_post_type'] == 'post'){?>selected="selected"<?php }?>>Post</option>
                        <?php $post_types = get_post_types(array('_builtin' => false, 'public' => true));foreach ($post_types as $post_type):?>
                         <option value="<?php echo esc_attr($post_type); ?>" <?php if(self::$apisetting['subspage_post_type'] == $post_type){?>selected="selected"<?php }?>><?php echo esc_attr($post_type);?></option>
                         <?php endforeach;?>
                      </select>
                       <select name="subspage_post_type_tax" id="smiopushPostTaxSelc" onchange="smiopushPostTax(this)">
                         <?php $taxonomy_objects = get_object_taxonomies(self::$apisetting['subspage_post_type'], 'objects');foreach ($taxonomy_objects as $type => $object):?>
                          <option value="<?php echo esc_attr($type);?>" <?php if(self::$apisetting['subspage_post_type_tax'] == $type){?>selected="selected"<?php }?>><?php echo esc_attr($type);?></option>
                          <?php endforeach;?>
                       </select>
                        <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smiopush_taxs_load" style="display:none" alt="" /><br />
                        <div id="taxonomy-category" class="categorydiv" style="margin-top:5px">
                          <div id="category-all" class="tabs-panel">
                           <ul id="categorychecklist" data-wp-lists="list:category" class="smiopushPostTaxDIV categorychecklist form-no-clear">
                            <?php wp_terms_checklist(0, array('selected_cats' => self::$apisetting['subspage_category'],'taxonomy' => self::$apisetting['subspage_post_type_tax'], 'checked_ontop' => false));?>
                           </ul>
                          </div>
                        </div>
                      </td>
                   </tr>
                   <tr valign="top">
                      <td class="first"><?php echo esc_html__('Supported Platforms', 'smio-push-notification')?></td>
                      <td>
                        <label><input type="checkbox" value="1" name="subspage_plat_web" <?php if(self::$apisetting['subspage_plat_web'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Web Push Notification', 'smio-push-notification')?></label><br />
                        <label><input type="checkbox" value="1" name="subspage_plat_mobile" <?php if(self::$apisetting['subspage_plat_mobile'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Mobile Push Notification', 'smio-push-notification')?></label><br />
                        <label><input type="checkbox" value="1" name="subspage_plat_msn" <?php if(self::$apisetting['subspage_plat_msn'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Facebook Messenger', 'smio-push-notification')?></label><br />
                        <label><input type="checkbox" value="1" name="subspage_plat_email" <?php if(self::$apisetting['subspage_plat_email'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Email', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><?php echo esc_html__('Mobile App Links', 'smio-push-notification')?></td>
                      <td>
                        <input type="url" name="subspage_applink_play" value="<?php echo esc_attr(self::$apisetting['subspage_applink_play']); ?>" placeholder="<?php echo esc_html__('Google Play', 'smio-push-notification')?>" class="regular-text" size="60" /><br />
                        <input type="url" name="subspage_applink_ios" value="<?php echo esc_attr(self::$apisetting['subspage_applink_ios']); ?>" placeholder="<?php echo esc_html__('App Store', 'smio-push-notification')?>" class="regular-text" size="60" /><br />
                        <input type="url" name="subspage_applink_wp" value="<?php echo esc_attr(self::$apisetting['subspage_applink_wp']); ?>" placeholder="<?php echo esc_html__('Windows Phone', 'smio-push-notification')?>" class="regular-text" size="60" /><br />
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/events.png" alt="" /> <span><?php echo esc_html__('Push Notification Events', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_post_chantocats" type="checkbox" value="1" <?php if (self::$apisetting['e_post_chantocats'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify only members which subscribed in a channel name equivalent with the post category name', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_appcomment" type="checkbox" value="1" <?php if (self::$apisetting['e_appcomment'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when administrator approved on his comment', 'smio-push-notification')?></label>
                        <input name="e_appcomment_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_appcomment_body']); ?>' class="regular-text" size="80">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_newcomment" type="checkbox" value="1" <?php if (self::$apisetting['e_newcomment'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify author when added new comment on his post', 'smio-push-notification')?></label>
                        <input name="e_newcomment_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_newcomment_body']); ?>' class="regular-text" size="80">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_newcomment_allusers" type="checkbox" value="1" <?php if (self::$apisetting['e_newcomment_allusers'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify all users that commented on a post when adding a new comment on this post', 'smio-push-notification')?></label>
                        <input name="e_newcomment_allusers_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_newcomment_allusers_body']); ?>' class="regular-text" size="80">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_newcomment_mentions" type="checkbox" value="1" <?php if (self::$apisetting['e_newcomment_mentions'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when someone mention him in another comment', 'smio-push-notification')?></label>
                        <input name="e_newcomment_mentions_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_newcomment_mentions_body']); ?>' class="regular-text" size="80">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_usercomuser" type="checkbox" value="1" <?php if (self::$apisetting['e_usercomuser'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when someone comment on his comment', 'smio-push-notification')?></label>
                        <input name="e_usercomuser_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_usercomuser_body']); ?>' class="regular-text" size="80">
                        <br class="clear">
                        <p class="description"><?php echo esc_html__('Notice: System will replace {subject},{comment} words with the subject of topic or comment content.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Notice: System will send the topic ID with the push notification message as name `relatedvalue`.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Notice: To use this feature first please enable the cron-job service, Look', 'smio-push-notification')?> <a href="http://smartiolabs.com/product/push-notification-system/documentation#cron-job" target="_blank"><?php echo esc_html__('here', 'smio-push-notification')?></a> <?php echo esc_html__('for further information', 'smio-push-notification')?></p>                      </td>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/woocommerce.png" alt="" /> <span><?php echo esc_html__('WooCommerce', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <tr valign="top">
                    <td colspan="2">
                      <label><input name="e_woo_waiting" type="checkbox" value="1" <?php if (self::$apisetting['e_woo_waiting'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Show waiting list button for out of stock products where user can select it to be notified once product is available in stock again.', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Title', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_waiting_title" class="regular-text" type="text" size="40" value="<?php echo self::$apisetting['e_woo_waiting_title']?>" />
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Message', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_waiting_message" class="regular-text" type="text" size="70" value="<?php echo self::$apisetting['e_woo_waiting_message']?>" />
                      <br class="clear">
                      <p class="description"><?php echo esc_html__('Available variables', 'smio-push-notification')?> <code>{id}</code> <code>{title}</code> <code>{stock}</code> <code>{price}</code> <code>{discount}</code> <code>{description}</code></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2">
                      <label><input name="e_woo_abandoned" type="checkbox" value="1" <?php if (self::$apisetting['e_woo_abandoned'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Enable the push notifications reminders for abandoned carts.', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Reminder After', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_maxage" class="regular-text" type="number" size="5" value="<?php echo self::$apisetting['e_woo_aband_maxage']?>" /> <?php echo esc_html__('hour', 'smio-push-notification')?>
                      <p class="description"><?php echo esc_html__('Run the reminder for carts that remains inactive for number of hours', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Reminder Max Times', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_times" class="regular-text" type="number" size="5" value="<?php echo self::$apisetting['e_woo_aband_times']?>" />
                      <p class="description"><?php echo esc_html__('Run the reminder for number of times then disable it', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Reminder Interval', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_interval" class="regular-text" type="number" size="5" value="<?php echo self::$apisetting['e_woo_aband_interval']?>" /> <?php echo esc_html__('hour', 'smio-push-notification')?>
                      <p class="description"><?php echo esc_html__('Time between each reminder and other', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Title', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_title" class="regular-text" type="text" size="40" value="<?php echo self::$apisetting['e_woo_aband_title']?>" />
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Message', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_message" class="regular-text" type="text" size="70" value="<?php echo self::$apisetting['e_woo_aband_message']?>" />
                      <br class="clear">
                      <p class="description"><?php echo esc_html__('Available variables', 'smio-push-notification')?><code>{productscount}</code> <code>{totalmoney}</code> <code>{customer_name}</code></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Last Reminder', 'smio-push-notification')?></td>
                    <td>
                      <label><input name="e_woo_aband_last_rem" type="checkbox" value="1" <?php if (self::$apisetting['e_woo_aband_last_rem'] == 1) { ?>checked="checked"<?php } ?> />
                      <?php echo esc_html__('The last notification message before disabling the reminder for the cart', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Title', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_last_title" class="regular-text" type="text" size="40" value="<?php echo self::$apisetting['e_woo_aband_last_title']?>" />
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Notification Message', 'smio-push-notification')?></td>
                    <td>
                      <input name="e_woo_aband_last_message" class="regular-text" type="text" size="70" value="<?php echo self::$apisetting['e_woo_aband_last_message']?>" />
                      <br class="clear">
                      <p class="description"><?php echo esc_html__('Available variables', 'smio-push-notification')?><code>{productscount}</code> <code>{totalmoney}</code> <code>{customer_name}</code></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2">
                      <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                      <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                    </td>
                  </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/wpjobman.png" alt="" /> <span><?php echo esc_html__('WP Job Manager', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_wpjobman_status" type="checkbox" value="1" <?php if (self::$apisetting['e_wpjobman_status'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when has a new job offers match his choices', 'smio-push-notification')?></label>
                        <input name="e_wpjobman_body" type="text" value='<?php echo esc_attr(self::$apisetting['e_wpjobman_body']); ?>' class="regular-text" size="80">
                        <br class="clear">
                        <p class="description"><?php echo esc_html__('Notice: System will replace {counter} word with the number of matched job offers.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Notice: System will replace {alert} word with the title of job alert.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Notice: To use this feature first please enable the cron-job service, Look', 'smio-push-notification')?> <a href="http://smartiolabs.com/product/push-notification-system/documentation#cron-job" target="_blank"><?php echo esc_html__('here', 'smio-push-notification')?></a> <?php echo esc_html__('for further information', 'smio-push-notification')?></p>                      </td>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/mycred.png" alt="" /> <span><?php echo esc_html__('myCred', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_mycred_nbalance" type="checkbox" value="1" <?php if (self::$apisetting['e_mycred_nbalance'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when he gets new points', 'smio-push-notification')?></label>
                        <input name="e_mycred_nbalance_b" type="text" value='<?php echo esc_attr(self::$apisetting['e_mycred_nbalance_b']); ?>' class="regular-text" size="80">
                        <br class="clear">
                        <p class="description"><?php echo esc_html__('Notice: System will replace {credits} word with the value of received points.', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Replace {balance} word with the value of user total balance.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                        <label><input name="e_mycred_transfer" type="checkbox" value="1" <?php if (self::$apisetting['e_mycred_transfer'] == 1) { ?>checked="checked"<?php } ?>> <?php echo esc_html__('Notify user when he received a transfer from some person', 'smio-push-notification')?></label>
                        <input name="e_mycred_transfer_b" type="text" value='<?php echo esc_attr(self::$apisetting['e_mycred_transfer_b']); ?>' class="regular-text" size="80">
                        <br class="clear">
                        <p class="description"><?php echo esc_html__('Notice: System will replace {value} word with the value of transfer such money, points, badges etc...', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Replace {point_type} word with the transfer type such money, point, badge etc...', 'smio-push-notification')?></p>
                        <p class="description"><?php echo esc_html__('Replace {sender} word with the name of sender.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('Notification Title', 'smio-push-notification')?></label></td>
                      <td>
                        <input name="e_mycred_title" type="text" value="<?php echo esc_attr(self::$apisetting['e_mycred_title']); ?>" class="regular-text">
                      </td>
                    </tr>
                    <tr valign="top">
                      <td class="first"><label><?php echo esc_html__('myCred Page Link', 'smio-push-notification')?></label></td>
                      <td>
                        <code><?php echo get_bloginfo('wpurl') ; ?>/</code><input name="e_mycred_page" type="text" value="<?php echo esc_attr(self::$apisetting['e_mycred_page']); ?>" class="regular-text">
                        <br class="clear">
                        <p class="description"><?php echo esc_html__('Link to redirect user after click on myCred notifications like a page to see his balance.', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/peepso.png" alt="" /> <span><?php echo esc_html__('PeepSo', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <tr valign="top">
                    <td>
                      <label><input name="peepso_notifications" type="checkbox" value="1" <?php if (self::$apisetting['peepso_notifications'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Enable all PeepSo notifications', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-events smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/buddypress.png" alt="" /> <span><?php echo esc_html__('BuddyPress Events', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                    <tr valign="top">
                      <td>
                        <label><input name="bb_notify_friends" type="checkbox" value="1" <?php if (self::$apisetting['bb_notify_friends'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Enable user receive push notification for friends component', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td>
                        <label><input name="bb_notify_messages" type="checkbox" value="1" <?php if (self::$apisetting['bb_notify_messages'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Enable user receive push notification for messages component', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td>
                        <label><input name="bb_notify_activity" type="checkbox" value="1" <?php if (self::$apisetting['bb_notify_activity'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Enable user receive push notification for activity component', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td>
                        <label><input name="bb_notify_activity_admins_only" type="checkbox" value="1" <?php if (self::$apisetting['bb_notify_activity_admins_only'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Send push notifications for group activities to administrators only', 'smio-push-notification')?></label>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td>
                        <label><input name="bb_notify_xprofile" type="checkbox" value="1" <?php if (self::$apisetting['bb_notify_xprofile'] == 1) { ?>checked="checked"<?php } ?>>&nbsp;
                        <?php echo esc_html__('Enable user receive push notification for xprofile component', 'smio-push-notification')?></label>
                        <p class="description"><?php echo esc_html__('Notice: To use this feature first please enable the cron-job service, Look', 'smio-push-notification')?> <a href="https://smartiolabs.com/product/push-notification-system/documentation#cron-job" target="_blank"><?php echo esc_html__('here', 'smio-push-notification')?></a> <?php echo esc_html__('for further information', 'smio-push-notification')?></p>
                      </td>
                    </tr>
                    <tr valign="top">
                      <td colspan="2">
                          <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                          <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div id="col-left" class="smpush-tabs-gdpr smpush-radio-tabs">
        <div id="post-body" class="metabox-holder columns-2">
          <div>
            <div id="namediv" class="stuffbox">
              <h3><label><img src="<?php echo smpush_imgpath; ?>/gdpr.png" alt="" /> <span><?php echo esc_html__('GDPR Compliance', 'smio-push-notification')?></span></label></h3>
              <div class="inside">
                <table class="form-table">
                  <tbody>
                  <tr valign="top">
                    <td class="first"><label><?php echo esc_html__('Terms Page Link', 'smio-push-notification')?></label></td>
                    <td>
                      <code><?php echo get_bloginfo('wpurl') ; ?>/</code><input name="gdpr_termslink" type="text" value="<?php echo esc_attr(self::$apisetting['gdpr_termslink']); ?>" class="regular-text">
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><label><?php echo esc_html__('Privacy Page Link', 'smio-push-notification')?></label></td>
                    <td>
                      <code><?php echo get_bloginfo('wpurl') ; ?>/</code><input name="gdpr_privacylink" type="text" value="<?php echo esc_attr(self::$apisetting['gdpr_privacylink']); ?>" class="regular-text">
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Icon', 'smio-push-notification')?></td>
                    <td>
                      <label><input type="checkbox" value="1" name="gdpr_icon" <?php if(self::$apisetting['gdpr_icon'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Enable showing icon where users can unsubscribe at anytime', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Subscription Page', 'smio-push-notification')?></td>
                    <td>
                      <label><input type="checkbox" value="1" name="gdpr_subs_btn" <?php if(self::$apisetting['gdpr_subs_btn'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Show unsubscribe and delete user subscription button in the subscription page.', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Agreement Verification', 'smio-push-notification')?></td>
                    <td>
                      <label><input type="checkbox" value="1" name="gdpr_ver_option" <?php if(self::$apisetting['gdpr_ver_option'] == 1):?>checked="checked"<?php endif;?> /> <?php echo esc_html__('Show agreement verification for all subscription forms and pages.', 'smio-push-notification')?></label>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Verification Text', 'smio-push-notification')?></td>
                    <td>
                      <input name="gdpr_ver_text" type="text" value="<?php echo esc_attr(self::$apisetting['gdpr_ver_text']); ?>" class="regular-text" size="80">
                    </td>
                  </tr>
                  <tr valign="top">
                    <td class="first"><?php echo esc_html__('Agreement Statement', 'smio-push-notification')?></td>
                    <td>
                      <textarea readonly cols="50" rows="15" style="width: 70%" onclick="jQuery(this).select()"><?php include(smpush_dir.'/pages/privacy.php')?></textarea>
                      <p class="description"><?php echo esc_html__('You can use or append this statement into your privacy policy page.', 'smio-push-notification')?></p>
                    </td>
                  </tr>
                  <tr valign="top">
                    <td colspan="2">
                      <input type="submit" name="submit" class="button button-primary" value="<?php echo esc_html__('Save All Settings', 'smio-push-notification')?>">
                      <img src="<?php echo smpush_imgpath; ?>/wpspin_light.gif" class="smpush_process" alt="" />
                    </td>
                  </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>
<style>
input.labelauty + label{margin-top: 5px;height:70px!important;width:70px!important;background-color: #eaeaea!important;}
input.labelauty + label > img{width: 24px!important;height: 24px;}
</style>
<script type="text/javascript">
jQuery(document).ready(function() {
  "use strict";
  
  jQuery(".smpush_toggle").on("change", function () {
    if(jQuery(this).is(':checked')){
      jQuery("."+jQuery(this).attr("toggle-elements")).show();
    } else {
      jQuery("."+jQuery(this).attr("toggle-elements")).hide();
    }
  });
  jQuery(".smpush_toggle").trigger("change");

  jQuery("input[name='desktop_webpush'], input[name='desktop_webpush_old']").on("change", function () {
    if(jQuery("input[name='desktop_webpush']").is(':checked') && jQuery("input[name='desktop_webpush_old']").is(':checked')){
      jQuery(".desktop_webpush_hide").show();
      jQuery(".desktop_webpush_show").show();
    }
    else if(jQuery("input[name='desktop_webpush']").is(':checked')){
      jQuery(".desktop_webpush_hide").hide();
      jQuery(".desktop_webpush_show").show();
    }
    else{
      jQuery(".desktop_webpush_show").hide();
      jQuery(".desktop_webpush_hide").show();
    }
  });
  jQuery("input[name='desktop_webpush']").trigger("change");

  jQuery("input[name='chrome_apikey'], textarea[name='firebase_config']").on("change", function () {
    if(jQuery(this).val().length > 0 && jQuery(this).val().length < 100){
      alert("Please enter a valid API key. copy Server key not Legacy server key from Firebase console.");
      jQuery(this).val("");
    }
  });

  jQuery("textarea[name='firebase_config']").on("change", function () {
    let fireconfig = jQuery(this).val().replace(/const\s?firebaseConfig\s?=\s?/gi, "").replace("};", "}").replace("} ;", "}");
    try {
      let obj = eval('(' + fireconfig + ')');
      fireconfig = JSON.stringify(obj);
      try {
        JSON.parse(fireconfig);
        jQuery(this).val(fireconfig);
        console.log(fireconfig);
      } catch(e) {
        alert("Please enter a valid Firebase config");
        jQuery(this).val("");
      }
    } catch (e) {
      if (e instanceof SyntaxError) {
        alert("Please enter a valid Firebase config");
      }
    }
  });

  jQuery("input[name='subspage_geo_status']").on("change", function () {
    if(jQuery(this).is(':checked')){
      jQuery(".smpush_geo_fields").show();
    }
    else{
      jQuery(".smpush_geo_fields").hide();
    }
  });

  if(jQuery('.smpush_color_picker').length > 0){
    jQuery('.smpush_color_picker').wpColorPicker();
  }

  jQuery(".smpush_jradio").on("change", function () {
    jQuery(".smpush-radio-tabs").hide();
    jQuery(".smpush-tabs-"+jQuery(this).val()).show();
  });

  jQuery("#smpush_jform .smpush_jradio:first").trigger("click");

});

function smiopushPostType(select){
  jQuery('.smiopush_taxs_load').show();
  jQuery.get("<?php echo $page_url?>&loadtaxs=1&noheader=1&smiopush_post_type="+jQuery(select).val(), function(data){
    jQuery('.smiopush_taxs_load').hide();
    jQuery("#smiopushPostTaxSelc").html(data);
  });
}

function smiopushPostTax(select){
  jQuery('.smiopush_taxs_load').show();
  jQuery.get("<?php echo $page_url?>&loadcats=1&noheader=1&smiopush_object_name="+jQuery(select).val(), function(data){
    jQuery('.smiopush_taxs_load').hide();
    jQuery(".smiopushPostTaxDIV").html(data);
  });
}
</script>
