<form action="" id="smpush_subscription_form" method="post" style="display:none">
<div id="smpush_notification_header">
  
  <div id="smpush_head_title">
    <?php echo esc_html__('Choose certain keywords, subscribe in interested channels and set categories to receive instant notifications about any new updates match your choices.', 'smio-push-notification')?>
  </div>
  
  <?php if(self::$apisetting['subspage_keywords'] == 1):?>
  <h3><?php echo esc_html__('Keywords', 'smio-push-notification')?> <i title="<?php echo esc_html__('Updates must contains one of your keywords to reach you', 'smio-push-notification')?>"></i></h3>
  <input type="text" id="smpush_keywords" name="keywords" value="<?php echo esc_attr($subscription['keywords'])?>" style="display: none" />
  <?php endif;?>
  
  <?php if(self::$apisetting['subspage_cats_status'] == 1 && self::$apisetting['subspage_show_catimages'] == 0):?>
  <h3><?php echo esc_html__('Categories', 'smio-push-notification')?></h3>
  <select id="smpush_categories" name="categories[]" multiple style="display: none">
    <?php foreach($subscription['categories'] as $category):?>
    <option value="<?php echo esc_attr($category['id']) ?>" <?php if($category['selected'] == 1):?>selected="selected"<?php endif;?>><?php echo esc_attr($category['name']) ?></option>
    <?php endforeach;?>
  </select>
  <?php endif;?>
  
  <?php if(self::$apisetting['subspage_geo_status'] == 1):?>
  <h3><?php echo esc_html__('Location', 'smio-push-notification')?> <i title="<?php echo esc_html__('Draw a circle area to send you notifications about places inside this area only', 'smio-push-notification')?>"></i></h3>
  
  <div id="smio-gmap-container">
    <div id="smio_gmap_search">
      <input type="hidden" name="latitude" id="smio_latitude" value="<?php echo esc_attr($subscription['latitude'])?>" />
      <input type="hidden" name="longitude" id="smio_longitude" value="<?php echo esc_attr($subscription['longitude'])?>" />
      <input id="smio_gmap_address" class="smio_gmap_input" type="text" placeholder="<?php echo esc_html__('Put the search address then press Enter...', 'smio-push-notification')?>" />
      <input name="radius" id="smio_gmap_radius" value="<?php echo esc_attr($subscription['radius'])?>" class="smio_gmap_input" type="number" step="1" placeholder="<?php echo esc_html__('Radius in miles', 'smio-push-notification')?>" style="width:150px" />
   </div>
    <div id="smio-gmap"></div>
  </div>
  <?php endif;?>
  
  <?php if(self::$apisetting['subspage_channels'] == 1):?>
  <h3><?php echo esc_html__('Channels', 'smio-push-notification')?></h3>
  <select id="smpush_channels" name="channels[]" multiple style="display: none">
    <?php foreach($subscription['channels'] as $channel):?>
    <option value="<?php echo esc_attr($channel['id']) ?>" <?php if($channel['subscribed'] == 'yes'):?>selected="selected"<?php endif;?>><?php echo esc_attr($channel['title']) ?></option>
    <?php endforeach;?>
  </select>
  <?php endif;?>

  <?php if(self::$apisetting['subspage_rating'] == 1):?>
    <h3><?php echo esc_html__('Minimum Temperature', 'smio-push-notification')?> <span id="smpush_temp_screen"><?php if(!empty(esc_attr($subscription['temp']))):?>(<?php echo esc_attr($subscription['temp']) ?>&#176;)<?php endif;?></span></h3>
    <button id="smpush_notification_temp" type="button">
      <?php
      $rtcounter = 10;
      for($rtloop=self::$apisetting['subspage_rating_start'];$rtloop<=(self::$apisetting['subspage_rating_end']/self::$apisetting['subspage_rating_step']);$rtloop++):
        $rctemp = $rtloop*self::$apisetting['subspage_rating_step'];
        ?>
        <label <?php if($rtcounter > 10):?>style="background-size: <?php echo esc_attr($rtcounter) ?>px"<?php endif;?> <?php if(esc_attr($subscription['temp']) == $rctemp):?>class="smpush_checked"<?php endif;?>>
          <input type="radio" name="temp" value="<?php echo esc_attr($rctemp) ?>" <?php if(esc_attr($subscription['temp']) == $rctemp):?>checked="checked"<?php endif;?> />
          <?php if($rctemp == self::$apisetting['subspage_rating_start']){ echo ' '.$rctemp.'&#176'; } ?>
        </label>
        <?php $rtcounter = $rtcounter+6; endfor; ?>
    </button>
  <?php endif;?>

  <h3><?php echo esc_html__('Receive On', 'smio-push-notification')?></h3>
  <div id="smpush_receive_on">
    <?php if(self::$apisetting['subspage_plat_web'] == 1):?>
    <button type="button"><img src="<?php echo smpush_imgpath; ?>/chrome.png" /> <span><?php echo esc_html__('Web Push Notification', 'smio-push-notification')?></span> <label><input type="checkbox" name="web" <?php if(esc_attr($subscription['web']) == 1):?>checked="checked"<?php endif;?> /></label></button>
    <?php endif;?>
    <?php if(self::$apisetting['subspage_plat_mobile'] == 1):?>
    <button type="button"><img src="<?php echo smpush_imgpath; ?>/android.png" /> <span><?php echo esc_html__('Mobile Push Notification', 'smio-push-notification')?></span> <label><input type="checkbox" name="mobile" <?php if(esc_attr($subscription['mobile']) == 1):?>checked="checked"<?php endif;?> /></label></button>
    <?php endif;?>
    <?php if(self::$apisetting['subspage_plat_msn'] == 1):?>
    <button type="button"><img src="<?php echo smpush_imgpath; ?>/messenger_w.png" width="24px" /> <span><?php echo esc_html__('Facebook Messenger', 'smio-push-notification')?></span> <label><input type="checkbox" name="msn" <?php if(esc_attr($subscription['msn']) == 1):?>checked="checked"<?php endif;?> /></label></button>
    <?php endif;?>
    <?php if(self::$apisetting['subspage_plat_email'] == 1):?>
    <button type="button"><img src="<?php echo smpush_imgpath; ?>/email.png" /> <span><?php echo esc_html__('Email', 'smio-push-notification')?></span> <label><input type="checkbox" name="email" <?php if(esc_attr($subscription['email']) == 1):?>checked="checked"<?php endif;?> /></label></button>
    <?php endif;?>
  </div>
  
  <p id="smpush_web_instructions" class="smpush_install_instructions">
    <?php echo esc_html__('receive push notification messages on your web browser instantly while browsing', 'smio-push-notification')?><br />
    <?php echo esc_html__('do not waste your time opening emails or sms messages', 'smio-push-notification')?><br />
    <?php echo esc_html__('To subscribe click on', 'smio-push-notification')?>
    <button class="smpush-push-permission-button smpush-push-resubscribe-button" type="button"><?php echo esc_html__('subscribe', 'smio-push-notification')?></button>
    <?php echo esc_html__('you will see permissions box click on Allow button so give us permissions to send you notification messages.', 'smio-push-notification')?>
  </p>
  
  <p id="smpush_mobile_instructions" class="smpush_install_instructions">
    <?php echo esc_html__('install our official mobile app and receive push notification messages on your mobile instantly', 'smio-push-notification')?><br />
    <a href="<?php echo self::$apisetting['subspage_applink_play']?>" target="_blank"><img src="<?php echo smpush_imgpath; ?>/google_play.png" /></a>
    <a href="<?php echo self::$apisetting['subspage_applink_ios']?>" target="_blank"><img src="<?php echo smpush_imgpath; ?>/appstore.png" /></a>
    <a href="<?php echo self::$apisetting['subspage_applink_wp']?>" target="_blank"><img src="<?php echo smpush_imgpath; ?>/windows_store.png" /></a>
  </p>
  
  <div id="smpush_msn_instructions" class="smpush_install_instructions">
    <?php echo esc_html__('Awesome! Give us permission to send you the notification messages to your Messenger directly. Just click on the below button!', 'smio-push-notification')?><br />
    <div style="margin-top:18px" class="fb-send-to-messenger" 
      messenger_app_id="<?php echo self::$apisetting['msn_appid']?>" 
      page_id="<?php echo self::$apisetting['msn_official_fbpage_id']?>" 
      data-ref="subscribed_<?php echo get_current_user_id() ?>" color="white" cta_text="KEEP_ME_UPDATED" size="xlarge"></div>
  </div>
  
</div>

<?php if(self::$apisetting['subspage_cats_status'] == 1 && self::$apisetting['subspage_show_catimages'] == 1):?>
<select id="smpush_categories" name="categories[]" multiple style="display:none">
  <?php foreach($subscription['categories'] as $category):?>
  <option value="<?php echo esc_attr($category['id']) ?>" <?php if($category['selected'] == 1):?>selected="selected"<?php endif;?>><?php echo esc_attr($category['name']) ?></option>
  <?php endforeach;?>
</select>

<div id="smpush_notification_footer">
  <h2><?php echo esc_html__('Subscribe In Categories', 'smio-push-notification')?></h2>
  <?php foreach($subscription['categories'] as $category):?>
  <div class="smpushBox smpushSubsCat  <?php if($category['selected'] == 1):?>smpushBoxSelected<?php endif;?>" data-id="<?php echo esc_attr($category['id']) ?>">
    <strong><?php echo esc_attr($category['name']) ?></strong>
    <?php if(!empty($category['image'])):?><img src="<?php echo esc_url($category['image']); ?>" /><?php endif;?>
    <button type="button" class="smpushBox_sbtn"><span><?php echo esc_html__('Subscribe', 'smio-push-notification')?></span></button>
    <button type="button" class="smpushBox_unsbtn"><img src="<?php echo smpush_imgpath; ?>/checked.png" /> <span><?php echo esc_html__('Subscribed', 'smio-push-notification')?></span></button>
  </div>
  <?php endforeach;?>
</div>
<?php endif;?>

<?php if(self::$apisetting['gdpr_subs_btn'] == 1):?>
<p id="smpush_agreement_hint"><label><input type="checkbox" required /><?php echo self::$apisetting['gdpr_ver_text_processed']?></label></p>
<?php endif;?>

<div id="smpush_div_button" <?php if(self::$apisetting['gdpr_subs_btn'] == 1):?>class="smpush_div_button_gdpr_enabled"<?php endif;?>>
<button type="submit" id="smpush_save_button"><?php echo esc_html__('Save My Subscription', 'smio-push-notification')?></button>
  <?php if(self::$apisetting['gdpr_subs_btn'] == 1):?>
<button type="button" id="smpush_delete_button"><?php echo esc_html__('Permanently Delete My Subscription', 'smio-push-notification')?></button>
  <?php endif;?>
</div>

</form>

<script type="text/javascript">
window.addEventListener('DOMContentLoaded', (event) => {
  jQuery('#smpush_channels').smioselectize({
    plugins: ['remove_button'],
  });
  
  <?php if(self::$apisetting['subspage_cats_status'] == 1 && self::$apisetting['subspage_show_catimages'] == 0):?>
  jQuery('#smpush_categories').smioselectize({
    plugins: ['remove_button'],
  });
  <?php endif;?>
  
  jQuery('#smpush_notification_header button').has('input[name="web"]').on("click", function() {
    var pushSupported = smpush_test_browser();
    if(! pushSupported){
      alert("Sorry your browser does not support web push notification");
      jQuery(this).find('input[name="web"]').removeAttr("checked");
      return;
    }
    jQuery(".smpush_install_instructions").hide();
    jQuery("#smpush_web_instructions").show();
    //jQuery(this).find('input[name="web"]').trigger("click");
  });
  jQuery('#smpush_notification_header button').has('input[name="mobile"]').on("click", function() {
    jQuery(".smpush_install_instructions").hide();
    jQuery("#smpush_mobile_instructions").show();
    //jQuery(this).find('input[name="mobile"]').trigger("click");
  });
  jQuery('#smpush_notification_header button').has('input[name="msn"]').on("click", function() {
    jQuery(".smpush_install_instructions").hide();
    jQuery("#smpush_msn_instructions").show();
    //jQuery(this).find('input[name="msn"]').trigger("click");
  });
  jQuery('#smpush_notification_header button').has('input[name="email"]').on("click", function() {
    jQuery(".smpush_install_instructions").hide();
    //jQuery(this).find('input[name="email"]').trigger("click");
  });
  jQuery("#smpush_web_instructions").show();
  
  jQuery('.smpushSubsCat').on("click", function() {
    var catid = jQuery(this).attr("data-id");
    if(jQuery(this).hasClass("smpushBoxSelected")){
      jQuery(this).removeClass("smpushBoxSelected");
      jQuery('#smpush_categories option[value="'+catid+'"]').removeAttr('selected');
    }
    else{
      jQuery(this).addClass("smpushBoxSelected");
      jQuery('#smpush_categories option[value="'+catid+'"]').attr('selected', 'selected');
    }
  });

  jQuery('#smpush_subscription_form').submit(function(e) {
    e.preventDefault();
    var oldtext = jQuery("#smpush_save_button").html();
    jQuery("#smpush_save_button").attr("disabled", "disabled");
    jQuery("#smpush_save_button").html("<?php echo esc_html__('Saving...', 'smio-push-notification')?>");
    jQuery.post("<?php echo get_bloginfo('wpurl')?>/?smpushcontrol=save_subscription&noheader=1", jQuery("#smpush_subscription_form").serialize(), function( data ) {
      jQuery("#smpush_save_button").removeAttr("disabled");
      jQuery("#smpush_save_button").html("<?php echo esc_html__('Saved Successfully', 'smio-push-notification')?>");
      setTimeout(function(){ jQuery("#smpush_save_button").html(oldtext); }, 3000);
    }).fail(function() {
      jQuery('#smpush_subscription_form').submit();
    });

    var catid = jQuery(this).attr("data-id");
    if(jQuery(this).hasClass("smpushBoxSelected")){
      jQuery(this).removeClass("smpushBoxSelected");
      jQuery('#smpush_categories option[value="'+catid+'"]').removeAttr('selected');
    }
    else{
      jQuery(this).addClass("smpushBoxSelected");
      jQuery('#smpush_categories option[value="'+catid+'"]').attr('selected', 'selected');
    }
  });
  
  jQuery('#smpush_delete_button').on("click", function(e) {
    if(confirm("<?php echo esc_html__('Are you sure you want to terminate your subscription permanently ?', 'smio-push-notification')?>")){
      var oldtext = jQuery("#smpush_delete_button").html();
      jQuery("#smpush_delete_button").attr("disabled", "disabled");
      jQuery("#smpush_delete_button").html("<?php echo esc_html__('Processing...', 'smio-push-notification')?>");
      jQuery.post("<?php echo get_bloginfo('wpurl')?>/?smpushcontrol=deletetoken&noheader=1", {"source":"delete_button"}, function( data ) {
        jQuery("#smpush_delete_button").removeAttr("disabled");
        jQuery("#smpush_delete_button").html(oldtext);
        location.reload();
      }).fail(function() {
        jQuery("#smpush_delete_button").html("<?php echo esc_html__('Error!', 'smio-push-notification')?>");
      });
    }
  });
  
  jQuery('#smpush_keywords').smioselectize({
    plugins: ['remove_button'],
    persist: false,
    delimiter: ',',
    create: true,
    render: {
        item: function(data, escape) {
            return '<div>' + escape(data.text) + '</div>';
        }
    },
  });

});
</script>
