<?php

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (!class_exists('SO_Admin_Dashboard_Widget')) {

	Class SO_Admin_Dashboard_Widget {

		function __construct() {
			add_action( 'wp_dashboard_setup', array( $this, 'init_dashboard' ), 10 );
			add_action( 'admin_enqueue_scripts', array( $this, 'sa_css_on_dashboard_widget' ) );
		}

		/**
		* Init dashboard widgets
		*/
		function init_dashboard() {
			wp_add_dashboard_widget('smart_offers_dashboard_widget', __('Smart Offers Statistics', SA_Smart_Offers::$text_domain), array($this, 'smart_offers_stats'));
		}

		function sa_css_on_dashboard_widget() {
			$screen = get_current_screen();
			if ( $screen->id == 'dashboard' ) {
				wp_register_style('so_admin_styles', plugins_url(SMART_OFFERS) . '/assets/css/admin.css');
				wp_enqueue_style('so_admin_styles');
			}
		}

		/**
		* Show SO statistics
		*/
		function smart_offers_stats() {
			global $wpdb;

			$wpdb->query("SET SESSION group_concat_max_len=999999");

			$offers_count_args = array(
										'post_type' => 'smart_offers',
										'fields' => 'ids',
										'nopaging' => true,
										'post_status' => array( 'publish', 'private' ),
										'meta_query' => array(
															array(
																	'key' => 'so_accept_skip_counter'
																)
														)
									);

			$query_results_for_offers_count = new WP_Query( $offers_count_args );
			
			$accept_count = 0;
			$skip_count = 0;
			$total_count = 0;

			if ( $query_results_for_offers_count->post_count > 0 ) {

				foreach ( $query_results_for_offers_count->posts as $post_id ) {
					$result = get_post_meta( $post_id, 'so_accept_skip_counter', true );
					foreach ($result as $key => $value) {
						if ($key == "accepted") {
							$accept_count += $value;
						}
						if ($key == "skipped") {
							$skip_count += $value;
						}
						if ($key == "offer_shown") {
							$total_count += $value;
						}
					}
				}

			}

			$offers_sale_args = array(
										'post_type' => 'shop_order',
										'fields' => 'ids',
										'nopaging' => true,
										'post_status' => array( 'wc-completed', 'wc-processing', 'wc-on-hold' ),
										'meta_query' => array(
															array(
																	'key' => 'smart_offers_meta_data'
																)
														)                                            
									);
			$offers_sale_order_ids = new WP_Query( $offers_sale_args );

			$offers_paid_through = 0;
			$total_sale = 0;

			if ( $offers_sale_order_ids->post_count > 0 ) {
				foreach ( $offers_sale_order_ids->posts as $post_id ) {
					$result = get_post_meta( $post_id, 'smart_offers_meta_data', true );
					$offers_paid_through = $offers_paid_through + count( $result );
					foreach ( $result as $key => $value ) {
						$total_sale += $value ['offered_price'];
					}
				}
			}

			$conversion_rate = ($total_count != 0) ? ($offers_paid_through / $total_count) * 100 : 0;

			$stats = '<ul class="woocommerce_stats">';
			$stats .= '<li style="width: 55%; overflow: hidden"><strong>' . wc_price($total_sale) . '</strong><p class="so-revenue"> ' . __('Revenue from Offers', SA_Smart_Offers::$text_domain) . '</p></li>';
			$stats .= '<li style="width: 45%; overflow: hidden"><strong>' . wc_format_decimal($conversion_rate, get_option( 'woocommerce_price_num_decimals' ), $trim_zeros = false) . '%' . '</strong><p class="so-conversion-rate"> ' . __('Conversion Rate', SA_Smart_Offers::$text_domain) . '</p></li>';
			$stats .= '</ul>';
			$stats .= '<ul class="woocommerce_stats">';
			$stats .= '<li id="so-seen" style="width: 25%;"><strong>' . $total_count . '</strong><span class="so dashicons dashicons-visibility"><p class="offers-seen"> ' . __('Seen', SA_Smart_Offers::$text_domain) . '</p></span></li>';
			$stats .= '<li id="so-skipped" style="width: 25%"><strong>' . $skip_count . '</strong><span class="so dashicons dashicons-thumbs-down"><p class="offers-skipped"> ' . __('Skipped', SA_Smart_Offers::$text_domain) . '</p></span></li>';
			$stats .= '<li id="so-accepted"  style="width: 25%"><strong>' . $accept_count . '</strong><span class="so dashicons dashicons-thumbs-up"><p class="offers-accepted"> ' . __('Accepted', SA_Smart_Offers::$text_domain) . '</p></span></li>';
			$stats .= '<li id="so-paid" style="width: 25%"><strong>' . $offers_paid_through . '</strong><span class="so dashicons dashicons-awards"><p class="offers-paid"> ' . __('Paid Through', SA_Smart_Offers::$text_domain) . '</p></span></li>';
			$stats .= '</ul>';

			echo $stats;
		}

	}
	return new SO_Admin_Dashboard_Widget();
}


