<?php
if ( ! class_exists( 'WC_Abstract_Privacy' ) ) {
	return;
}

class SO_Privacy extends WC_Abstract_Privacy {
	/**
	 * Constructor
	 */
	public function __construct() {
		// To show this plugin's privacy message in Privacy Policy Guide page on your admin dashboard
		parent::__construct( __( 'Smart Offers', SA_Smart_Offers::$text_domain ) );
	}

	/**
	 * Gets the message of the privacy to display.
	 */
	public function get_privacy_message() {
		$content = '<strong>' . __( 'What we store?', SA_Smart_Offers::$text_domain ) . '</strong>
						<p>' . __( 'If an offer is shown and accepted or skipped, we save the offer ids.', SA_Smart_Offers::$text_domain ) . '</p>
						<strong>' . __( 'Where we store?', SA_Smart_Offers::$text_domain ) . '</strong>
						<ul>
							<li>' . __( 'If you are logged in: We store it in your WooCommerce session.', SA_Smart_Offers::$text_domain ) . '</li>
							<li>' . __( 'If you are a visitor: We add a cookie in your browser.', SA_Smart_Offers::$text_domain ) . '</li>
						</ul>
						<strong>' . __( 'Delete Personal Data', SA_Smart_Offers::$text_domain ) . '</strong>
						<ul>
							<li>' . __( 'For deleting personal data for logged in, logout from your WooCommerce account and close your browser.', SA_Smart_Offers::$text_domain ) . '</li>
							<li>' . __( 'For deleting personal data of a visitor, a visitor can simply delete cookies from their browser.', SA_Smart_Offers::$text_domain ) . '</li>
						</ul>';

		return $content;
	}

}

new SO_Privacy();