<?php

/**
 * Class CT_Ultimate_GDPR_Service_Google_Analytics
 */
class CT_Ultimate_GDPR_Service_Google_Analytics extends CT_Ultimate_GDPR_Service_Abstract {

	/**
	 * @return void
	 */
	public function init() {
	}

	/**
	 * @return $this
	 */

	/**
	 * @return mixed
	 */
	public function get_name() {
		return apply_filters( "ct_ultimate_gdpr_service_{$this->get_id()}_name", 'Google Analytics' );
	}

	/**
	 * @return bool
	 */
	public function is_active() {
		return true;
	}

	/**
	 * @return bool
	 */
	public function is_forgettable() {
		return false;
	}

	/**
	 * @throws Exception
	 * @return void
	 */
	public function forget() {
	}


	/**
	 * @return mixed
	 */
	public function add_option_fields() {

		/* Cookie section */

		add_settings_field(
			"cookie_services_{$this->get_id()}_tracking_id_ga4", // ID
			esc_html__( "Your GA4 ID", 'ct-ultimate-gdpr' ), // Title
			array( $this, "render_field_cookie_services_{$this->get_id()}_tracking_id_ga4" ), // Callback
			$this->front_controller->find_controller('cookie')->get_id(), // Page
			'ct-ultimate-gdpr-cookie_tab-1_section-5' // Section
		);



	}

	/**
	 * @param $cookies
	 * @param bool $force
	 *
	 * @return mixed
	 */
	public function cookies_to_block_filter( $cookies, $force = false ) {

	}

	/**
	 *
	 */
	public function render_field_cookie_services_google_analytics_tracking_id_ga4() {

		$admin = $this->get_admin_controller();

		$field_name = $admin->get_field_name( __FUNCTION__ );
		printf(
			"<input class='ct-ultimate-gdpr-field' type='text' id='%s' name='%s' value='%s' />",
			$admin->get_field_name( __FUNCTION__ ),
			$admin->get_field_name_prefixed( $field_name ),
			$admin->get_option_value_escaped( $field_name )
		);

        echo '<p class="description">';
        echo "Provide your Google Analytics 4 (GA4) Tracking ID (e.g., G-XXXXXXX) to enable integration with Google Analytics. This ID allows the plugin to insert the necessary GA4 tracking code into your website.";
        echo '</p>';


    }

	/**
	 * @return mixed
	 */
	public function front_action() {
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_static' ), 1 );
        add_action('wp_head', array( $this, 'head_snippet'), 1);
	}

    private function is_consent_mode_active(){
        $consent_mode = $this->get_admin_controller()->get_option_value( 'cookie_consent_mode', '', $this->front_controller->find_controller('cookie')->get_id() );
        if($consent_mode){
            return true;
        }
        return false;
    }

    public function head_snippet(){

        $id = $this->get_admin_controller()->get_option_value( 'cookie_services_google_analytics_tracking_id_ga4', '', $this->front_controller->find_controller('cookie')->get_id() );

        // no ga id was set in option
        if ( ! $id ) {
            return;
        }

        $consentCode = '';

        if($this->is_consent_mode_active()){
            $consentCode = <<<EOT
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag() {
      dataLayer.push(arguments);
    }
    if(localStorage.getItem('consentMode') === null) {
      gtag("consent", "default", {
        ad_personalization: "denied",
        ad_storage: "denied",
        ad_user_data: "denied",
        analytics_storage: "denied",
        functionality_storage: "denied",
        personalization_storage: "denied",
        security_storage: "granted"        
      });
    } else {
      gtag('consent', 'default', JSON.parse(localStorage.getItem('consentMode')));
    }  
  </script>
EOT;
        }

    $html = <<<EOT
    {$consentCode}
  <!-- Google tag (gtag.js) -->
  <script async src="https://www.googletagmanager.com/gtag/js?id={$id}"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', '{$id}');
  </script>
EOT;

    $html = apply_filters('ct_ultimate_gdpr_service_ga4_head_snippet', $html, $id);

    echo $html;

    }

    public function enqueue_static() {
        if($this->is_consent_mode_active()) {
            wp_enqueue_script(
                'ct-ultimate-gdpr-cookie-consent-mode',
                ct_ultimate_gdpr_url( 'assets/js/consent-mode.js' ),
                array( 'jquery' ),
                ct_ultimate_gdpr_get_plugin_version(),
                false
            );
        }
    }

	/**
	 * @return string
	 */
	protected function get_default_description() {
		return '';
	}

	/**
	 * Collect data of a specific user
	 *
	 * @return $this
	 */
	public function collect() {
		return $this;
	}

	/**
	 * @param array $scripts
	 *
	 * @param bool $force
	 *
	 * @return array
	 */
	public function script_blacklist_filter( $scripts, $force = false ) {

	}
}
