# WeePie Framework

> WeePie Plugins is a webRtistik product, (c) 2013 - 2023<br/>
> If you have any questions and/or suggestions, feel free to contact us:<br/> > [http://www.weepie-plugins.com/contact/](http://www.weepie-plugins.com/contact/)<br/>
> Vincent Weber, Mari&euml;tte Timmermans<br/>

## [V2.0.17]

improve: CSS styling data tables (borders and add scrollable tbody)

## [V2.0.16]

fixed: styles getting ext stripped wrong<br/>
fixed: inline css style comment<br/>
fixed: add CSS classes for different data table widths<br/>
fixed: ip addresses are still un validating

## [V2.0.15]

fixed: php 8 warnings<br/>
fixed: skip wpiefy check for ip address and ajax requests<br/>
refactor: script and style handling by adding `wp_add_inline_script()` and `wp_add_inline_style()`

## [V2.0.14]

new: provide rest api logic for plugins

## [V2.0.13]

refactor: check doing without wpie action logic<br/>
added: function to common js to check required properties

## [V2.0.12]

fixed: PHP 8 Deprecated warnings<br/>
improvement: upgrade notice message is now dissmisable

## [V2.0.11]

fixed: framework runs frontend code on favicon request from `wp-admin`<br/>
fixed: add Kinsta to staging domains<br/>
fixed: code style refactor in multisite helper<br/>
fixed: license check not case insensitive

## [V2.0.10]

fixed: resetting settings in multilang mode fails

## [V 2.0.9]

fixed: update settings process with WPML active<br/>
fixed: jQuery migrate warnings<br/>
fixed: settings and modules reset is not handled after upgrading<br/>
fixed: WpieGlobals `isActivating` still implemented with deprecated key<br/>
fixed: WP options entry `optionActivating` not deleted fast enough<br/>
fixed: values pasted double in import textarea<br/>
fixed: persisting logic after merging tmp settings<br/>
fixed: multilang persisting settings logic in setter not correct

## [V 2.0.8]

fixed: setttings notification timeout (still) too short to read longer messages<br/>
updated: copyright to 2021

## [V 2.0.7]

fixed: javascript response error messages not always showing<br/>
fixed: add missing css id to export inport list item<br/>
added: minor improvement to javascript general error msg

## [V 2.0.6]

fixed: setttings notification timeout too short to read longer messages

## [V 2.0.5]

new: import / export of settings<br/>
fixed: `WpieMultilangHelper::isLanguagedOption()` doesn't return boolean<br/>
fixed: PHP notice: only variables should be passed by reference for `array_shift()`<br/>
added: upgrade notice sandbox<br/>
added: `$args` argument to `WpieTaxonomy::create()`<br/>
added: hyperlink to the register page on the (un)validate page<br/>
added: new helper method to combines `isLocalhost()` and `isLan()`<br/>
improvement: return instance in public `WpieTemplate` methods

## [V 2.0.4]

fixed: allowed staging environments can't use the plugin

## [V 2.0.3]

new: skip WP Engine staging domain in validating process<br/>
new: skip Savvii sub domain in validating process<br/>
fixed: `ABSPATH` leaded to wrong paths in `WpieFileCollection` for some server setups<br/>
fixed: `isActivating` entry in `WpieGlobals` was overwritten<br/>
fixed: PHP warning continue targeting switch is equivalent to break<br/>
fixed: PHP notice undefined index during ajax request without action<br/>
fixed: PHP notice undefined index when using a `{TAG}` in the value attribute with `WpieFormHelper`<br/>
fixed: admin css was not listening for `isScriptDebug`<br/>
fixed: frontend css was not listening for `isScriptDebug`<br/>
fixed: after updating settings, the success notice was not visible<br/>
fixed: after resetting settings, the succes notice was not rendered correctly<br/>
added: `WpieMiscHelper::isLan()` method<br/>
added: `WpieMultisiteHelper::isActivatingPluginForNework()` method<br/>
added: new WordPress success notice css class instead of updated<br/>
added: wpie data table CSS to settings page stylesheet<br/>
improvement: send plugin meta data while validating/unvalidating<br/>
improvement: minor code changes in activation handler<br/>
improvement: localhost usage when validating<br/>
improvement: some code is not executed on login screen anymore<br/>
improvement: do not run silent activation when plugin is just activated<br/>
improvement: implemented `$once` argument in `WpieNotices::add()` to display notices only once<br/>
updated: copyright to 2020<br/>

## [V 2.0.2]

fixed: empty error page with back link when user clicks activate on plugins page

## [V 2.0.1]

fixed: reset success notice was triggered during upgrading<br/>
fixed: there were still native RuntimeException's which should be of class WpieRuntimeException<br/>
fixed: error class WpieFw\Wpie\WpieWpmlHelper not found was triggered during activation in some cases<br/>
fixed: and improved WeePie Framework auto-updating / upgrading process

## [V 2.0]

new: lots of code is rewritten<br/>
new: use Composer for autoloading<br/>
new: support for the Envato Market auto-updating plugin<br/>
new: custom Exceptions<br/>
new: classes use PHP namespaces and imports<br/>
new: translatable weepie strings (pot-file)<br/>
new: reset settings button near save changes<br/>
fixed: multisite plugin globals got overwriten<br/>
added: common used JavaScript functions in separate file<br/>
improvement: better error/exception handling, notices and logging<br/>
improvement: implemented some design patterns<br/>
improvement: use short PHP array syntax<br/>
improvement: save relative URL's to the wp_options instead of full<br/>
improvement: save plugin setting fields as serialized array <br/>
improvement: rework on ajax processing server and client side<br/>
improvement: upgrader logic to allow beta or rc versions <br/>
improvement: addes `notice()` method to modules<br/>
improvement: security enhancements <br/>

## [V 1.4.14]

added: `WpieMiscHelper::doShortcodeNot()` method<br/>
added: `$.fn.cbCheck()` function to WPIESETT to check/uncheck checkboxes<br/>
added: minor code improvement in `WpieFormHelper::_printCheckAllJs()`<br/>
improvement: let `WpieMultilangHelper::isLanguagedOption()` search for more then only the 1st idx<br/>
improvement: removed unused condition statement in `WpieCore::activatePlugin()`<br/>

## [V 1.4.13]

fixed: mixed content due to HTTP instead of HTTPS URL's<br/>

## [V 1.4.12]

fixed: wpie red colors in framework css<br/>
fixed: JavaScripts are not getting framework/new plugin version suffixed<br/>
fixed: global JS frontend param "domain" is calculated wrong<br/>
fixed: colorpicker is hiding hexadecimal input field<br/>
added: WpieCronHelper src class<br/>
added: `WpieMultisiteHelper::isDomainMapping()` method<br/>
implemented: `WpieCronHelper::doingCron()` in `init()` method for early return<br/>
optimized: WpiePluginGlobals constructor<br/>

## [V 1.4.11]

fixed: JavaScript gives Uncaught TypeError while validate/unvalidate<br/>

## [V 1.4.10]

fixed: unvalidating automatically<br/>
fixed: PHP Notice: Undefined index in `validator()` method<br/>
added: check for WPML different domains in `WpieFy::urlMatch()`<br/>
added: method `WpieWpmlHelper::getSetting()` <br/>
added: method `WpieWpmlHelper::isDomainPerLanguageSetup()`<br/>
added: method `WpieWpmlHelper::isDomainInLanguageDomains()` <br/>
added: missing params check in `WpieFormHelper::formField()` method<br/>
added: method `WpieMiscHelper::getUriWithoutSchemaSubdomain()`<br/>
added: method `WpieMiscHelper::getHomeUri()`<br/>
added: method `WpieMiscHelper::isValidIpAddress()`<br/>
added: method `WpieMiscHelper::getClientIp()`<br/>
added: `WpieMiscHelper::getUriWithoutSchemaSubdomain()` method<br/>
added: `WpieMiscHelper::getHomeUri()` method (wrapper for `home_url()` with NULL args)<br/>
added: some rework to the WpieNotices logic<br/>
improved: WpieFormHelper by generating nice CSS id attr<br/>
improved: `getCleanUri()` method by also stripping subdomain if passed<br/>

## [V 1.4.9]

fixed: added secure (ssl) check for setting cookies<br/>
fixed: scope use of params in JS<br/>
fixed: typo in wpiefy templates<br/>
fixed: sending multiple wpiefy requests (disable button)<br/>
fixed: missing use of `$ext` in enqueue of wpie-notices scripts<br/>
fixed: removed call to method `deleteOption()` because is already in `deleteData()`<br/>
added: plugin version to plugin globals<br/>
added: ssl (boolean) to script vars frontend<br/>
improved: make the error msg container more striking<br/>
improved: JS confirm text noticing the unvalidating needs for new domains<br/>

## [V 1.4.8]

fixed: serveral validating bugs<br/>

## [V 1.4.7]

fixed: missing static prefix for `WpieMultisiteHelper::isNetworkHome()`<br/>
fixed: missing static prefix for `WpieMiscHelper::getStringParts()`<br/>
fixed: missing static prefix for `WpieCookieHelper::setGlobal()`<br/>
fixed: setting post_status to inherit for attachment post types<br/>
fixed: multiple submits for validing process by js confirm dialog<br/>
fixed: plugin globals where not resetted after domain changes<br/>
added: method `WpieMiscHelper::getQueriedTerm()`<br/>
added: method `WpieMiscHelper::escapeRegexChars()`<br/>
added: form field wpcustomptselect for WpieWpFormHelper class<br/>
added: `extend.isChecked()` to WPIESETT<br/>
added: `extend.isCheckbox()` to WPIESETT<br/>
added: new hooks to settings table template to escape a setting group or field<br/>
added: `$isModeDev` param to css hooks<br/>
removed: combining assets logic as this will be replaced by common used technology soon <br/>
improvement: renamed method `WpieWpFormHelper::getPostTypesDropDown()` to `getPostTypeTypesDropDown()`<br/>
improvement: removed multisite logic from WpieCookieHelper methods<br/>
improvement: added better return value for method `WpieTaxonomy::retrieve()`<br/>
improvement: added minified css files<br/>
improvement: some minor improvements to WpiePluginSettingsProcessor<br/>

## [V 1.4.6]

fixed: mouse right click triggered save event in WeePie Settings lists<br/>
fixed: minor whitespace removals<br/>
fixed: missing PHP doc in WpieFormHelper<br/>
fixed: code convention underscore to camelcase in `getCustomPostTypeList()` method of class WpieWpFormHelper<br/>
added: method `getRunningMode()` to class WpieMiscHelper<br/>
added: method `isRunningModeDev()` to class WpieMiscHelper<br/>
added: heading option for post type lists<br/>
added: method `getStringParts()` to class WpieMiscHelper<br/>
added: hook `wpie_wp_query_args_{$context}` to method `getCustomPostTypeList()` of class WpieWpFormHelper<br/>
added: hook `wpie_list_headings_{$context}` to method `getCustomPostTypeList()` of class WpieWpFormHelper<br/>
added: hook `{$nameSpace}_validate_ajax_data_{$context}` to method `processAjaxRequest()` of class WpieHooks<br/>
added: folder inc<br/>
added: folder inc/core<br/>
added: class WpieFwActivationHandler<br/>
added: class WpieFwDeactivationHandler<br/>
improvement: load of plugin admin settings css automatically if exist<br/>
improvement: load minified JavaScript for frontend and admin only if in prod mode<br/>
improvement: added param `$wp_scripts` and `$isModeDev` to `{$nameSpace}_scripts_admin` hook<br/>
improvement: added param `$isModeDev` to `{$nameSpace}_settings_scripts_before` hook<br/>
improvement: added param `$isModeDev` to `{$nameSpace}_settings_scripts_after` hook<br/>
improvement: added param `$isModeDev` to `{$nameSpace}_scripts_frontend` hook<br/>
improvement: added param `$isModeDev` to `{$nameSpace}_styles_frontend` hook<br/>
improvement: moved settings reset code to method `reset()` in WpiePluginSettingsProcessor class<br/>
improvement: moved settings upgrade code to method `upgrade()` in WpiePluginSettingsProcessor class<br/>
improvement: moved activation code to new class WpieFwActivationHandler<br/>
improvement: moved deactivation code to new class WpieFwDeactivationHandler<br/>
improvement: changed post type list structure to tables and table rows instead of unordered lists <br/>
improvement: removed dead params in `getCustomPostTypeList()` method of class WpieWpFormHelper<br/>
removed: param reset from the `initSettings()` method of WpieCore class<br/>

## [V 1.4.5]

fixed exception problem during activation process on multisite install<br/>

## [V 1.4.4]

fixed errors during activating of plugins<br/>
fixed instance settingsprocessor does not exist by adding false as default value to `WpieSrc::get()`<br/>
fixed some PHP doc indentions for better readability<br/>
added doSettings property to WpieHooksAdmin class<br/>
changed scope of `engine()` method of class WpieCore (public to protected)<br/>
changed null to false in check for settingsProcessor in `init()` method of class WpiePluginModuleProcessor<br/>
removed property settingsPage from `init()` method of class WpiePluginModuleProcessor (settingsPage is a propery of WpiePluginSettingsProcessor) <br/>

## [V 1.4.3]

fixed exception problem during activation process<br/>
fixed fatal error caused by WpieCore init process<br/>

## [V 1.4.2]

fixed bug in WpiePluginSettingsProcessor constructor with debug exception message still there<br/>

## [V 1.4.1]

fixed use strict mode was being erased by yuicompressor after minification<br/>

## [V 1.4.0]

fixed JS scope bug in wpie-settings.js after enabling strict mode<br/>
fixed bug with wrong param in `printScriptsAdminHeaderVars()` method (copy paste bug)<br/>
fixed code conventions (spaces, curly braces with enter, etc)<br/>
fixed Non-static method bug with `WpieAjaxHelper::maybeQuitForAjax()`<br/>
fixed typo for `WpieMultilangProcessor::afterInitSettings()`<br/>
fixed code conventions like curly braces right after if statement or foreach<br/>
fixed bug with nonce should be in init hook<br/>
fixed method return value in write context error in `WpiePluginSettingsPage::hasTabs()`<br/>
fixed bug in `WpieCore::initHooks()`, passing wrong constructor params to WpieHooksFrontend constructor<br/>
added src classes: WpieSrc, WpieCore, WpieAssets, WpieHooks, WpieHooksAdmin, WpieHooksFrontend, WpieShortcodes, WpieUpgrader<br/>
added WpiePluginGlobals instance to modules<br/>
added hook `{namespace}_module_after_instantiate` in `WpiePluginModuleProcessor::init()`<br/>
added `__FILE__` as property to WpieCore class<br/>
added method `getGlobals()` to WpieCore class<br/>
added method `deleteOptionDefault()` to WpiePluginSettingsProcessor class<br/>
added method `deleteOptionFields()` to WpiePluginSettingsProcessor class<br/>
added method `WpieBaseSettings::set()` as wrapper for offsetSet<br/>
added method `WpieBaseSettings::get()` as wrapper for offsetGet<br/>
added new getters and setters to WpieBaseSettingProcessor<br/>
added property hasSettingsPage to WpieBaseSettingProcessor <br/>
added property `WpiePluginGlobals::wpieFwFile` to dynamicaly create the weepie framework folder<br/>
added more try catch blocks<br/>
improvement: code readability by moving code to sepatate classes/folders<br/>
improvement: moved settings-lists JS to separate file<br/>
improvement: moved WpieBaseSettingProcessor class to separate file<br/>
improvement: moved iWpieMultilangPlugin class to separate file<br/>
improvement: moved WpieBaseMultilangProcessor class to separate file <br/>
improvement: moved WpieMultilangWpml class to separate file<br/>
improvement: moved WpiePluginModule class to separate file<br/>
improvement: read namespace from WpiePluginGlobals instance instead of passing as param to constructors<br/>
improvement: making weepie framework folder root dynamic in WpiePluginGlobals<br/>
improvement: more use of WpieMultisiteHelper for `get_option()` and `update_option()`<br/>
improvement: renamed ns to namespace in some classes<br/>
improvement: renamed some methods, class properties<br/>
improvement: changed some scopes in classes<br/>
removed some WpieCore class properties (mainly instances that are now handles by WpieSrc)<br/>
removed underscores from private properties and methods<br/>

## [V 1.3.3]

fixed bug in wpiefy for backword compat<br/>
fixed some missing PHP doc strings<br/>
fixed custom fields handling in WpieTaxonomy constructor<br/>
fixed color fields not checked on being set in `WpiePluginSettingsProcessor::validator()`<br/>
added an id attribute to the parent settings table for form fields/groups<br/>
added method `WpieXmlSettingsHelper::hasAttributeName()`<br/>
added method `WpieXmlSettingsHelper::getFieldAttributeName()`<br/>
added method `WpieXmlSettingsHelper::getFieldCssIdString()`<br/>
renamed lib folder to src folder for coding conventions<br/>

## [V 1.3.2]

fixed css bug with settings page title margin<br/>
added support for `get_site()`, replacing `get_blog_details()` from wp 4.8, see https://make.wordpress.org/core/2016/11/04/multisite-focused-changes-in-4-7/<br/>

## [V 1.3.1]

added CHANGELOG file<br/>
added `WpieXmlSettingsHelper::isClickSelect()` method<br/>
added automatic `fetch()` to `WpiePostType::retrieveCustom()` method<br/>
added version 1.3 to previous commit<br/>
implemented `WpieXmlSettingsHelper::isClickSelect()` in `WpiePluginSettingsProcessor::_update()`<br/>
fixed loading width scaling diff with field wpcpostlist (\_click_select) <br/>
fixed bug for wpcpostlist field (\_click_select) not being saved on plugin upgrade in `WpiePluginSettings::_fieldWalkerDefaults()`<br/>
