<?php
namespace WpieFw\Exceptions;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieExceptionInterface {
    /**
     * @return string
     * @link https://php.net/manual/en/exception.getmessage.php
     */
    public function getMessage();

    /**
     * @return \Throwable|null
     * @link https://php.net/manual/en/exception.getprevious.php
     */
    public function getPrevious();

    /**
     * @return int
     * @link https://php.net/manual/en/exception.getcode.php
     */
    public function getCode();

    /**
     * @return string
     * @link https://php.net/manual/en/exception.getfile.php
     */
    public function getFile();

    /**
     * @return int
     * @link https://php.net/manual/en/exception.getline.php
     */
    public function getLine();

    /**
     * @return array
     * @link https://php.net/manual/en/exception.gettrace.php
     */
    public function getTrace();

    /**
     * @return string
     * @link https://php.net/manual/en/exception.gettraceasstring.php
     */
    public function getTraceAsString();
}