<?php

namespace WpieFw\Files;

use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 */
final class WpieFilesystemIteratorFactory
{
	/**
	 * Create a FilesystemIterator instance
	 *
	 * @param string $path
	 * @return \FilesystemIterator
	 */
	public static function create( $path = '' )
	{
		$path = trim( $path );

		if( '' === $path ) {
			throw new WpieInvalidArgumentException( 'Cannot add create FilesystemIterator instance. $path is empty.' );
		} elseif( !is_dir( $path ) ) {
			throw new WpieInvalidArgumentException( 'Cannot add create FilesystemIterator instance. $path is not valid.' );
		}

		return new \FilesystemIterator( $path, \FilesystemIterator::SKIP_DOTS );
	}
}