<?php

namespace WpieFw\Framework\Patterns\Definition;

use WpieFw\Framework\Patterns\Iterator\WpieCollectionInterface;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieDefinitionInterface extends WpieCollectionInterface
{
	/**
	 * Set the map
	 *
	 * Mapping the definition shortcut names with real names
	 *
	 * @param array $map
	 */
	public function setShortCutMap( array $map );

	/**
	 * Register a placeholder string
	 *
	 * Placeholders should be in the format: {FOO} or {BAR}
	 *
	 * @param string $placeHolder
	 */
	public function registerPlaceholder( $placeHolder = '' );

	/**
	 * Get the definition value for give key
	 *
	 * @param string $key
	 * @return string
	 */
	public function getValue( $key = '' );

	/**
	 * Get the defined name for a definition
	 *
	 * @param string $name
	 * @return string
	 */
	public function getIdx( $name = '' );
}