<?php

namespace WpieFw\Framework\Patterns\Iterator;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieCollectionInterface extends \ArrayAccess, \IteratorAggregate
{
	/**
	 * Set multiple items at once
	 *
	 * @param array $collection
	 *
	 * @return WpieCollection
	 */
	public function setMultiple( array $collection = [] );

	/**
	 * Shortcut to offsetSet
	 *
	 * @param mixed $offset
	 * @param mixed $value
	 *
	 * @return void
	 */
	public function set( $offset, $value );

	/**
	 * Shortcut to offsetGet
	 *
	 * @param mixed $offset
	 * @return mixed
	 */
	public function get( $offset );

	/**
	 * Get collection except given offset
	 *
	 * @param mixed $offset
	 *
	 * @return array
	 */
	public function getExcept( $offset );

	/**
	 * Determine if collection has items
	 *
	 * @return boolean
	 */
	public function hasCollection();
}