<?php

namespace WpieFw\Modules\Files;

use WpieFw\Files\WpieFileCollection;
use WpieFw\Files\WpieFile;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

final class WpieModulesFileCollection extends WpieFileCollection
{
	/**
	 * @var string
	 */
	public $prefix;

	/**
	 * Constructor
	 *
	 * @param array $collection
	 * @param string $prefix
	 * @param string $relativeSeparator
	 */
	public function __construct( array $collection, string $prefix = '', string $relativeSeparator = '' )
	{
		$this->prefix = trim( $prefix );

		parent::__construct( $collection, $relativeSeparator );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Files\WpieFileCollection::offsetSet()
	 */
	public function offsetSet( $offset, $value ): void
	{
		if( '' === trim( $offset ) ) {
			throw new WpieInvalidArgumentException( 'Cannot add module file to collection. Index is empty.' );
		}

		$this->collection[$offset] = new WpieFile( $value, $this->prefix );
	}
}