<?php

namespace WpieFw\Modules\Iterator;

use WpieFw\Framework\Patterns\Iterator\WpieCollection;
use WpieFw\Modules\Iterator\WpieModule;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

final class WpieModulesCollection extends WpieCollection
{
	public function __construct( array $collection = [] )
	{
		parent::__construct( $collection );
	}

	/**
	 * @param string $offset
	 * @param WpieModule $value
	 */
	public function offsetSet( $offset, $value ): void
	{
		if( '' === trim( $offset ) ) {
			throw new WpieInvalidArgumentException( 'Cannot add module to collection. Index is empty.' );
		}
		if( !$value instanceof WpieModule ) {
			throw new WpieInvalidArgumentException( 'Cannot add module to collection. Value is not a WpieModule instance.' );
		}

		$this->collection[$offset] = $value;
	}
}