<?php

namespace WpieFw\Modules\Resolver;

use WpieFw\Framework\Patterns\Definition\WpieDefinition;
use WpieFw\Framework\Patterns\Resolver\WpieResolverFactory;
use WpieFw\Modules\Resolver\WpieModuleValuesWpOptionsResolver;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 * The WpieModuleValuesResolverFactory helps resolving values for modules
 * and should therefor be injected in the WpieModulesValues constructor.
 *
 * Modules can be stored in the wp_options table but maybe also in a custom table.
 *
 * The factory decides (WpieModuleValuesResolverFactory::getResolver()) which resolver to return.
 */
final class WpieModuleValuesResolverFactory extends WpieResolverFactory
{
	/**
	 * Constructor
	 *
	 * @param string $type
	 */
	public function __construct( $type = '' )
	{
		parent::__construct( $type );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieResolverFactoryInterface::getResolver()
	 */
	public function getResolver( WpieDefinition $definitions )
	{
		switch( $this->type ) {
			case 'wp_options':
				return new WpieModuleValuesWpOptionsResolver( $definitions );
				break;
		}
	}
}