<?php

namespace WpieFw\Modules\Resolver;

use WpieFw\Modules\Definition\WpieModulesDefinition;
use WpieFw\Framework\Patterns\Resolver\WpieWpOptionsResolver;
use WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 */
final class WpieModuleValuesWpOptionsResolver extends WpieWpOptionsResolver implements WpieFilesResolverInterface
{
	/**
	 * Constructor
	 *
	 * @param WpieModulesDefinition $defenitions
	 */
	public function __construct( WpieModulesDefinition $definitions )
	{
		parent::__construct( $definitions );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::getFiles()
	 */
	public function getFiles()
	{
		$name = $this->getValueForShortcut( 'files' );

		return $this->getWpOption( $name, [] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::persistFiles()
	 */
	public function persistFiles( array $files )
	{
		$name = $this->getValueForShortcut( 'files' );

		$this->addWpOption( $name, $files );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface::deleteFiles()
	 */
	public function deleteFiles()
	{
		$name = $this->getValueForShortcut( 'files' );

		return $this->deleteWpOption( $name );
	}
}