<?php

namespace WpieFw\Modules;

use WpieFw\Files\WpieFile;
use WpieFw\Wpie\WpieGlobals;
use WpieFw\Settings\WpieSettingsProcessor;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieModulesBuilderInterface
{
	/**
	 * Create and get a module instance
	 *
	 * @param WpieFile $file
	 *
	 * @return \WpieFw\Modules\Iterator\WpieModule
	 */
	public function instance( WpieFile $file );

	/**
	 * Set the modules path
	 *
	 * @param string $path
	 *
	 * @return WpieModulesBuilder
	 */
	public function setPath( $path = '' );

	/**
	 * Set the modules vars
	 *
	 * @param array $vars
	 *
	 * @return WpieModulesBuilder
	 */
	public function setVars( array $vars );

	/**
	 * Set the modules unique index
	 *
	 * @param string $index
	 *
	 * @return WpieModulesBuilder
	 */
	public function setIndex( $index = '' );

	/**
	 * Set the WpieGlobals instance
	 *
	 * @param WpieGlobals $globals
	 *
	 * @return WpieModulesBuilder
	 */
	public function setGlobals( WpieGlobals $globals );

	/**
	 * Set the WpieSettingsProcessor instance
	 *
	 * @param WpieSettingsProcessor $processor
	 *
	 * @return WpieModulesBuilder
	 */
	public function setSettingsProcessor( WpieSettingsProcessor $processor );
}