<?php

namespace WpieFw\Modules;

use WpieFw\Modules\Iterator\WpieModule;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

final class WpieModulesFactory
{
	/**
	 * Create the module instance
	 *
	 * @param string $className
	 *
	 * @throws WpieInvalidArgumentException if module class has not been defined
	 *
	 * @return WpieModule|boolean
	 */
	public function create( $className = '' )
	{
		if( class_exists( $className ) ) {
			// Create the instance
			$module = new $className();

			// Make sure the module is an instance of WpieModule
			if( $module instanceof WpieModule ) {
				return $module;
			} else {
				return false;
			}
		} else {
			throw new WpieInvalidArgumentException( sprintf( 'Could not create instance for class %s. Class does not exist.', $className ) );
		}
	}
}