<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Multilang\Plugins;

use WpieFw\Wpie\WpieGlobals;
use WpieFw\Helpers\WpieWpmlHelper;
use WpieFw\Multilang\Plugins\WpieMultilangPluginInterface;
use WpieFw\Helpers\WpieMultilangHelper;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * WpieMultilangWpml interface
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 * @since 1.2
 */
final class WpieMultilangWpml implements WpieMultilangPluginInterface
{
	/**
	 * Flag if WPML API is loaded
	 *
	 * @since 1.2
	 *
	 * @var bool
	 */
	public $apiLoaded = false;

	/**
	 * The data for the current active language
	 *
	 * Data from WpieWpmlHelper::getActiveLangData()
	 *
	 * @since 1.2
	 *
	 * @var array
	 */
	public $activeLanguageData = [];

	/**
	 * Constructor
	 */
	public function __construct()
	{
		$this->activeLanguageData = $this->getActiveLanguageData();
		$this->_includeApi();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::doSettingsPageHooks()
	 */
	public function doSettingsPageHooks( WpieGlobals $globals )
	{
		add_action( 'wp_before_admin_bar_render', [ 'WpieFw\Helpers\WpieWpmlHelper', 'removeAllFromAdminBar' ] );
		add_action( $globals->nameSpace . '_add_admin_pages', [ 'WpieFw\Helpers\WpieWpmlHelper', 'redirectIfIsAll' ] );
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::isActive()
	 */
	public function isActive()
	{
		return WpieWpmlHelper::isActive();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::isReady()
	 */
	public function isReady()
	{
		return WpieWpmlHelper::isReady();
	}

	/**
	 *
	 */
	public function getActiveLanguageData()
	{
		return WpieWpmlHelper::getActiveLanguageData();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getDefaultCode()
	 */
	public function getDefaultCode()
	{
		return WpieWpmlHelper::getDefaultCode();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getDefaultLocale()
	 */
	public function getDefaultLocale()
	{
		$code = $this->getDefaultCode();
		$locale = WpieMultilangHelper::mapCodeToLocale( $code, $this->getLangs() );

		return $locale;
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getActiveCode()
	 */
	public function getActiveCode()
	{
		return WpieWpmlHelper::getActiveCode();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getActiveLocale()
	 */
	public function getActiveLocale()
	{
		return WpieWpmlHelper::getActiveLocale();
	}

	/**
	 *
	 */
	public function getActiveLangData() {
		return WpieWpmlHelper::getActiveLangData();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getAllCodes()
	 */
	public function getAllCodes()
	{
		return WpieWpmlHelper::getAllCodes();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getAllLocales()
	 */
	public function getAllLocales()
	{
		return WpieWpmlHelper::getAllLocales();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getLangs()
	 */
	public function getLangs()
	{
		return $this->getAllLocales();
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::getParams()
	 */
	public function getParams()
	{
		$rtrn = new \stdClass();
		$rtrn->isActive			= $this->isActive();
		$rtrn->isReady			= $this->isReady();
		$rtrn->defaultCode 		= $this->getDefaultCode();
		$rtrn->defaultLocale 	= $this->getDefaultLocale();
		$rtrn->activeCode		= $this->getActiveCode();
		$rtrn->activeLocale		= $this->getActiveLocale();
		$rtrn->allCodes			= $this->getAllCodes();
		$rtrn->allLocales		= $this->getAllLocales();

		return $rtrn;
	}

	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Multilang\Plugins\WpieMultilangPluginInterface::switchLanguage()
	 */
	public function switchLanguage( $code = '' )
	{
		// leave $code empty to switch to default
		return WpieWpmlHelper::switchLanguage( $code, true );
	}

	/**
	 * Inlude the WPML API code
	 *
	 * if succeeded, set flag self::apiLoaded to true
	 *
	 * @acces private
	 *
	 * @since 1.2
	 */
	private function _includeApi()
	{
		if( defined( 'ICL_PLUGIN_PATH' ) ) {
			@require_once ICL_PLUGIN_PATH . '/inc/wpml-api.php';

			if( defined( 'WPML_API_SUCCESS' ) ) {
				$this->apiLoaded = true;
			}
			if( !defined( 'WPML_LOAD_API_SUPPORT' ) ) {
				define( 'WPML_LOAD_API_SUPPORT', true );
			}
		}
	}
}