<?php
/**
 * Please see weepie-framework.php for more details.
 */

namespace WpieFw\Multilang;

use WpieFw\Multilang\Plugins\WpieMultilangWpml;
use WpieFw\Multilang\Plugins\WpieMultilangPluginInterface;
use WpieFw\Exceptions\WpieInvalidArgumentException;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 * The Factory will create a WpieMultilangPluginInterface instance
 */
class WpieMultilangFactory
{

	/**
	 * Singleton instance of WpieMultilangPluginInterface
	 *
	 * @var WpieMultilangPluginInterface
	 */
	public static $instance = null;

	/**
	 * Create instance of interface WpieMultilangPluginInterface
	 *
	 * @param string $type
	 * @throws WpieInvalidArgumentException if plugin $type is not supported
	 * @return WpieMultilangPluginInterface|null
	 */
	public function create( $type = '' )
	{
		$namespace = __NAMESPACE__  . '\\Plugins\\';

		switch( $type ) {
			case 'wpml':
				$className = 'WpieMultilangWpml';
				break;
			case 'polylang':
				// not implemented yet
				// @todo implement Polylang if possible
			default:
				throw new WpieInvalidArgumentException( sprintf( 'Factory could not create multilang instance for type: %s. Invalid type.', $type ) );
				break;
		}

		if( null === self::$instance ) {
			$className = $namespace.$className;
			self::$instance = new $className();
		}

		return self::$instance;
	}
}