<?php

namespace WpieFw\Multilang;

use WpieFw\Framework\Patterns\Resolver\WpieWpOptionsResolver;
use WpieFw\Multilang\Definition\WpieMultilangDefinition;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 * An instance of this class retrieves the stored (saved) values through the WpieMultilangValuesResolverFactory instance
 */
final class WpieMultilangValues
{
	/**
	 * @var WpieWpOptionsResolver
	 */
	private $resolver;

	/**
	 * @param WpieWpOptionsResolver $resolver
	 * @param WpieMultilangDefinition $definitions
	 *
	 * @uses WpieMultilangValuesResolverFactory::getResolver()
	 */
	public function __construct( WpieWpOptionsResolver $resolver, WpieMultilangDefinition $definitions )
	{
		$this->resolver = $resolver;
	}

	/**
	 * Get the value for a definition
	 *
	 * @param string $shortcut
	 * @param array $replacements
	 *
	 * @uses WpieWpOptionsResolver::getValueForShortcut()
	 *
	 * @return string
	 */
	public function getDefinitionValue( $shortcut = '', array $replacements = [] )
	{
		return $this->resolver->getValueForShortcut( $shortcut, $replacements );
	}

	/**
	 * Get stored languages
	 *
	 * @uses self::getDefinitionValue()
	 * @uses WpieWpOptionsResolver::getWpOption()
	 *
	 * @return array
	 */
	public function getLanguages()
	{
		$name = $this->getDefinitionValue( 'langs' );

		return $this->resolver->getWpOption( $name, [] );
	}

	/**
	 * Persist shortcut
	 *
	 * @param mixed $value
	 *
	 * @uses WpieWpOptionsResolver::addWpOption()
	 *
	 * @return \WpieFw\Multilang\WpieMultilangValues
	 */
	public function persist( $value )
	{
		$name = $this->getDefinitionValue( 'langs' );

		$this->resolver->addWpOption( $name, $value );

		return $this;
	}

	/**
	 * Delete shortcut to all delete methods
	 *
	 * @uses WpieWpOptionsResolver::deleteWpOption()
	 *
	 * @return \WpieFw\Multilang\WpieMultilangValues
	 */
	public function delete()
	{
		$name = $this->getDefinitionValue( 'langs' );

		$this->resolver->deleteWpOption( $name );

		return $this;
	}
}