<?php

namespace WpieFw\Settings\Definition;

use WpieFw\Framework\Patterns\Definition\WpieDefinition;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 * An instance of this class should be injected in the WpieSettingsValues constructor.
 *
 * This class defines how the WpieSettingValuesResolverFactory must look for the data.
 *
 */
final class WpieSettingsDefinition extends WpieDefinition
{
	const SETT_DEFAULT = 'sett_default';

	const SETT_SETTING = 'sett_setting';

	const SETT_SETTING_TMP = 'sett_setting_tmp';

	const SETT_ARRAY = 'sett_array';

	const SETT_FILES = 'sett_files';

	/**
	 * Constructor
	 *
	 * @param array $definitions
	 */
	public function __construct( array $definitions = [], array $placeholders = [] )
	{
		$map = [
			'default' => self::SETT_DEFAULT,
			'setting' => self::SETT_SETTING,
			'setting_tmp' => self::SETT_SETTING_TMP,
			'files' => self::SETT_FILES,
			'array' => self::SETT_ARRAY
		];

		parent::__construct( $map, $definitions, $placeholders );
	}
}