<?php

namespace WpieFw\Settings\Resolver;

use WpieFw\Framework\Patterns\Definition\WpieDefinition;
use WpieFw\Framework\Patterns\Resolver\WpieResolverFactory;
use WpieFw\Settings\Resolver\WpieSettingValuesWpOptionsResolver;
use WpieFw\Framework\Patterns\Resolver\WpieResolverFactoryInterface;

if( ! defined( 'ABSPATH' ) ) exit;

/**
 * @author webRtistik
 *
 * The WpieSettingValuesResolverFactory helps resolving values for settings
 * and should therefor be injected in the WpieSettingsValues constructor.
 *
 * Settings can be stored in the wp_options table but maybe also in a custom table
 *
 * The factory decides (WpieSettingValuesResolverFactory::getResolver())
 * which resolver (that must implements WpieSettingValuesResolverInterface) to return.
 *
 * A class implementing the WpieSettingValuesResolverInterface
 * is able to return: settings files, fields, defaults and setting instances.
 *
 */
final class WpieSettingValuesResolverFactory extends WpieResolverFactory
{
	/**
	 * Constructor
	 *
	 * @param string $type
	 */
	public function __construct( $type = '' )
	{
		parent::__construct( $type );
	}


	/**
	 * {@inheritDoc}
	 * @see \WpieFw\Framework\Patterns\Resolver\WpieResolverFactoryInterface::getResolver()
	 */
	public function getResolver( WpieDefinition $definitions )
	{
		switch( $this->type ) {
			case 'wp_options':
				return new WpieSettingValuesWpOptionsResolver( $definitions );
				break;
		}
	}
}