<?php

namespace WpieFw\Settings\Resolver;

use WpieFw\Framework\Patterns\Resolver\WpieFilesResolverInterface;

if( ! defined( 'ABSPATH' ) ) exit;

interface WpieSettingValuesResolverInterface extends WpieFilesResolverInterface
{
	/**
	 * Get stored setting fields array
	 *
	 * @param string $idx
	 *
	 * @return string
	 */
	public function getArray( $idx = '' );

	/**
	 * Get stored default setting
	 *
	 * @return string
	 */
	public function getDefault();

	/**
	 * Get stored setting values
	 *
	 * @param string $idx
	 *
	 * @return array
	 */
	public function getSetting( $idx = '' );

	/**
	 * Get stored temporary setting values
	 *
	 * @param string $idx
	 *
	 * @return array
	 */
	public function getSettingTmp( $idx = '' );

	/**
	 * Store stored setting fields array
	 *
	 * @param string $idx
	 * @param array $fields
	 *
	 * @return boolean
	 */
	public function persistArray( string $idx, array $fields );

	/**
	 * Store stored default setting
	 *
	 * @param string $value
	 *
	 * @return boolean
	 */
	public function persistDefault( $value = '' );

	/**
	 * Store stored setting values
	 *
	 * @param string $idx
	 * @param array $setting
	 *
	 * @return boolean
	 */
	public function persistSetting( string $idx, array $setting );

	/**
	 * Store stored setting values for temporarly backing up the setting
	 *
	 * Because the temporary setting is a copy of the existing setting,
	 * the copy is made internally and there for no array $setting argument is needed.
	 *
	 * @param string $idx
	 *
	 * @return boolean
	 */
	public function persistSettingTmp( $idx = '' );

	/**
	 * Delete stored setting fields array
	 *
	 * @param string $idx
	 *
	 * @return boolean
	 */
	public function deleteArray( $idx = '' );

	/**
	 * Delete stored default setting
	 *
	 * @return boolean
	 */
	public function deleteDefault();

	/**
	 * Delete stored setting values
	 *
	 * @param string $idx
	 *
	 * @return boolean
	 */
	public function deleteSetting( $idx = '' );

	/**
	 * Delete stored temporary setting values
	 *
	 * @param string $idx
	 *
	 * @return boolean
	 */
	public function deleteSettingTmp( $idx = '' );
}