<?php
/**
 * Template for option groups
 *
 * Please see weepie-framework.php for more details.
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 * @since 1.2
 */

use WpieFw\Helpers\WpieSettingsHelper;

if( ! defined( 'ABSPATH' ) ) exit;

// FOREACH FORM FIELD
foreach( $form_fields['settings'] as $fieldName => $fieldData ):

	if( '@attributes' === $fieldName ) continue; ?>

	<?php if( apply_filters( "{$namespace}_settings_escape_field_{$current_templ}", false, $fieldData, $vars ) ) continue; ?>

	<?php

	// IF IS FORMGROUP
	if( WpieSettingsHelper::isFormGroup( $fieldName ) ): ?>

	<?php
	// FOREACH GROUP DATA
	foreach( $fieldData as $groupFieldData ):
		$groupName = WpieSettingsHelper::getFieldAttributeName( $groupFieldData );

		if( !isset( $groupFieldData['field'][0] ) ):
		$groupFieldData['field'] = [ $groupFieldData['field'] ];
		endif; ?>

		<?php if(apply_filters( "{$namespace}_settings_escape_group", false, $groupName, $vars )) continue; ?>
		<?php if(apply_filters( "{$namespace}_settings_escape_group_{$current_templ}", false, $groupName, $vars )) continue; ?>

		<?php if( WpieSettingsHelper::hasFormGroupTitle( $groupFieldData ) )    : ?><h3><?php _e( $groupFieldData['group_title'] ) ?></h3><?php endif ?>
		<?php if( WpieSettingsHelper::hasFormGroupDescr( $groupFieldData ) )    : ?><p><?php _e( $groupFieldData['group_descr'] ) ?></p><?php endif ?>
		<?php if( WpieSettingsHelper::hasFormGroupWarning( $groupFieldData ) )  : ?><p><span class="dashicons dashicons-megaphone"></span><span class="warning"><?php _e( $groupFieldData['group_warning'] ) ?></span></p><?php endif ?>

		<table<?php echo WpieSettingsHelper::getFieldCssIdString( $fieldName, $groupFieldData ) ?> class="form-table form-fields-<?php echo $namespace ?> form-group">
		<?php
		// FOREACH GROUP FIELD
		foreach( $groupFieldData['field'] as $field ): ?>

			<?php $name = WpieSettingsHelper::getFieldAttributeName( $field ); ?>

			<?php if(apply_filters( "{$namespace}_settings_escape_groupfield", false, $field, $vars )) continue; ?>
			<?php if(apply_filters( "{$namespace}_settings_escape_groupfield_{$current_templ}", false, $field, $vars )) continue; ?>

			<?php do_action( "{$setting}_groupfield_before_tr", $field, $vars ) ?>

			  <tr valign="top" class="<?php echo $field['elem'] ?>">

				<?php if( WpieSettingsHelper::hasTitle( $field ) ): ?><th scope="row"><label><?php  _e( $field['title'], $namespace ) ?></label><?php if( WpieSettingsHelper::hasDescr( $field ) ): ?><span class="descr-i toggler"><i></i></span><?php endif ?></th><?php endif ?>
					<td colspan="<?php echo ( WpieSettingsHelper::hasTitle( $field ) ) ? 1 : 2 ?>">

						<?php do_action( "{$setting}_groupfield_before_td_content", $field, $vars ) ?>

						<?php $class = '\\WpieFw\\Helpers\\' . ((WpieSettingsHelper::isWpField($field)) ? 'WpieWpFormHelper' : 'WpieFormHelper') ?>
						<?php echo $class::formField( $field['elem'], $name, (isset( ${$name} ) ? ${$name} : ''), $setting,
			                                              ( WpieSettingsHelper::hasAttr($field) ? WpieSettingsHelper::getAttr($field) : [] ),
			                                              ( WpieSettingsHelper::hasInnerHtml($field) ? WpieSettingsHelper::getInnerHtml($field, $module_path, $vars) : '' ),
			                                              ( WpieSettingsHelper::isSelect($field) ? WpieSettingsHelper::getSelectOptions($field) : [] ) ) ?>

					</td>

			  </tr>
		  	<?php if( WpieSettingsHelper::hasDescr( $field ) ): ?><tr class="description" valign="top"><td colspan="2"><p class="togglethis" data-toggle-status="hide"><?php  _e( $field['descr'] , $namespace ) ?></p></td></tr><?php endif ?>
		<?php
		// ENDFOREACH GROUP FIELD
		endforeach; ?>
		</table>
	<?php
	// ENDFOREACH GROUP DATA
	endforeach; ?>

	<?php // ELSE IS FIELD
	else:

	foreach( $fieldData as $field ): ?>

	<?php $name = WpieSettingsHelper::getFieldAttributeName( $field ); ?>

	<table<?php echo WpieSettingsHelper::getFieldCssIdString( $fieldName, $field ) ?> class="form-table form-fields-<?php echo $namespace ?>">
	  <tr valign="top" class="<?php echo $field['elem'] ?>">
			<?php if( WpieSettingsHelper::hasTitle( $field ) ): ?><th scope="row"><?php _e( $field['title'], $namespace ) ?><?php if( WpieSettingsHelper::hasDescr( $field ) ): ?><span class="descr-i toggler"><i></i></span><?php endif ?></th><?php endif ?>
			<td colspan="<?php echo ( WpieSettingsHelper::hasTitle( $field ) ) ? 1 : 2 ?>">

			<?php do_action( "{$setting}_field_before_td_content", $field, $vars ) ?>

			<?php $class = '\\WpieFw\\Helpers\\' . ((WpieSettingsHelper::isWpField($field)) ? 'WpieWpFormHelper' : 'WpieFormHelper') ?>
			<?php echo $class::formField( $field['elem'], $name, (isset( ${$name} ) ? ${$name} : ''), $setting,
	                                          ( WpieSettingsHelper::hasAttr( $field ) ? WpieSettingsHelper::getAttr( $field ) : [] ),
	                                          ( WpieSettingsHelper::hasInnerHtml( $field ) ? WpieSettingsHelper::getInnerHtml( $field, $module_path, $vars ) : '' ),
	                                          ( WpieSettingsHelper::isSelect( $field ) ? WpieSettingsHelper::getSelectOptions( $field ) : [] ) ) ?>
			</td>
	  </tr>
	  <?php if( WpieSettingsHelper::hasDescr( $field ) ): ?><tr class="description" valign="top"><td colspan="2"><p class="togglethis" data-toggle-status="hide"><?php  _e( $field['descr'], $namespace ) ?></p></td></tr><?php endif ?>
	</table>
	<?php endforeach; ?>
	<?php endif;
// ENDFOREACH FORM FIELD
endforeach ?>

<?php if($do_submit_btn): ?><p class="submit">
<?php
echo \WpieFw\Helpers\WpieFormHelper::formField(
	'submit',
	'btn_submit',
	__( 'Save changes' ),
	false,
	[
		'class' => 'button-submit button button-primary',
		'aria-label' => __( 'Save changes' )
	],
	__( 'Add', $namespace )
	)
?>
<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
		'buttonsubmitconfirm',
		'reset',
		'',
		'',
		[ '_msg' => __( 'Are you sure you want to RESET to default settings?', $namespace ), '_hidden_name' => 'wpie_do_reset', '_namespace' => $namespace ],
		__( 'Reset', $namespace )
		) ?>
</p><?php endif ?>