<?php
/**
 * Template for the admin settings page (parent)
 *
 * Please see weepie-framework.php for more details.
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 * @since 1.2
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="wrap">

	<div id="wpie-plugin-header">
		<div class="logo"></div>
		<h2><?php echo $title ?><?php echo ( $version ) ? ' v'.$version: '' ?></h2>
	</div>

	<div id="notice-holder"></div>

	<div id="wpie-nav-wrapper">
		<ul class="group<?php if( !$has_tabs ): ?> no-tabs<?php endif ?>">
		<?php if( $has_tabs ): ?>
			<?php foreach( $tabs as $k => $tab_data ): ?>
			<li class="<?php echo $tab_data['class'] ?>"><a href="<?php echo $tab_data['uri']?>"><?php _e( $tab_data['tab'], 'weepie' ) ?></a></li>
			<?php endforeach ?>
			<li id="instr-<?php echo $namespace ?>" class="sublink"><a href="<?php echo $instructions_uri ?>" title="<?php esc_attr_e( "Read more details and intructions about the $title", $namespace ) ?>" target="_blank"><?php _e( 'Instruction guide ', 'weepie' ) ?> &rsaquo;</a></li>
			<li id="wpie-ei-toggler" class="sublink" ><a class="toggler"><?php _e( 'Export / Import settings' ) ?></a>
			<div id="wpie-ei-wrapper" class="togglethis" data-toggle-status="hide" style="display: none">
			<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
				'textarea',
				"",
				"",
				'',
				[
					'id' => 'wpie-ei-textarea',
					'placeholder' => __( 'Paste your exported settings content here and click on Import...', 'weepie' )] ) ?>

				<p id="wpie-ei-message" style="display: none"></p>

			<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
				'button',
				'',
				'',
				'',
				[ 'id' => 'wpie-btn-export' ],
				__( 'Export', 'weepie' )
			 ) ?>
			<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
				'button',
				'',
				'',
				'',
				[ 'id' => 'wpie-btn-import' ],
				__( 'Import', 'weepie' )
			 ) ?>
			</div>
		</li>
		<?php else: ?>
			<li id="instr-<?php echo $namespace ?>" class="sublink"><a href="<?php echo $instructions_uri ?>" title="<?php esc_attr_e( "Read more details and intructions about the $title", $namespace ) ?>" target="_blank"><?php _e( 'Instruction guide ', 'weepie' ) ?> &rsaquo;</a></li>
			<li class="sublink" ><a class="toggler"><?php _e( 'Export / Import settings' ) ?></a></li>
		<?php endif ?>
		</ul>
	</div>

	<div <?php if( $has_tabs ): ?>id="tab-<?php echo $current_tab_nice ?>" <?php endif?>class="tab-content">

		<?php if( $has_tabs ): ?>
		<form id="wpie-settings-form-<?php echo $current_tab_nice ?>" class="<?php echo $namespace ?>-settings-form wpie-settings-form" data-setting-group="<?php echo $setting ?>" method="post" action="options.php">

		<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
				'hidden',
				"{$namespace}_tab",
				$current_tab,
				$setting ) ?>

		<?php settings_fields( $setting ) ?>

		<?php echo $table ?>
		</form>

		<?php else: ?>
		<form class="<?php echo $namespace ?>-settings-form wpie-settings-form" data-setting-group="<?php echo $setting ?>" method="post" action="options.php">

		<?php echo \WpieFw\Helpers\WpieFormHelper::formField(
				'hidden',
				"{$namespace}_tab",
				$current_tab,
				$setting ) ?>

		<?php settings_fields( $setting ) ?>
		<?php echo $table ?>

		</form>
		<?php endif ?>

	</div>
</div>