<?php
/*
Main plugin file for WeePie Framework

WeePie Framework - A WordPress Plugin Framework

Copyright (C) 2013 - 2023, Vincent Weber webRtistik

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

if( ! defined( 'ABSPATH' ) ) exit;

// Composer autoload src classes
require __DIR__ . '/vendor/autoload.php';

if( !class_exists( 'WeePieFramework' ) ) {

	/**
	 * WeePieFramework Class
	 *
	 * This is the main Plugin class for WeePieFramework
	 *
	 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
	 * @since 1.0
	 */
	class WeePieFramework extends \WpieFw\Wpie\WpieCore
	{
		/**
		 * Current version of the WeePie Framework
		 *
		 * @var string
		 *
		 * @since 1.0.4
		 */
		const VERSION = '2.0.17';

		/**
		 * WeePie Framework plugin instances
		 *
		 * @var array
		 *
		 * @since 2.0
		 */
		private static $instance = [];

		/**
		 * Constructor
		 *
		 * @access private
		 *
		 * @since 2.0
		 */
		private function __construct() {}

		/**
		 * Get singleton instance of the WeePie Framework plugin
		 *
		 * @access public
		 *
		 * @param string $namespace
		 *
		 * @since 2.0
		 *
		 * @return static
		 */
		public static function instance( $namespace = '' )
		{
			if( !is_string( $namespace ) || '' === trim( $namespace ) ) {
				throw new \WpieFw\Exceptions\WpieInvalidArgumentException( 'Could not return plugin instance. Namespace parameter is empty.' );
			}

			if( !isset( self::$instance[$namespace] ) ) {
				self::$instance[$namespace] = new static();
			}

			return self::$instance[$namespace];
		}

		/**
		 * Start a Plugin
		 *
		 * @access public
		 *
		 * @param array $args
		 *
		 * @uses WpieCore::engine()
		 *
		 * @since 1.0
		 */
		public function start( array $args = [] )
		{
			// Parse the plugin arguments with the defaults array
			$args = wp_parse_args( $args, [
				'namespace'		=> '',
				'file' 			=> '',
				'version' 		=> '',
				'settings'		=> [
						'pageTitle' => '',
						'menuTitle' => ''
				],
				'fileWpieFw'	=> __FILE__,
				'versionWf'		=> self::VERSION,
			] );

			parent::engine( $args['namespace'], $args );
		}
	}
}