<?php
/**
 * Template for showing a cookie block replacement
 *
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="<?php echo esc_attr( $class ) ?>" style="background-color:<?php echo esc_attr( $bgd_color ) ?>;" data-cc="<?php echo esc_attr( $cc ) ?>">
	<?php if( !$hide_logo ): ?><img src="<?php echo esc_url( $img_uri ) ?>/logo-cookie-allow-replacement-block.png" class="wpca-replacement-logo" alt="<?php _e( 'Placeholder image for blocked cookie content', 'wpca' ) ?>" /><?php endif ?>
	<p class="wpca-replace-txt"><?php
		// content is escaped in the module with `wp_kses`
		echo ( '' !== $txt )
			? $txt
			: sprintf( __( 'Content blocked by %s Plugin' , 'wpca' ), esc_html( $plugin_name ) ) ?></p>
</div>