/*
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 * @since 3.2.13
 */

window.WPCACOMPATIBILITY = (function($) {
	"use strict";
	var compat = {
		done: false,
	};

	var _idTableParent = 'general-compatibility-tmpl',
		_idTable = 'compatibility',
		_idBtnRefresh = 'wpca-compatibility-refresh-btn';

	var	events = {
			/**
			 * Unbind all events
			 *
			 * @returns events
			 */
			unbind:function() {
				// listen to a click on the refresh button
				$('#'+_idTableParent).off('click', '#'+_idBtnRefresh, handlerBtnRefresh);

				return this;
			},
			/**
			 * Bind all events
			 *
			 * @returns events
			 */
			bind: function() {
				// listen to a click on the refresh button
				$('#'+_idTableParent).on('click', '#'+_idBtnRefresh, handlerBtnRefresh);

				return this;
			}
		};

	/**
	 * Handler for click event on Refresh button
	 *
	 * @param {Object} e
	 */
	function handlerBtnRefresh(e) {
		var btn = $(this);

		e.preventDefault();

		// disable the button while refreshing
		btn.prop('disabled', true).setLoadingImg(true);

		var args = WPIESETT.getAjaxArgs( 'wpca-compatibility-refresh', {});
		$.get(ajaxurl, args, function(r) {
			try {
			  	switch(r.state) {
			  		case '0':
			  			if(r.errors && r.errors.length) {
			  				WPIE.log(r.errors);
			  			}
			  			WPIE.alert(wpcaDatal10n.error_occured);
			  			break;
			  		case '1':
						if(r.out.table) {
							// add the updated table HTML
							$('#'+_idTable).replaceWith(r.out.table);
							if(r.out.added && Array.isArray(r.out.added)) {
								$('#'+_idTable).find('tr').removeClass('added');
								var k, name;
								// for each new item, add the "added" css class
								for(k in r.out.added) {
									name = r.out.added[k];
									$('#'+_idTable).find('tr.'+name).addClass('added');
								}
								// remove the "added" css class with a delay
								setTimeout(function() {
									$('#'+_idTable).find('tr').removeClass('added');
								}, 500);
							}
						}
				    break;
			  	}
			  	// enable the button after refreshing
			  	btn.prop('disabled', false).setLoadingImg(false);
			} catch(exc) {
				btn.prop('disabled', false).setLoadingImg(false);
				WPIE.log(exc.message, exc);
			} finally {
				// unbind events and bind again
				events
					.unbind()
					.bind();
			}
		}, 'json');
	}

	/**
	 * Init the compatibility logic when the DOM is ready
	 *
	 * Tasks:
	 * 	- set params
	 * 	- callings function events.bind()
	 *
	 */
	compat.init = function() {
		if(this.done) {
			return;
		}
		if( null == WPCA_SETT || false === WPCA_SETT.done ) {
			throw new Error('Could not continue. WPCA_SETT object is not ready.');
		}

		// bind all events
		events.bind();

		this.done = true;
	};

	return compat;

})(jQuery || {}, window.WPCACOMPATIBILITY || {});

jQuery(function($) {
	// call init method when DOM is ready
	WPCACOMPATIBILITY.init();
});