<?php

use WpieFw\Exceptions\WpieInvalidArgumentException;

/**
 * CompatibilityItemConfig class
 *
 * @since 3.2.13
 */
 class CompatibilityItemConfig
 {
    public $type;
    public $cc;
    public $active;
    public $silent;
    public $doJsLogic;
    public $selector;
    public $jsFunc;
    public $depName;
    public $depDt;
    public $depRetries;

    public function __construct (
        $type = '',
        $cc = '',
        $active = false,
        $silent = false,
        $doJsLogic = false,
        $selector = '',
        $jsFunc = '',
        $depName = '',
        $depDt = 200,
        $depRetries = 3
    ) {
        if( !is_string( $type ) ||
            !is_string( $cc ) ||
            !is_string( $selector ) ||
            !is_string( $jsFunc ) ||
            !is_string( $depName ) ||
            !is_bool( $doJsLogic ) ||
            !is_bool( $active ) ||
            !is_bool( $silent ) ||
            !is_numeric($depDt) ||
            !is_numeric($depRetries) ||
            !$depDt < 0
        ) {
            throw new WpieInvalidArgumentException(
                __( 'one or more arguments are not valid for CompatibilityItemConfig.', 'wpca' )
            );
        }

        $this->type = trim( $type );
        $this->cc = trim( $cc );
        $this->selector = trim( $selector );
        $this->jsFunc = trim( $jsFunc );
        $this->doJsLogic = $doJsLogic;
        $this->active = $active;
        $this->silent = $silent;
        $this->depName = $depName;
        $this->depDt = $depDt;
        $this->depRetries = $depRetries;

        if( $silent ) {
            $this->active = true;
        }
    }
 }


/**
 * CompatibilityItem class
 *
 * @since 3.2.13
 */
class CompatibilityItem
{
    public $title;
    public $description;
    public $callback;
    public $config;
    public $hasInternalCallback = false;

    public function __construct ( $title = '', $description = '', CompatibilityItemConfig $config = null, $callback = null )
    {
        $this->title = $title;
        $this->description = $description;
        $this->config = $config;
        $this->callback = $callback;
    }

    public function doJsLogic()
    {
        return $this->config->doJsLogic || ($this->config->selector !== '' || $this->config->jsFunc != '');
    }
}
