<?php
/**
 * Template for the compatibility table on tab general
 *
 * @since 3.2.13
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<table id="compatibility" class="wpie-data-table wpie-data-table-half">
	<thead>
		<tr valign="top">
			<th scope="row"><?php _e( 'Item', 'wpca' )?></th>
			<th scope="row"><?php _e( 'Description', 'wpca' )?></th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ( $compatibility_data as $type => $data ): ?>
		<?php if( 0 === strpos( $type, '_' ) ) continue; ?>
		<tr valign="top" class="<?php echo $data->config->type ?>">
			<th>
			<?php echo \WpieFw\Helpers\WpieFormHelper::formField(

					'hidden',
					"{$setting}[compatibility_data][$type][type]",
					$data->config->type
					); ?>
			<?php echo \WpieFw\Helpers\WpieFormHelper::formField(

					'checkbox',
					"{$setting}[compatibility_data][$type][active]",
					$data->config->active,
					'',
					array( 'class' => 'compat-check' )
					); ?>
					<?php echo $data->title ?>
			</th>
			<td class="wpie-internal"><?php echo $data->description ?></td>
		</tr>
		<?php endforeach ?>
		<tr valign="top" class="no-border">
			<td colspan="2" class="compatibility-action"><?php echo \WpieFw\Helpers\WpieFormHelper::formField(

					'button',
					'',
					'',
					'',
					array( 'id' => 'wpca-compatibility-refresh-btn' ),
					__( 'Refresh', 'wpca' )

					)
			?><span class="ajax-loading ajax-loading-wpie"></span></td>
		</tr>
	</tbody>
</table>