<?php
/**
 * Template for the logged consent list table
 *
 * @since 3.2
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<div id="logs">
    <?php if( $has_logs ): ?>
    <table class="form-table form-fields-wpca">
    	<tr valign="top" class="no-border">
    		<td colspan="2">
        	<?php
        	echo \WpieFw\Helpers\WpieFormHelper::formField(
            	    'linkbutton',
            	    '',
            	    '',
            	    '',
            	    array( 'id' => 'wpca-consent-log-delete-all-btn' ),
            	    __( 'Delete all', 'wpca' )
        			);
        	?>
        	<?php
        	echo \WpieFw\Helpers\WpieFormHelper::formField(
            	    'linkbutton',
            	    '',
            	    '',
            	    '',
            	    array( 'id' => 'wpca-consent-log-export-btn' ),
            	    __( 'Export', 'wpca' )
        			);
        	?>
			<span class="ajax-loading ajax-loading-wpie"></span>
    		</td>
    	</tr>
    </table>
    <table class="wpie-data-table wpie-data-table-full<?php echo ( !$has_scroll ) ? ' no-scroll':'' ?> wpie-data-table-scroll-400" cellspacing="0">
    	<thead>
    		<tr>
    		<?php foreach ( $columns as $column => $name ): ?>
    		<th scope="row" class="<?php echo str_replace( '_', '-', $column ) ?>"><?php echo $name ?></th>
    		<?php endforeach ?>
    		</tr>
    	</thead>
    	<tbody>
    		<?php foreach ( $logs as $log ):
    		$declined = ( !$log->consent );
    		$css_class = ( $declined ) ? 'declined' : '';
    		?>	
    		<tr valign="top" class="<?php echo $css_class?>" data-id="<?php echo $log->id ?>">
    		<?php foreach ( $columns as $column => $name ): ?>
    			<td class="<?php echo str_replace( '_', '-', $column ) ?>"><?php echo $log->{$column} ?></td>
    		<?php endforeach ?>
    		<td colspan="<?php echo $columns_count ?>" class="delete wpie-red-bgd"><span class="wpca-consent-log-delete dashicons dashicons-trash"></span><?php _e( 'Delete logged consent for IP address: ', 'wpca' ); echo $log->ip_address ?></td>
    		</tr>
    		<?php endforeach ?>
    	</tbody>
    </table>
    <?php else: ?><?php printf( __( 'Nothing logged yet. %sDid you enable logging%s?', 'wpca' ), '<strong>', '</strong>' ) ?><?php endif ?>
</div>