<?php
/**
 * Template for showing the reconsider image
 *
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Author: Vincent Weber <vincent@webrtistik.nl> $
 * @since 3.4
 */
if( ! defined( 'ABSPATH' ) ) exit;
?>
<i id="wpca-reconsider-icon" title="<?php echo esc_attr( $hover_title ) ?>" class="<?php echo esc_attr( $class ) ?>">
    <svg
        version="1.1"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        x="0px"
        y="0px"
        width="35px"
        height="35px"
        viewBox="0 0 35 35"
        enable-background="new 0 0 35 35"
        xml:space="preserve">
        <title><?php echo __( 'Open cookie settings', 'wpca' ) ?></title>
        <path fill="<?php echo $fill ?>" d="M30.447,21.73c-0.545,0-0.986,0.439-0.986,0.984c0,0.542,0.441,0.98,0.986,0.98
            c0.541,0,0.98-0.438,0.98-0.98C31.43,22.171,30.988,21.73,30.447,21.73z M30.839,23.512c-0.229,0-0.411-0.181-0.411-0.406
            c0-0.228,0.182-0.405,0.411-0.405c0.224,0,0.405,0.181,0.405,0.405C31.244,23.329,31.063,23.512,30.839,23.512z"/>
        <path fill="<?php echo $fill ?>" d="M9.628,18.566L22.923,0.845C21.404,0.351,19.803,0.06,18.137,0L7.84,14.104L2.893,7.846
            C1.964,9.249,1.235,10.794,0.74,12.44l4.424,6.126C5.165,18.566,7.396,21.543,9.628,18.566z"/>
        <path fill="<?php echo $fill ?>" d="M24.684,1.57l-5.959,7.945l-8.74,11.653c-2.612,3.479-5.22,0-5.22,0l-4.547-6.293
            C0.084,15.733,0,16.609,0,17.507C0,27.17,7.835,35,17.5,35S35,27.17,35,17.507C35,10.407,30.762,4.312,24.684,1.57z M9.257,30.477
            c-1.65,0-2.989-1.339-2.989-2.99c0-1.65,1.338-2.988,2.989-2.988c1.651,0,2.989,1.338,2.989,2.988
            C12.246,29.138,10.908,30.477,9.257,30.477z M16.098,26.617c-1.17,0-2.119-0.949-2.119-2.119s0.949-2.119,2.119-2.119
            c1.17,0,2.119,0.949,2.119,2.119S17.268,26.617,16.098,26.617z M18.218,16.654c-1.193,0-2.16-0.967-2.16-2.16s0.967-2.16,2.16-2.16
            c1.193,0,2.16,0.967,2.16,2.16S19.411,16.654,18.218,16.654z M22.402,8.864c0-1.482,1.201-2.684,2.684-2.684
            s2.684,1.202,2.684,2.684c0,1.482-1.201,2.684-2.684,2.684S22.402,10.346,22.402,8.864z M26.264,30.4
            c-1.609,0-2.914-1.305-2.914-2.914s1.305-2.913,2.914-2.913s2.914,1.304,2.914,2.913S27.873,30.4,26.264,30.4z M31.43,19.583
            c-1.617,0-2.928-1.311-2.928-2.927c0-1.617,1.311-2.927,2.928-2.927c1.615,0,2.926,1.311,2.926,2.927
            C34.355,18.272,33.045,19.583,31.43,19.583z"/>
        <circle fill="<?php echo $fill ?>" cx="10.022" cy="26.723" r="0.765"/>
        <circle fill="<?php echo $fill ?>" cx="15.641" cy="23.695" r="0.764"/>
        <circle fill="<?php echo $fill ?>" cx="26.253" cy="26.791" r="1.189"/>
        <circle fill="<?php echo $fill ?>" cx="31.646" cy="15.75" r="0.957"/>
        <circle fill="<?php echo $fill ?>" cx="18.982" cy="13.728" r="0.767"/>
        <circle fill="<?php echo $fill ?>" cx="25.568" cy="9.147" r="1.013"/>
    </svg>
</i>