<?php
/**
 * Please see wp-cookie-allow.php for more details.
 *
 * @author $Vincent Weber <vincent@webrtistik.nl>$
 *
 * This file contains the upgrade logic
 */

use WpieFw\Helpers\WpieMultilangHelper;

if( ! defined( 'ABSPATH' ) ) exit;

add_action( 'wpca_wpiefw_upgrade_logic', 'wpca_wpiefw_upgrade_logic', 10, 5 );

/**
 * Callback for wpca_wpiefw_upgrade_logic hook
 *
 * Handles upgrade logic
 *
 * @param string $currVersionPlugin
 * @param string $newVersionPlugin
 * @param string $wpiefwVersionOld
 * @param string $versionWpieFw
 * @param bool $network_wide
 *
 * @since 2.3.3
 */
function wpca_wpiefw_upgrade_logic( $currVersionPlugin, $newVersionPlugin, $wpiefwVersionOld, $versionWpieFw, $networkWide )
{
	if( version_compare( $newVersionPlugin, '3.4.7', '>=' ) ) {
		$msg = sprintf(
			'Hi! You have updated to version %s. This version includes the following changes:<br/><br/>' .
				'* We\'ve fixed the data tables responsiveness (e.g. the 3rd party and consent log list)<br/>' .
				'* We\'ve fixed custom styles not working (e.g. button colors not loaded)<br/>' .
				'* We\'ve improved the SVG icon titles to be translatable (and removed WeePie Cookie Allow text from it)<br/>' .
				'<a target="_blank" href="https://www.weepie-plugins.com/changelog-weepie-cookie-allow-plugin/">View the changelog</a>.'
				, $newVersionPlugin );
		set_transient( 'wpca_upgrade_msg', $msg, 86400 );
	}

	if( version_compare( $currVersionPlugin, '3.2.13', '>=' ) ) {
		$options = [
			'general',
			'style',
			'content',
			'consent_log',
			'ccpa'
		];
		foreach ( $options as $option ) {
			$setting = get_option( "wpca_settings_$option" );

			if( WpieMultilangHelper::isLanguagedOption( $setting ) ) {
				foreach ( $setting as $k => $entries ) {
					// corrupt locales check
					if( WpieMultilangHelper::isLanguagedOption( $entries ) ) {
						$keys = array_keys( $entries );

						foreach ( $keys as $key ) {
							if ( 1 === preg_match( '/^[a-z]{2}_[A-Z]{2}$/', $key, $m ) ) {
								if( isset( $setting[$k][$key] ) ) {
									unset( $setting[$k][$key] );
								}
							}
						}
					}
				}
				update_option( "wpca_settings_$option", $setting );
			}
		}
	}

	if( version_compare( $newVersionPlugin, '3.2.13', '>=' ) ) {
		// update changed shortcode
		$content = get_option( 'wpca_settings_content' );

		if( WpieMultilangHelper::isLanguagedOption( $content ) ) {
			foreach( $content as $locale => $setting ) {
				if( isset( $setting['content_cc_txt'] ) ) {
					$content[$locale]['content_cc_txt'] = str_replace(
						'[wpca_cc_settings_btn_default_sett]',
						'[wpca_cc_settings_btn_accept_all]',
						$setting['content_cc_txt']
					);
				}
				if( isset( $setting['wpca_cc_settings_btn_default_sett'] ) ) {
					unset( $content[$locale]['wpca_cc_settings_btn_default_sett'] );
				}
			}
			update_option( 'wpca_settings_content', $content );
		} else {
			if( isset( $content['content_cc_txt'] ) ) {
				$content['content_cc_txt'] = str_replace(
					'[wpca_cc_settings_btn_default_sett]',
					'[wpca_cc_settings_btn_accept_all]',
					$content['content_cc_txt']
				);
			}
			if( isset( $content['wpca_cc_settings_btn_default_sett'] ) ) {
				unset( $content['wpca_cc_settings_btn_default_sett'] );
			}
			update_option( 'wpca_settings_content', $content );
		}
	}
	if( version_compare( $wpiefwVersionOld, '1.4.14', '<=' ) ) {
		delete_option( 'wpca_globals' );
	}
	// from version 3.2.7 the file is named i18n.php (lower case i)
	if( version_compare( $newVersionPlugin, '3.2.7', '>=' ) ) {
		@unlink( dirname( __FILE__ ).'/settings/I18n.php' );

		// from WeePie Framework v2.0, settings fields are stored as serialized arrays
		// there for delete the old fields entries, which were storing XML strings
		$options = [
			'general',
			'style',
			'content',
			'consent_log'
		];
		foreach ( $options as $option ) {
			delete_option( "wpca_settings_{$option}_fields" );
		}

		delete_option( "active_wpie_plugins" );
	}
}