<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* TimeOffReasonIconType File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* TimeOffReasonIconType class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class TimeOffReasonIconType extends Enum
{
    /**
    * The Enum TimeOffReasonIconType
    */
    const NONE = "none";
    const CAR = "car";
    const CALENDAR = "calendar";
    const RUNNING = "running";
    const PLANE = "plane";
    const FIRST_AID = "firstAid";
    const DOCTOR = "doctor";
    const NOT_WORKING = "notWorking";
    const CLOCK = "clock";
    const JURY_DUTY = "juryDuty";
    const GLOBE = "globe";
    const CUP = "cup";
    const PHONE = "phone";
    const WEATHER = "weather";
    const UMBRELLA = "umbrella";
    const PIGGY_BANK = "piggyBank";
    const DOG = "dog";
    const CAKE = "cake";
    const TRAFFIC_CONE = "trafficCone";
    const PIN = "pin";
    const SUNNY = "sunny";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}