<?php
if (!class_exists('IndeedDoLogs')){
	class IndeedDoLogs{
		private $process_id;
		private $table;
		private $action_id;
		private $type;
		private $db;

		public function __construct(){
			global $wpdb;
			$this->db = $wpdb;
			$this->table = $this->db->base_prefix . 'indeed_logs';
		}

		public function IndeedDoLogs(){

		}

		public function get_logs_for_process($id){
			global $wpdb;
			$query = $wpdb->prepare( "SELECT id, process_id, action_id, stage, message, type, create_date, status
																		FROM {$this->table} WHERE process_id=%s ORDER BY create_date ASC,id ASC", $id );
			$data = $this->db->get_results( $query );
			return $data;
		}

		public function get_logs_for_process_for_popup($id){
			global $wpdb;
			$return = array();

			$query = $wpdb->prepare( "SELECT id, process_id, action_id, stage, message, type, create_date, status
				 														FROM {$this->table} WHERE process_id=%d ORDER BY create_date ASC", $id );
			$data = $this->db->get_results( $query );
			foreach ($data as $obj){
				$log = $obj->stage;

				$return[$log]['create_date'] = $obj->create_date;

				$return[$log]['message'] = $obj->message;
				if (strpos($log, '-')!==FALSE){

					$log_arr = explode('-', $log);

					if ($log_arr[1]>0 && $log_arr[1]<100){

						unset($return[$log]);

					}

				}
			}

			return $return;

		}

		public function get_last_log_for_backup($id){
			global $wpdb;
			$query = $wpdb->prepare( "SELECT id, process_id, action_id, stage, message, type, create_date, status
				 														FROM {$this->table} WHERE action_id=%d ORDER BY id DESC LIMIT 1", $id );
			$data = $this->db->get_results( $query );
			if (!empty($data[0]->create_date)) return $data[0]->create_date;
		}

		public function get_process_list($limit=''){
			global $wpdb;
			$arr = array();
			$query = "SHOW TABLES LIKE '{$this->table}'";
			if ($this->db->get_var( $query ) == $this->table){
				$query = "SELECT DISTINCT process_id FROM {$this->table} ORDER BY process_id DESC ";
				if ( $limit > 0 ){
						$query .= $wpdb->prepare( " LIMIT %d", $limit );
				}
				$data = $this->db->get_results( $query );
				if (!empty($data)){
					foreach ($data as $obj){
						$arr[] = $obj->process_id;
					}
				}
			}
			return $arr;
		}

		public function delete_logs_by_process($id){
			global $wpdb;
			$query = $wpdb->prepare( "DELETE FROM {$this->table} WHERE process_id=%d ", $id );
			$this->db->query( $query );
		}

		public function set_type($type){
			$this->type = $type;
		}

		public function set_action_id($id){
			$this->action_id = $id;
		}

		public function insert_log($stage, $message, $status = 0){
			global $wpdb;
			$current_date = date("Y-m-d H:i:s", time() );
			$query = $wpdb->prepare( "INSERT INTO {$this->table} values(null, %s, %s, %s, %s, %s, %s, %s );",
					$this->process_id, $this->action_id, $stage, $message, $this->type, $current_date, $status
			);
			$this->db->query( $query );
		}

		public function create_log($stage, $message, $status = 0){
			$this->set_process_id();
			$this->insert_log($stage, $message, $status);
		}


		public function set_process_id($id=FALSE){
			if ($id){
				$this->process_id = $id;
			} else {
				$query = "SELECT process_id FROM {$this->table} ORDER BY id DESC LIMIT 1 ;";
				$data = $this->db->get_results( $query );
				if (!empty($data[0]->process_id)){
					$this->process_id = (int)$data[0]->process_id + 1;
				} else {
					$this->process_id = 1;
				}
			}
		}

		public function clean_db($date){
			/*
			 * delete all logs older than $date
			 * @param $date timestamp
			 */
			global $wpdb;
			$date = date("Y-m-d H:i:s", $date );
			$query = $wpdb->prepare( "DELETE FROM {$this->table} WHERE create_date<%s ;", $date );
			$this->db->query( $query );
		}

	}//end of IndeedDoLogs Class
}//end of if
