<?php
/**
* Plugin Name: Seat Reservation for WordPress and WooCommerce
* Plugin URI: http://codecanyon.net/user/smartcms
* Description: seat reservation for woocommerce product and wordpress post
* Version: 3.0
* Author: SmartCms Team
* Author URI: http://codecanyon.net/user/smartcms
* License: GPLv2 or later
*/
 
define ( 'SMARTCMS_SRW_URL', plugin_dir_url(__FILE__));

function boot_session() {
  session_start();
}
add_action('wp_loaded','boot_session');

register_activation_hook(__FILE__, 'smartcms_srw_install');
global $wnm_db_version;
$wnm_db_version = "1.0";

function smartcms_srw_install(){
	global $wpdb;
	global $wnm_db_version;
	
	$table_name = $wpdb->prefix . 'srw_seat_reservation_profile';
	$table_name2 = $wpdb->prefix . 'srw_seat_reservation_seat';
	$table_name3 = $wpdb->prefix . 'srw_seat_reservation_map';
	$table_name4 = $wpdb->prefix . 'srw_seat_reservation_map_value';
	$table_name5 = $wpdb->prefix . 'srw_seat_reservation_product';
	$table_name6 = $wpdb->prefix . 'srw_seat_reservation_product_value';
	$table_name7 = $wpdb->prefix . 'srw_seat_reservation_order';
	$table_name8 = $wpdb->prefix . 'srw_seat_reservation_schedule';
	$table_name9 = $wpdb->prefix . 'srw_seat_reservation_config';
	$dailyschedulesTB = $wpdb->prefix . 'srw_seat_reservation_dailyschedules';
	$dailytimesTB = $wpdb->prefix . 'srw_seat_reservation_dailytimes';
	$charset_collate = $wpdb->get_charset_collate();
	
	$sql = "CREATE TABLE $table_name (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`profileName` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql2 = "CREATE TABLE $table_name2 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`profileID` int(11) DEFAULT NULL,
		`seatLabel` varchar(255) DEFAULT NULL,
		`seatColor` varchar(255) DEFAULT NULL,
		`isbooked` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql3 = "CREATE TABLE $table_name3 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`profileID` int(11) DEFAULT NULL,
		`mapcolumn` varchar(255) DEFAULT NULL,
		`row` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql4 = "CREATE TABLE $table_name4 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`mapId` int(11) DEFAULT NULL,
		`mapcolumn` varchar(255) DEFAULT NULL,
		`row` varchar(255) DEFAULT NULL,
		`type` varchar(255) DEFAULT NULL,
		`numberofseat` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql5 = "CREATE TABLE $table_name5 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`proId` int(11) DEFAULT NULL,
		`profileID` int(11) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql6 = "CREATE TABLE $table_name6 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`proId` int(11) DEFAULT NULL,
		`profileID` int(11) DEFAULT NULL,
		`color` varchar(255) DEFAULT NULL,
		`price` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql7 = "CREATE TABLE $table_name7 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`proId` int(11) DEFAULT NULL,
		`orderId` varchar(255) DEFAULT NULL,
		`seat` varchar(255) DEFAULT NULL,
		`schedule` varchar(255) DEFAULT NULL,
		`name` varchar(255) DEFAULT NULL,
		`address` varchar(255) DEFAULT NULL,
		`email` varchar(255) DEFAULT NULL,
		`phone` varchar(255) DEFAULT NULL,
		`note` varchar(255) DEFAULT NULL,
		`total` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql8 = "CREATE TABLE $table_name8 (
		`ID` int(11) NOT NULL AUTO_INCREMENT,
		`proId` int(11) DEFAULT NULL,
		`datetime` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$sql9 = "CREATE TABLE $table_name9 (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`price` varchar(255) DEFAULT NULL,
		`compulsory` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$dailyschedulesSql = "CREATE TABLE $dailyschedulesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`daily` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	$dailytimesSql = "CREATE TABLE $dailytimesTB (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`profileid` int(11) DEFAULT NULL,
		`time` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) $charset_collate;";
	
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta($sql);
	dbDelta($sql2);
	dbDelta($sql3);
	dbDelta($sql4);
	dbDelta($sql5);
	dbDelta($sql6);
	dbDelta($sql7);
	dbDelta($sql8);
	dbDelta($sql9);
	dbDelta($dailyschedulesSql);
	dbDelta($dailytimesSql);
	add_option("wnm_db_version", $wnm_db_version);
}

add_action( 'admin_menu', 'smartcms_srw_admin_menu' );
function smartcms_srw_admin_menu() {
    add_menu_page(
        'SRW Seat Reservation',
        'SRW Seat Reservation',
        'manage_options',
        'srw-seat-reservation',
        'smartcms_srw_options_page'
    );
}
function smartcms_srw_options_page(  ) { 
	?>
	<form action='options.php' method='post'>
		<h2><?php echo esc_html__("SmartCms Seat Reservation Configuration", "scwasrfw-translate"); ?></h2>
		<?php
		settings_fields( 'pluginSRWPage' );
		do_settings_sections( 'pluginSRWPage' );
		submit_button();
		?>
	</form>
	<?php
}

add_action( 'admin_init', 'smartcms_srw_settings_init' );
function smartcms_srw_settings_init() {
	register_setting( 'pluginSRWPage', 'smartcms_srw_settings' );
	add_settings_section(
		'smartcms_pluginPage_section', '', '', 'pluginSRWPage'
	);
	add_settings_field( 
		'','',
		'smartcms_srw_parameters', 
		'pluginSRWPage', 
		'smartcms_pluginPage_section' 
	);
} 
function smartcms_srw_parameters(){
	$options = get_option( 'smartcms_srw_settings' );
	global $wpdb;
	
	wp_register_script('srw-script', SMARTCMS_SRW_URL .'js/admin.js');
	wp_enqueue_script('srw-script');
	wp_register_style('srw-css', SMARTCMS_SRW_URL .'css/admin.css?v=1.0');
	wp_enqueue_style('srw-css');
	wp_register_style( 'accordion-style', SMARTCMS_SRW_URL .'css/accordion-style.css' );
	wp_enqueue_style( 'accordion-style' );
	
	wp_enqueue_script( 'jquery-ui-datepicker' );
	wp_register_style( 'jquery-ui', '//code.jquery.com/ui/1.11.2/themes/smoothness/jquery-ui.css' );
    wp_enqueue_style( 'jquery-ui' );
	
	wp_register_script('srw-timepicker', SMARTCMS_SRW_URL .'js/jquery-ui-timepicker-addon.js');
	wp_enqueue_script('srw-timepicker');
	wp_register_style( 'timepicker-style', SMARTCMS_SRW_URL .'css/jquery-ui-timepicker-addon.css' );
	wp_enqueue_style( 'timepicker-style' );
	
	$tableProfile = $wpdb->prefix . 'srw_seat_reservation_profile';
	$profiles = $wpdb->get_results( "SELECT * FROM $tableProfile" );
	
	$tableConfig = $wpdb->prefix . 'srw_seat_reservation_config';
	$config = $wpdb->get_results( "SELECT * FROM $tableConfig" );
	$pricon = $config[0]->price;
	$mat = $config[0]->compulsory;
	?>
	<div class="wrap">
		<div class="smartcms_seat_reservation">
			<div class="smartcms_seat_reservation_config">
				<span class="config_header"><?php echo esc_html__("Config", "scwasrfw-translate"); ?></span><br>
				<div class="scw_config_price">
					<input <?php if($pricon == "yes") echo "checked" ?> type="checkbox" class="config_price">
					<label><?php echo esc_html__("Price in cart is wrong? Choose to fix it.", "scwasrfw-translate"); ?></label>
				</div>
				<div class="scw_config_mat">
					<input <?php if($mat == "yes") echo "checked" ?> type="checkbox" class="config_compulsory">
					<label><?php echo esc_html__("Compulsory choose seat before add product to cart?", "scwasrfw-translate"); ?></label>
				</div>
			</div>
			<div class="smartcms_seat_reservation_profile">
				<span class="create_profile_header"><?php echo esc_html__("Create Profile", "scwasrfw-translate"); ?></span><br>
				<input class="profile_name" type='text' />
				<span class="add_profile"><?php echo esc_html__("Add", "scwasrfw-translate"); ?></span>
			</div>
			<div class="smartcms_seat_reservation_profile_content">
				<section class="ac-container">
				<?php
				if($profiles){
					foreach($profiles as $key=>$file){
						$proId = $file->ID;
						?>
						<div>
							<input id="ac-<?php echo esc_attr($key) ?>" type="radio" <?php if($key == 0) echo "checked" ?> name="accordion-1"/>
							<label for="ac-<?php echo esc_attr($key) ?>" class="srwseat_profile_name">
								<span><?php echo esc_attr($file->profileName) ?></span>
								<input class="srwseat_profile_name_input" name="srwseat_profile_name<?php echo esc_attr($key) ?>" value="<?php echo esc_attr($file->profileName) ?>">
								<span class="srwseat_profile_name_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
								<input type="hidden" class="srwseat_profile_name_id" value="<?php echo esc_attr($proId) ?>">
								<span class="srwseat_profile_name_delete"><?php echo esc_html__("Delete", "scwasrfw-translate"); ?></span>
								<span class="srwseat_profile_name_copy"><?php echo esc_html__("Copy", "scwasrfw-translate"); ?></span>
							</label>
							<article class="ac-small">
								<div class="srwseat_content">
									<input type="hidden" class="srwseat_content_id" value="<?php echo esc_attr($proId) ?>">
									<div class="srwseat_content_add">
										<span class="srwseat_content_add_header"><?php echo esc_html__("Add Type of Seat", "scwasrfw-translate"); ?></span>
										<div class="srwseat_content_add_label">
											<label><?php echo esc_html__("Type Label", "scwasrfw-translate"); ?></label><br>
											<input class="srwseat_content_add_label_input" type='text' />
										</div>
										<div class="srwseat_content_add_color">
											<label><?php echo esc_html__("Type Color", "scwasrfw-translate"); ?></label><br>
											<input class="srwseat_content_add_color_input" type='color' />
										</div>
										<span class="srwseat_content_add_button"><?php echo esc_html__("Add", "scwasrfw-translate"); ?></span>
									</div>
									<div class="srwseat_content_seattype">
										<?php
										$tableSeat = $wpdb->prefix . 'srw_seat_reservation_seat';
										$seats = $wpdb->get_results( "SELECT * FROM $tableSeat where profileID = ".$proId );
										
										if($seats){
											foreach($seats as $keyt=>$seat){
												?>
												<div class="srwseat_content_seattype_item">
													<input type="hidden" value="<?php echo esc_attr($seat->ID) ?>" class="srwseat_content_seattype_item_id">
													<input name="srwseat_content_seattype_item_label<?php echo esc_attr($key.$keyt) ?>" class="srwseat_content_seattype_item_label" type='text' value="<?php echo esc_attr($seat->seatLabel) ?>" />
													<input name="srwseat_content_seattype_item_color<?php echo esc_attr($key.$keyt) ?>" class="srwseat_content_seattype_item_color" type='color' value="<?php echo esc_attr($seat->seatColor) ?>" />
													<span class="srwseat_content_seattype_item_isbooked">
														<label for="srw_is_bookedseat<?php echo esc_attr($key.$keyt) ?>"><?php echo esc_html__("Is Booked Seat?", "scwasrfw-translate"); ?></label>
														<input <?php if($seat->isbooked == "yes") echo "checked='checked'" ?> id="srw_is_bookedseat<?php echo esc_attr($key.$keyt) ?>" name="srw_is_bookedseat<?php echo esc_attr($key) ?>" type="radio" class="srw_is_bookedseat">
													</span>
													<span class="srwseat_content_seattype_item_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
													<span class="srwseat_content_seattype_item_delete"><?php echo esc_html__("Delete", "scwasrfw-translate"); ?></span>
												</div>
												<?php
											}
										}
										?>
									</div>
									<div class="srwseat_content_schedule">
										<span class="srwseat_content_schedule_header"><?php echo esc_html__("Schedules", "scwasrfw-translate"); ?></span>
										<div class="srwseat_content_schedule_content">
											<div class="srwseat_csc_left">
												<div class="srwseat_csc_add">
													<input class="srwseat_csc_add_value">
													<span class="srwseat_csc_add_button"><?php echo esc_html__("Add", "scwasrfw-translate"); ?></span>
												</div>
												<div class="srwseat_csc_schedules">
												<?php
													$tableSchedule = $wpdb->prefix . 'srw_seat_reservation_schedule';
													$schedules = $wpdb->get_results( "SELECT * FROM $tableSchedule where proId = ".$proId );
													
													if($schedules){
														foreach($schedules as $key=>$sche){
															?>
															<div class="srwseat_csc_schedules_item">
																<input class="csc_schedules_item_id" value="<?php echo esc_attr($sche->ID) ?>" type="hidden">
																<input class="csc_schedules_item" name="csc_schedules_item<?php echo esc_attr($key) ?>" value="<?php echo esc_attr($sche->datetime) ?>" type="text">
																<span class="csc_schedules_item_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
																<span class="csc_schedules_item_delete"><?php echo esc_html__("Delete", "scwasrfw-translate"); ?></span>
															</div>
															<?php
														}
													}
												?>											
												</div>
											</div>
											<span class="srwseat_csc_or"><?php echo esc_html__("OR", "scwasrfw-translate"); ?></span>
											<div class="srwseat_csc_dailyschedules">
												<span class="scw_seatschedules_right_head"><?php echo esc_html__("Daily Schedules", "scwasrfw-translate"); ?></span>
												<span class="scw_daily_schedules">
													<?php
														$tableDailySchedules = $wpdb->prefix . 'srw_seat_reservation_dailyschedules';
														$dailies = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$proId );
														$dailies = explode(",", $dailies[0]->daily);
													?>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("monday", $dailies)) echo "checked='checked'" ?> value="monday" type="checkbox" class="scw_daily_schedules_monday" id="scw_daily_schedules_monday">
														<label for="scw_daily_schedules_monday"><?php echo esc_html__("Monday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("tuesday", $dailies)) echo "checked='checked'" ?> value="tuesday" type="checkbox" class="scw_daily_schedules_tuesday" id="scw_daily_schedules_tuesday">
														<label for="scw_daily_schedules_tuesday"><?php echo esc_html__("Tuesday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("wednesday", $dailies)) echo "checked='checked'" ?> value="wednesday" type="checkbox" class="scw_daily_schedules_wednesday" id="scw_daily_schedules_wednesday">
														<label for="scw_daily_schedules_wednesday"><?php echo esc_html__("Wednesday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("thursday", $dailies)) echo "checked='checked'" ?> value="thursday" type="checkbox" class="scw_daily_schedules_thursday" id="scw_daily_schedules_thursday">
														<label for="scw_daily_schedules_thursday"><?php echo esc_html__("Thursday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("friday", $dailies)) echo "checked='checked'" ?> value="friday" type="checkbox" class="scw_daily_schedules_friday" id="scw_daily_schedules_friday">
														<label for="scw_daily_schedules_friday"><?php echo esc_html__("Friday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("saturday", $dailies)) echo "checked='checked'" ?> value="saturday" type="checkbox" class="scw_daily_schedules_saturday" id="scw_daily_schedules_saturday">
														<label for="scw_daily_schedules_saturday"><?php echo esc_html__("Saturday", "scwasrfw-translate"); ?></label>
													</span>
													<span class="scw_daily_schedules_week">
														<input <?php if(in_array("sunday", $dailies)) echo "checked='checked'" ?> value="sunday" type="checkbox" class="scw_daily_schedules_sunday" id="scw_daily_schedules_sunday">
														<label for="scw_daily_schedules_sunday"><?php echo esc_html__("Sunday", "scwasrfw-translate"); ?></label>
													</span>
												</span>
												<span class="scw_daily_schedules_times">
													<span class="scw_daily_schedules_times_add">
														<input class="scw_daily_schedules_times_add_input" placeholder="daily time">
														<span class="scw_daily_schedules_times_add_button"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo esc_html__("ADD", "scwasrfw-translate"); ?></span>
													</span>
													<span class="scw_daily_schedules_times_list">
														<?php
															$tableDailyTimes = $wpdb->prefix . 'srw_seat_reservation_dailytimes';
															$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$proId );
															
															if($times){
																foreach($times as $time){
																	?>
																	<span class="scw_daily_schedules_times_list_item">
																		<input class="scw_daily_schedules_times_list_item_id" type="hidden" value="<?php echo esc_attr($time->id) ?>">
																		<input class="scw_daily_schedules_times_list_item_input" placeholder="daily time" value="<?php echo esc_attr($time->time) ?>">
																		<span class="scw_daily_schedules_times_list_item_button"><i class="fa fa-floppy-o" aria-hidden="true"></i> <?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
																		<span class="scw_daily_schedules_times_list_item_delete"><i class="fa fa-trash-o" aria-hidden="true"></i> <?php echo esc_html__("Delete", "scwasrfw-translate"); ?></span>
																	</span>
																	<?php
																}
															}
														?>
													</span>
												</span>
											</div>
										</div>
									</div>
									<?php
										$tableSeatMap = $wpdb->prefix . 'srw_seat_reservation_map';
										$seatsMap = $wpdb->get_results( "SELECT * FROM $tableSeatMap where profileID = ".$proId );
										if($seatsMap){
											$map = $seatsMap[0];
											$mcl = $map->mapcolumn;
											$mrw = $map->row;
										}else{
											$map = $mcl = $mrw = "";
										}
									?>
									<div class="srwseat_content_seatmap_add">
										<input type="hidden" value="<?php echo esc_attr($map->ID) ?>" class="srwseat_content_seatmap_id">
										<input type="hidden" value="<?php echo esc_attr($map->profileID) ?>" class="srwseat_content_profile_id">
										
										<span class="srwseat_content_seatmap_add_header"><?php echo esc_html__("Seat Mapping", "scwasrfw-translate"); ?></span>
										<div class="srwseat_content_seatmap_add_column">
											<label><?php echo esc_html__("Column Label(for example: Y1,Y2...,Yn)", "scwasrfw-translate"); ?></label><br>
											<input name="srwseat_content_seatmap_add_column_input" value="<?php echo esc_attr($mcl) ?>" class="srwseat_content_seatmap_add_column_input" type='text' />
										</div>
										<div class="srwseat_content_seatmap_add_row">
											<label><?php echo esc_html__("Row Label(for example: X1,X2...,Xn)", "scwasrfw-translate"); ?></label><br>
											<input name="srwseat_content_seatmap_add_row_input" value="<?php echo esc_attr($mrw) ?>" class="srwseat_content_seatmap_add_row_input" type='text' />
										</div>
										<span class="srwseat_content_seatmap_add_button"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
									</div>
									<div class="srwseat_content_seatmap_content">
										<?php
										if($mcl && $mrw){
											$column = explode(",", $mcl);
											$row = explode(",", $mrw);
											
											$width = 100 / count($column);
											
											$tableValueName = $wpdb->prefix . 'srw_seat_reservation_map_value';
											foreach($row as $key=>$r){
												?>
												<div class="srwseat_content_seatmap_content_item">
												<?php
												foreach($column as $keyc=>$col){
													$rs = $wpdb->get_results("SELECT * from $tableValueName where mapcolumn = '".$col."' and row = '".$r."' and mapId = ".$proId);
													if($rs) $rsType = $rs[0]->type;
													else $rsType = "";
													$number = $rs[0]->numberofseat;
													?>
													<span style="width: calc(<?php echo esc_attr($width) ?>% - 1px)"><span><?php echo esc_attr($r.".".$col) ?></span><br>
													<?php if($seats){ ?>
													<select>
														<option value="">-- <?php echo esc_html__("Select Seat Type", "scwasrfw-translate"); ?> --</option>
														<?php
															foreach($seats as $seat){
																?>
																<option <?php if($rsType == $seat->seatLabel) echo "selected='selected'" ?> value="<?php echo esc_attr($seat->seatLabel) ?>"><?php echo esc_attr($seat->seatLabel) ?></option>
																<?php
															}
														?>
													</select><br>
													<input placeholder="<?php echo esc_html__("Seat Label", "scwasrfw-translate"); ?>" name="srwseat_number" value="<?php echo $number ?>">
													<?php } ?>
													</span>
													<?php
												}
												?>
												</div>
												<?php
											}
										}
										?>
									</div>
									<div class="srwseat_content_seatmap_content_save"><?php echo esc_html__("Save Mapping", "scwasrfw-translate"); ?></div>
								</div>
							</article>
						</div>
						<?php
					}
				}
				?>
				</section>
			</div>
		</div>
	</div>
	<?php	
}

add_action( 'add_meta_boxes', 'scwasrfw_add_tab_admin_product', 10, 2 );
function scwasrfw_add_tab_admin_product(){
	global $wp_meta_boxes;
	
	$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwasrfw' ][ 'title' ] = esc_html__("Seat Reservation", "scwasrfw-translate");
	$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwasrfw' ][ 'args' ] = "";
	$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwasrfw' ][ 'id' ] = "scwasrfw";
	$wp_meta_boxes[ 'product' ][ 'normal' ][ 'core' ][ 'scwasrfw' ][ 'callback' ] = "scwasrfw_add_tab_admin_product_display";
}
function scwasrfw_add_tab_admin_product_display() {
	global $wpdb;
	if(is_admin() && isset($_GET['post'])){
		$postId = $_GET['post'];
		
		$tablePostName = $wpdb->prefix . 'posts';
		$checkType = $wpdb->get_results("SELECT post_type from $tablePostName where ID = ".$postId);
		$type = $checkType[0]->post_type;
		
		if($type == "product"){
			wp_register_script('srw-product-script', SMARTCMS_SRW_URL .'js/admin-product.js');
			wp_enqueue_script('srw-product-script');
			wp_register_style('srw-product-css', SMARTCMS_SRW_URL .'css/admin-product.css');
			wp_enqueue_style('srw-product-css');
			
			$tableProfile = $wpdb->prefix . 'srw_seat_reservation_profile';
			$profiles = $wpdb->get_results("SELECT * from $tableProfile");
			
			$tableProducts = $wpdb->prefix . 'srw_seat_reservation_product';
			$profilePro = $wpdb->get_results("SELECT * from $tableProducts where proId = ".$postId);

			?>
			<div class="smartcms_content">
				<input type="hidden" value="<?php echo esc_attr($postId) ?>" class="smartcms_postid">
				<input type="hidden" value="<?php echo SMARTCMS_SRW_URL ?>" class="smartcms_url">
				<div class="smartcms_content_choose">
					<select class="smartcms_content_choose_profile">
						<option value="">-- <?php echo esc_html__("Choose Profile", "scwasrfw-translate"); ?> --</option>
						<?php
						foreach($profiles as $file){
							?><option value="<?php echo esc_attr($file->ID) ?>"><?php echo esc_attr($file->profileName) ?></option><?php
						}
						?>
					</select>
					<span class="smartcms_content_choose_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
				</div>
				<div class="smartcms_content_load">
					<?php
					if($profilePro){
						$fileId = $profilePro[0]->profileID;
						$checkprofiles = $wpdb->get_results("SELECT * from $tableProfile where ID = ".$fileId);
						$profileName = $checkprofiles[0]->profileName;
						
						$seatsTable = $wpdb->prefix . 'srw_seat_reservation_seat';
						$seats = $wpdb->get_results("SELECT * from $seatsTable where profileID = ".$fileId);
						
						$tableSchedule = $wpdb->prefix . 'srw_seat_reservation_schedule';
						$schedules = $wpdb->get_results( "SELECT * FROM $tableSchedule where proId = ".$fileId );
						?>
						<input value="<?php echo esc_attr($fileId) ?>" class="smartcms_profile_id" type="hidden">
						<div class="smartcms_content_header"><?php echo esc_html__("Profile", "scwasrfw-translate"); ?>: <?php echo esc_attr($profileName) ?></div>
						<div class="smartcms_content_seatype">
							<?php
							foreach($seats as $seat){
								$tableProductsValue = $wpdb->prefix . 'srw_seat_reservation_product_value';
								$valuesRs = $wpdb->get_results("SELECT * from $tableProductsValue where proId = ".$postId." and profileID = ".$fileId." and color = '".$seat->seatLabel."'");
								if($valuesRs) $price = $valuesRs[0]->price;
								else $price = "";
								?>
								<span class="smartcms_content_seatype_item">
									<span class="smartcms_content_seatype_item_label"><?php echo esc_attr($seat->seatLabel) ?></span><br>
									<span style="background:<?php echo esc_attr($seat->seatColor) ?>" class="smartcms_content_seatype_item_color"><?php echo esc_attr($seat->seatColor) ?></span><br>
									<input placeholder="Price" value="<?php echo esc_attr($price) ?>">
								</span>
								<?php
							}
							?>
						</div>
						<div class="smartcms_content_seatype_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></div>
						<div class="smartcms_content_schedule">
						<span class="smartcms_content_schedule_header"><?php echo esc_html__("Schedules", "scwasrfw-translate"); ?></span>
						<?php
						if($schedules){
							foreach($schedules as $sche){
								?>
								<div class="smartcms_content_schedule_item"><?php echo esc_attr($sche->datetime) ?></div>
								<?php
							}
						}
						?>
						</div>
						<div class="smartcms_content_mapping">
							<?php
							$mapTable = $wpdb->prefix . 'srw_seat_reservation_map';
							$maps = $wpdb->get_results("SELECT * from $mapTable where profileID = ".$fileId);
							
							$tableSeatMapValue = $wpdb->prefix . 'srw_seat_reservation_map_value';
							
							$columns = explode(",", $maps[0]->mapcolumn);
							$rows = explode(",", $maps[0]->row);
							$mapId = $maps[0]->profileID;
							$width = 100 / count($columns);
							
							////////////
							$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
							$checkOrderRs = $wpdb->get_results("SELECT * from $checkOrderTable where proId = ".$postId);
							
							$checkSeatRs = $wpdb->get_results("SELECT seatColor from $seatsTable where profileID = ".$fileId." and isbooked = 'yes'");
							$bookedColor = $checkSeatRs[0]->seatColor;
						
							foreach($rows as $r){
								?>
								<div class="srwseat_content_seatmap_content_item">
								<?php
								foreach($columns as $keyc=>$col){
									$rs = $wpdb->get_results("SELECT * from $tableSeatMapValue where mapcolumn = '".$col."' and row = '".$r."' and mapId = ".$mapId);
									$type = $rs[0]->type;
									
									$seatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
									$typeRs = $wpdb->get_results("SELECT * from $seatTable where profileID = ".$fileId." and seatLabel = '".$type."'");
									$typeColor = $typeRs[0]->seatColor;
									
									$realColor = $typeColor;
									?>
									<span style="width: calc(<?php echo esc_attr($width) ?>% - 1px)" class="srwseat_content_seatmap_content_item_con">
										<span><?php echo esc_attr($r.".".$col) ?></span><br>
										<span class="srwseat_item_con_color" style="background: <?php echo esc_attr($realColor) ?>"><?php echo esc_attr($realColor) ?></span>
									</span>
									<?php
								}
								?>
								</div>
								<?php
							}
							?>
						</div>
						<div class="smartcms_content_booked">
							<span class="smartcms_content_booked_header"><?php echo esc_html__("Booked Seats Manager", "scwasrfw-translate"); ?></span>
							<?php
							if($checkOrderRs){
								foreach($checkOrderRs as $odt){
									if($odt){
										?>
										<div class="smartcms_content_booked_item_item">
											<input class="smartcms_content_booked_item_id" type="hidden" value="<?php echo esc_attr($odt->ID) ?>">
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->schedule) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->seat) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->name) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->address) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->email) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->phone) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->note) ?></span>
											<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->total) ?></span>
											<span class="smartcms_content_booked_item_remove"><?php echo esc_html__("Remove", "scwasrfw-translate"); ?></span>
										</div>
										<?php
									}
								}
								?>
								<span class="smartcms_content_booked_reset"><?php echo esc_html__("Remove All Booked Seats", "scwasrfw-translate"); ?></span>
								<?php
							}
							?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<?php
		}
	}
}

add_filter( 'woocommerce_cart_item_price', 'cw_change_product_price_display', 10, 3 );
function cw_change_product_price_display( $price, $product ){
	global $wpdb;
	
	$proId = $product["product_id"];
	
	if(isset($_SESSION["seats".$proId])) {
		$seatsSec = $_SESSION["seats".$proId];
	}else{
		$seatsSec = '';
	}
	
	if(isset($_SESSION["schedule".$proId])) {
		$schedule = esc_html__("Schedule", "scwasrfw-translate").": ".$_SESSION["schedule".$proId];
	}else{
		$schedule = "";
	}
	
	$seatsSecF = "";
	$checkSeatsSecF = explode("@", $seatsSec);
	foreach($checkSeatsSecF as $seat){
		$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
		if($schedule)
			$checkOrder = $wpdb->get_results("SELECT * from $checkOrderTable where seat = '".$seat."' and proId = ".$proId." and schedule = '".$schedule."'");
		else
			$checkOrder = $wpdb->get_results("SELECT * from $checkOrderTable where seat = '".$seat."' and proId = ".$proId);
		
		if(!isset($checkOrder[0]->seat)){
			if($seatsSecF)
				$seatsSecF .= "@".$seat;
			else
				$seatsSecF .= $seat;
		}else
			$seatsSecF .= "<br><span style='red'>The seat ".$seat." you choosed are no longer available!</span><br>";
	}
	
	$seatsSecF = str_replace("@", " ", $seatsSecF);
	
	if(isset($_SESSION["seats".$proId]))
		return $price."<br> ".esc_html__("Booked Seats", "scwasrfw-translate").": ".$seatsSecF."<br>".$schedule;
	else
		return $price;
}
add_action( 'woocommerce_before_calculate_totals', 'srw_add_custom_price' );
function srw_add_custom_price( $cart_object ){
	global $wpdb;
	
    foreach( $cart_object->cart_contents as $key => $value ){
		$proId = $value['data']->get_id();
		
		if(isset($_SESSION["seats".$proId])) {
			$seatsSec = $_SESSION["seats".$proId];
		}else{
			$seatsSec = '';
		}
		$seatsSecF = explode("@", $seatsSec);
		if(count($seatsSecF) > 0){
			$newPrice = $value['data']->get_price();
			
			$checkProfileTable = $wpdb->prefix . 'srw_seat_reservation_product';
			$profile = $wpdb->get_results("SELECT * from $checkProfileTable where proId = ".$proId);
			$fileId = $profile[0]->profileID;
			
			$mapTable = $wpdb->prefix . 'srw_seat_reservation_map';
			$maps = $wpdb->get_results("SELECT * from $mapTable where profileID = ".$fileId);
			$mapId = $maps[0]->profileID;
			
			$mapValueTable = $wpdb->prefix . 'srw_seat_reservation_map_value';
			$proValueTable = $wpdb->prefix . 'srw_seat_reservation_product_value';
			
			$checkConfig = $wpdb->prefix . 'srw_seat_reservation_config';
			$profile = $wpdb->get_results("SELECT * from $checkConfig");
			if($profile) $pricewrong = $profile[0]->price; else $pricewrong = "no";
			
			foreach($seatsSecF as $seat){
				$checkSeat = explode(".", $seat);
				if($checkSeat[1]){
					$column = $checkSeat[1];
					$row = $checkSeat[0];
					
					$mapvalues = $wpdb->get_results("SELECT * from $mapValueTable where mapId = ".$mapId." and mapcolumn = '".$column."' and row = '".$row."'");
				}else
					$mapvalues = $wpdb->get_results("SELECT * from $mapValueTable where mapId = ".$mapId." and numberofseat = '".$seat."'");
				
				$type = $mapvalues[0]->type;
				
				$checkPrice = $wpdb->get_results("SELECT * from $proValueTable where proId = ".$proId." and color = '".$type."'");
				if($checkPrice) $price = $checkPrice[0]->price;
				else $price = 0;
				
				if($pricewrong == "yes")
					$newPrice += $price / 2;
				else
					$newPrice += $price;
			}
			$value['data']->set_price( $newPrice );
		}
    }
}

add_action('woocommerce_after_single_product', 'smartcms_srw_fontend_single');
function smartcms_srw_fontend_single(){
	global $product;
	global $wpdb;
	//$proId = $product->id;
	$proId = $product->get_id();
	
	$tableProfile = $wpdb->prefix . 'srw_seat_reservation_product';
	$profile = $wpdb->get_results("SELECT * from $tableProfile where proId = ".$proId);
	
	if($profile){
		$fileId = $profile[0]->profileID;
		
		$tableSeatName = $wpdb->prefix . 'srw_seat_reservation_seat';
		$seats = $wpdb->get_results("SELECT * from $tableSeatName where profileID = ".$fileId);
		
		if(isset($_SESSION["seats".$proId])) {
			$seatsSec = $_SESSION["seats".$proId];
		}else{
			$seatsSec = '';
		}
		$seatsSecF = explode("@", $seatsSec);
		
		wp_register_script('srw-script-datetimepicker', SMARTCMS_SRW_URL .'datetimepicker/jquery.datetimepicker.full.min.js');
		wp_enqueue_script('srw-script-datetimepicker');
		wp_register_style('srw-style-datetimepicker', SMARTCMS_SRW_URL .'datetimepicker/jquery.datetimepicker.css');
		wp_enqueue_style('srw-style-datetimepicker');
		
		wp_register_script('srw-script-frontend', SMARTCMS_SRW_URL .'js/script.js');
		wp_enqueue_script('srw-script-frontend');
		wp_register_style('srw-style-frontend', SMARTCMS_SRW_URL .'css/style.css');
		wp_enqueue_style('srw-style-frontend');
		$currencyS = get_woocommerce_currency_symbol();
		
		$mapTable = $wpdb->prefix . 'srw_seat_reservation_map';
		$maps = $wpdb->get_results("SELECT * from $mapTable where profileID = ".$fileId);
		
		$columns = explode(",", $maps[0]->mapcolumn);
		$rows = explode(",", $maps[0]->row);
		$mapId = $maps[0]->profileID;
		$width = 100 / count($columns);
		
		$tableSeatMapValue = $wpdb->prefix . 'srw_seat_reservation_map_value';
		
		////////////
		$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
		$checkOrderRs = $wpdb->get_results("SELECT seat from $checkOrderTable where proId = ".$proId);
		$checkOrderArr = array();
		if($checkOrderRs){
			foreach($checkOrderRs as $order){
				array_push($checkOrderArr, $order->seat);
			}
		}
		$checkOrderArr = array_unique($checkOrderArr);
		
		$tableType = $wpdb->prefix . 'srw_seat_reservation_seat';
		$selectType = $wpdb->get_results("SELECT * from $tableType where profileID = '".$mapId."' and isbooked = 'yes'");
		$tableMap = $wpdb->prefix . 'srw_seat_reservation_map_value';
		$mapvalues = $wpdb->get_results("SELECT * from $tableMap where mapId = '".$mapId."' and type = '".$selectType[0]->seatLabel ."'");
		foreach($mapvalues as $vl){
			array_push($checkOrderArr, $vl->row .".".$vl->mapcolumn);
		}
		
		//////////////////
		$checkSeatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
		$checkSeatRs = $wpdb->get_results("SELECT seatColor from $checkSeatTable where profileID = ".$fileId." and isbooked = 'yes'");
		$bookedColor = $checkSeatRs[0]->seatColor;
		
		$tableSchedule = $wpdb->prefix . 'srw_seat_reservation_schedule';
		$schedules = $wpdb->get_results("SELECT * from $tableSchedule where proId = ".$fileId);
		////////////////////
		$checkConfig = $wpdb->prefix . 'srw_seat_reservation_config';
		$cf = $wpdb->get_results("SELECT * from $checkConfig");
		if($cf) $compulsory = $cf[0]->compulsory; else $compulsory = 0;
		?>
		<div class="smartcms_content" style="display:none">
			<input class="smartcms_url" value="<?php echo SMARTCMS_SRW_URL ?>" type="hidden">
			<input class="smartcms_proid" value="<?php echo esc_attr($proId) ?>" type="hidden">
			<input class="smartcms_mapid" value="<?php echo esc_attr($mapId) ?>" type="hidden">
			<input class="smartcms_compulsory" value="<?php echo esc_attr($compulsory) ?>" type="hidden">
			<div class="smartcms_content_seats">
				<?php
				foreach($seats as $seat){
					$seatLabel = $seat->seatLabel;
					$seatColor = $seat->seatColor;
					
					$tablePrice = $wpdb->prefix . 'srw_seat_reservation_product_value';
					$price = $wpdb->get_results("SELECT * from $tablePrice where color = '".$seatLabel."' and proId = ".$proId);
					if($price) $price = $price[0]->price;
					else $price = 0;
					
					if($seatLabel != "hallway"){
						?>
						<div class="smartcms_content_seats_item">
							<span class="smartcms_content_seats_item_label"><?php 
								echo esc_attr($seatLabel);
								if($price) echo "(".esc_attr($currencyS.$price).")";
							?></span><br>
							<span style="background:<?php echo esc_attr($seatColor) ?>" class="smartcms_content_seats_item_color"><?php echo esc_attr($seatColor) ?></span>
						</div>
						<?php
					}
				}
				?>
			</div>
			<div class="smartcms_content_schedules">
			<?php
			if($schedules){
				foreach($schedules as $sche){
					$checkSchedule = explode(" ", $sche->datetime);
					?>
					<span class="smartcms_content_schedules_item">
						<input type="hidden" class="smartcms_content_schedules_item_value" value="<?php echo esc_attr($sche->datetime) ?>">
						<span class="smartcms_content_schedules_item_date"><?php echo esc_attr($checkSchedule[0]) ?></span>
						<span class="smartcms_content_schedules_item_time"><?php echo esc_attr($checkSchedule[1]) ?></span>
					</span>
					<?php
				}
			}else{
				$arroDay = array(0, 1, 2, 3, 4, 5, 6);
				$arrDay = array();
				$arrTime = "";
				
				$tableDailySchedules = $wpdb->prefix . 'srw_seat_reservation_dailyschedules';
				$checkDailySchedules = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$fileId );
				$dailies = explode(",", $checkDailySchedules[0]->daily);
				if($dailies){
					foreach($dailies as $dai){
						if($dai == "monday")
							array_push($arrDay, 1);
						elseif($dai == "tuesday")
							array_push($arrDay, 2);
						elseif($dai == "wednesday")
							array_push($arrDay, 3);
						elseif($dai == "thursday")
							array_push($arrDay, 4);
						elseif($dai == "friday")
							array_push($arrDay, 5);
						elseif($dai == "saturday")
							array_push($arrDay, 6);
						elseif($dai == "sunday")
							array_push($arrDay, 0);
					}
				}
				$arrfDay = array_diff($arroDay, $arrDay);
				
				$tableDailyTimes = $wpdb->prefix . 'srw_seat_reservation_dailytimes';
				$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$fileId );
				if($times){
					foreach($times as $time){
						if($arrTime)
							$arrTime .= ",".$time->time;
						else
							$arrTime .= $time->time;
					}
				}
				
				if($dailies[0]){
					?>
					<input class="array_dates" type="hidden" value='<?php echo json_encode($arrfDay, 1) ?>'>
					<input class="array_times" type="hidden" value="<?php echo esc_attr($arrTime) ?>">
					<input id="scw_schedules_picker" type="text" placeholder="Choose a date!">
					<?php
				}
			}
			?>
			</div>
			<div class="smartcms_content_mapping">
				<?php
				foreach($rows as $r){
					?>
					<div class="smartcms_content_mapping_item">
					<?php
					foreach($columns as $keyc=>$col){
						$rs = $wpdb->get_results("SELECT * from $tableSeatMapValue where mapcolumn = '".$col."' and row = '".$r."' and mapId = ".$mapId);
						$type = $rs[0]->type;
						$number = $rs[0]->numberofseat;
						if(!$number) $number = $r.".".$col;
						
						$seatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
						$typeRs = $wpdb->get_results("SELECT * from $seatTable where profileID = ".$fileId." and seatLabel = '".$type."'");
						$typeColor = $typeRs[0]->seatColor;
						
						if(in_array($number, $checkOrderArr))
							$realColor = $bookedColor;
						else
							$realColor = $typeColor;
						?>
						<span id="<?php echo esc_attr(str_replace(".", "", $number)) ?>" style="width: calc(<?php echo esc_attr($width) ?>%)" class="scw<?php echo esc_attr($type) ?> smartcms_content_mapping_item_con <?php if(in_array($number, $checkOrderArr)) echo "disable" ?>">
							<input type="hidden" class="booked_color" value="<?php echo esc_attr($bookedColor) ?>">
							<input type="hidden" class="real_color" value="<?php echo esc_attr($typeColor) ?>">
							<span style="display: none" class="srwseat_item_con_seat"><?php echo esc_attr($number) ?></span>
							<span class="srwseat_item_con_color" style="background: <?php echo esc_attr($realColor) ?>"><?php echo esc_attr($number) ?></span>
						</span>
						<?php
					}
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
}

add_filter( 'woocommerce_order_item_name', 'srw_order_complete' , 10, 2 );
function srw_order_complete( $link, $item ){
	
	global $wpdb;
	$proId = $item["product_id"];
	if(isset($_GET['key'])) {
		$order_key = $_GET['key'];
	}
	if($order_key && $proId){
		if(isset($_SESSION["seats".$proId])) {
			$seatsSec = $_SESSION["seats".$proId];
		}else{
			$seatsSec = '';
		}
		$seatsSecF = explode("@", $seatsSec);
		
		if(isset($_SESSION["schedule".$proId])) {
			$schedule = esc_html__("Schedule", "scwasrfw-translate").": ".$_SESSION["schedule".$proId];
		}else{
			$schedule = "";
		}
		
		$newCheckSeats = "";
		foreach($seatsSecF as $seat){
			if($seat){
				$table_name = $wpdb->prefix . 'srw_seat_reservation_order';
				
				$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
				if($schedule)
					$checkOrder = $wpdb->get_results("SELECT * from $checkOrderTable where seat = '".$seat."' and proId = ".$proId." and schedule = '".$_SESSION["schedule".$proId]."'");
				else
					$checkOrder = $wpdb->get_results("SELECT * from $checkOrderTable where seat = '".$seat."' and proId = ".$proId);
				
				if(!$checkOrder){
					if($newCheckSeats)
						$newCheckSeats .= "@".$seat;
					else
						$newCheckSeats .= $seat;
					$wpdb->insert( $table_name,
						array( 
							'proId' => $proId, 
							'orderId' => $order_key,
							'seat' => $seat,
							'schedule' => $_SESSION["schedule".$proId]
						) 
					);
				}else{
					$newCheckSeats .= "<br><span style='red'>The seat ".$seat." you choosed are no longer available!</span><br>";
				}
			}
		}
		
		if($_SESSION['seats'.$proId])
			$seatsSecFinal = "<br>".esc_html__("Booked Seats", "scwasrfw-translate").": ".str_replace("@", " ", $newCheckSeats)."<br>".$schedule."<br>";
		else
			$seatsSecFinal = "";
		unset($_SESSION['seats'.$proId]);
		unset($_SESSION['schedule'.$proId]);
		
	}else{
		$seatsSecFinal = "";
	}
	
	$allowed_html = ['br' => [], 'span' => []];
	echo wp_kses($link.$seatsSecFinal, $allowed_html);
}

add_action( 'woocommerce_before_order_itemmeta', 'srw_admin_edit_order', 10, 3 );
function srw_admin_edit_order( $item_id, $item, $product ){
	global $wpdb;
	$proId = $product->get_id();
    $postId = $_GET['post'];
	
	$orderKeyTable = $wpdb->prefix . 'postmeta';
	$orderKeyRs = $wpdb->get_results("SELECT * from $orderKeyTable where post_id = ".$postId." and meta_key = '_order_key'");
	$orderKey = $orderKeyRs[0]->meta_value;
	
	$orderSeatTable = $wpdb->prefix . 'srw_seat_reservation_order';
	$orderSeats = $wpdb->get_results("SELECT * from $orderSeatTable where proId = ".$proId." and orderId = '".$orderKey."'");
	if($orderSeats){
		echo "<br>".esc_html__("Booked Seats", "scwasrfw-translate").": ";
		foreach($orderSeats as $seat){
			echo esc_attr($seat->seat) ." ";
		}
		if($orderSeats[0]->schedule){
			echo "<br>".esc_html__("Schedule", "scwasrfw-translate").": ".esc_attr($orderSeats[0]->schedule);
		}
	}
}

////////////////////
add_action( 'widgets_init', 'srw_widgets' );
add_action( 'plugins_loaded', 'srw_load' );

function srw_widgets(){
	register_widget('srw_class');
}
function srw_load(){
    global $mfpd;
    $mfpd = new srw_class();
}
class srw_class extends WP_Widget{
	function __construct(){
		parent::__construct(
			  'srw_id',
			  esc_html__("Scw Seat Reservation", "scwasrfw-translate"),
			  array(
				  'description' => esc_html__("seat reservation for woocommerce product and wordpress post", "scwasrfw-translate")
			  )
		);
		add_action( 'add_meta_boxes', array( $this, 'srw_add_tab_admin_product' ), 10, 2 );
	}
	function srw_add_tab_admin_product($post_type, $post)
	{
		global $wp_meta_boxes;
		
		$wp_meta_boxes[ 'post' ][ 'normal' ][ 'core' ][ 'scwwamrbp' ][ 'title' ] = esc_html__("Scw Seat Reservation", "scwasrfw-translate");
		$wp_meta_boxes[ 'post' ][ 'normal' ][ 'core' ][ 'scwwamrbp' ][ 'id' ] = "scwwamrbp";
		$wp_meta_boxes[ 'post' ][ 'normal' ][ 'core' ][ 'scwwamrbp' ][ 'callback' ] = "scwwamrb_add_tab_admin_product_display";
	}
}
function scwwamrb_add_tab_admin_product_display(){
	global $wpdb;
	$postId = $_GET['post'];
	
	if($postId){
		$tablePostName = $wpdb->prefix . 'posts';
		$checkType = $wpdb->get_results("SELECT post_type from $tablePostName where ID = ".$postId);
		$type = $checkType[0]->post_type;

		wp_register_script('srw-product-script', SMARTCMS_SRW_URL .'js/admin-product.js');
		wp_enqueue_script('srw-product-script');
		wp_register_style('srw-product-css', SMARTCMS_SRW_URL .'css/admin-product.css');
		wp_enqueue_style('srw-product-css');
		
		$tableProfile = $wpdb->prefix . 'srw_seat_reservation_profile';
		$profiles = $wpdb->get_results("SELECT * from $tableProfile");
		
		$tableProducts = $wpdb->prefix . 'srw_seat_reservation_product';
		$profilePro = $wpdb->get_results("SELECT * from $tableProducts where proId = ".$postId);

		?>
		<div class="smartcms_content" style="display:none">
			<input type="hidden" value="<?php echo esc_attr($postId) ?>" class="smartcms_postid">
			<input type="hidden" value="<?php echo SMARTCMS_SRW_URL ?>" class="smartcms_url">
			<div class="smartcms_content_choose">
				<select class="smartcms_content_choose_profile">
					<option value="">-- <?php echo esc_html__("Choose Profile", "scwasrfw-translate"); ?> --</option>
					<?php
					foreach($profiles as $file){
						?><option value="<?php echo esc_attr($file->ID) ?>"><?php echo esc_attr($file->profileName) ?></option><?php
					}
					?>
				</select>
				<span class="smartcms_content_choose_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></span>
			</div>
			<div class="smartcms_content_load">
				<?php
				if($profilePro){
					$fileId = $profilePro[0]->profileID;
					$checkprofiles = $wpdb->get_results("SELECT * from $tableProfile where ID = ".$fileId);
					$profileName = $checkprofiles[0]->profileName;
					
					$seatsTable = $wpdb->prefix . 'srw_seat_reservation_seat';
					$seats = $wpdb->get_results("SELECT * from $seatsTable where profileID = ".$fileId);
					
					$tableSchedule = $wpdb->prefix . 'srw_seat_reservation_schedule';
					$schedules = $wpdb->get_results( "SELECT * FROM $tableSchedule where proId = ".$fileId );
					?>
					<input value="<?php echo esc_attr($fileId) ?>" class="smartcms_profile_id" type="hidden">
					<div class="smartcms_content_header"><?php echo esc_html__("Profile", "scwasrfw-translate"); ?>: <?php echo esc_attr($profileName) ?></div>
					<div class="smartcms_content_seatype">
						<?php
						foreach($seats as $seat){
							$tableProductsValue = $wpdb->prefix . 'srw_seat_reservation_product_value';
							$valuesRs = $wpdb->get_results("SELECT * from $tableProductsValue where proId = ".$postId." and profileID = ".$fileId." and color = '".$seat->seatLabel."'");
							$price = $valuesRs[0]->price;
							?>
							<span class="smartcms_content_seatype_item">
								<span class="smartcms_content_seatype_item_label"><?php echo esc_attr($seat->seatLabel) ?></span><br>
								<span style="background:<?php echo esc_attr($seat->seatColor) ?>" class="smartcms_content_seatype_item_color"><?php echo esc_attr($seat->seatColor) ?></span><br>
								<input placeholder="Price" value="<?php echo esc_attr($price) ?>">
							</span>
							<?php
						}
						?>
					</div>
					<div class="smartcms_content_seatype_save"><?php echo esc_html__("Save", "scwasrfw-translate"); ?></div>
					<div class="smartcms_content_schedule">
					<span class="smartcms_content_schedule_header"><?php echo esc_html__("Schedules", "scwasrfw-translate"); ?></span>
					<?php
					if($schedules){
						foreach($schedules as $sche){
							?>
							<div class="smartcms_content_schedule_item"><?php echo esc_attr($sche->datetime) ?></div>
							<?php
						}
					}
					?>
					</div>
					<div class="smartcms_content_mapping">
						<?php
						$mapTable = $wpdb->prefix . 'srw_seat_reservation_map';
						$maps = $wpdb->get_results("SELECT * from $mapTable where profileID = ".$fileId);
						
						$tableSeatMapValue = $wpdb->prefix . 'srw_seat_reservation_map_value';
						
						$columns = explode(",", $maps[0]->mapcolumn);
						$rows = explode(",", $maps[0]->row);
						$mapId = $maps[0]->profileID;
						$width = 100 / count($columns);
						
						////////////
						$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
						$checkOrderRs = $wpdb->get_results("SELECT * from $checkOrderTable where proId = ".$postId);
						
						$checkSeatRs = $wpdb->get_results("SELECT seatColor from $seatsTable where profileID = ".$fileId." and isbooked = 'yes'");
						$bookedColor = $checkSeatRs[0]->seatColor;
					
						foreach($rows as $r){
							?>
							<div class="srwseat_content_seatmap_content_item">
							<?php
							foreach($columns as $keyc=>$col){
								$rs = $wpdb->get_results("SELECT * from $tableSeatMapValue where mapcolumn = '".$col."' and row = '".$r."' and mapId = ".$mapId);
								$type = $rs[0]->type;
								
								$seatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
								$typeRs = $wpdb->get_results("SELECT * from $seatTable where profileID = ".$fileId." and seatLabel = '".$type."'");
								$typeColor = $typeRs[0]->seatColor;
								
								$realColor = $typeColor;
								?>
								<span style="width: calc(<?php echo esc_attr($width) ?>% - 1px)" class="srwseat_content_seatmap_content_item_con">
									<span><?php echo esc_attr($r.".".$col) ?></span><br>
									<span class="srwseat_item_con_color" style="background: <?php echo esc_attr($realColor) ?>"><?php echo esc_attr($realColor) ?></span>
								</span>
								<?php
							}
							?>
							</div>
							<?php
						}
						?>
					</div>
					<div class="smartcms_content_booked">
						<span class="smartcms_content_booked_header"><?php echo esc_html__("Booked Seats Manager", "scwasrfw-translate"); ?></span>
						<?php
						if($checkOrderRs){
							foreach($checkOrderRs as $odt){
								if($odt){
									?>
									<div class="smartcms_content_booked_item_item">
										<input class="smartcms_content_booked_item_id" type="hidden" value="<?php echo esc_attr($odt->ID) ?>">
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->schedule) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->seat) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->name) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->address) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->email) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->phone) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->note) ?></span>
										<span class="smartcms_content_booked_item_seat"><?php echo esc_attr($odt->total) ?></span>
										<span class="smartcms_content_booked_item_remove"><?php echo esc_html__("Remove", "scwasrfw-translate"); ?></span>
									</div>
									<?php
								}
							}
							?>
							<span class="smartcms_content_booked_reset"><?php echo esc_html__("Remove All Booked Seats", "scwasrfw-translate"); ?></span>
							<?php
						}
						?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
		<?php
	}
}

add_filter( 'the_content', 'scw_content' );
function scw_content($content){
	global $wpdb;
	global $post;
	$proId = $post->ID;
	
	$tableProfile = $wpdb->prefix . 'srw_seat_reservation_product';
	$profile = $wpdb->get_results("SELECT * from $tableProfile where proId = ".$proId);
	if(get_post_type( $proId ) == "post"){
		if($profile && !is_admin()){
			ob_start();
			
			$fileId = $profile[0]->profileID;
			
			$tableSeatName = $wpdb->prefix . 'srw_seat_reservation_seat';
			$seats = $wpdb->get_results("SELECT * from $tableSeatName where profileID = ".$fileId);
			
			if(isset($_SESSION["seats".$proId])) {
				$seatsSec = $_SESSION["seats".$proId];
			}else{
				$seatsSec = '';
			}
			$seatsSecF = explode("@", $seatsSec);
			
			wp_register_script('srw-script-datetimepicker', SMARTCMS_SRW_URL .'datetimepicker/jquery.datetimepicker.full.min.js');
			wp_enqueue_script('srw-script-datetimepicker');
			wp_register_style('srw-style-datetimepicker', SMARTCMS_SRW_URL .'datetimepicker/jquery.datetimepicker.css');
			wp_enqueue_style('srw-style-datetimepicker');
			
			wp_register_script('srw-script-frontend', SMARTCMS_SRW_URL .'js/script.js?v=1.0');
			wp_enqueue_script('srw-script-frontend');
			wp_register_style('srw-style-frontend', SMARTCMS_SRW_URL .'css/style.css?v=1.0');
			wp_enqueue_style('srw-style-frontend');
			$currencyS = "$";
			
			$mapTable = $wpdb->prefix . 'srw_seat_reservation_map';
			$maps = $wpdb->get_results("SELECT * from $mapTable where profileID = ".$fileId);
			
			$columns = explode(",", $maps[0]->mapcolumn);
			$rows = explode(",", $maps[0]->row);
			$mapId = $maps[0]->profileID;
			$width = 100 / count($columns);
			
			$tableSeatMapValue = $wpdb->prefix . 'srw_seat_reservation_map_value';
			
			////////////
			$checkOrderTable = $wpdb->prefix . 'srw_seat_reservation_order';
			$checkOrderRs = $wpdb->get_results("SELECT seat from $checkOrderTable where proId = ".$proId);
			$checkOrderArr = array();
			if($checkOrderRs){
				foreach($checkOrderRs as $order){
					array_push($checkOrderArr, $order->seat);
				}
			}
			$checkOrderArr = array_unique($checkOrderArr);
			
			$tableType = $wpdb->prefix . 'srw_seat_reservation_seat';
			$selectType = $wpdb->get_results("SELECT * from $tableType where profileID = '".$mapId."' and isbooked = 'yes'");
			$tableMap = $wpdb->prefix . 'srw_seat_reservation_map_value';
			$mapvalues = $wpdb->get_results("SELECT * from $tableMap where mapId = '".$mapId."' and type = '".$selectType[0]->seatLabel ."'");
			foreach($mapvalues as $vl){
				array_push($checkOrderArr, $vl->row .".".$vl->mapcolumn);
			}
			
			//////////////////
			$checkSeatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
			$checkSeatRs = $wpdb->get_results("SELECT seatColor from $checkSeatTable where profileID = ".$fileId." and isbooked = 'yes'");
			$bookedColor = $checkSeatRs[0]->seatColor;
			
			$tableSchedule = $wpdb->prefix . 'srw_seat_reservation_schedule';
			$schedules = $wpdb->get_results("SELECT * from $tableSchedule where proId = ".$fileId);
			////////////////////
			?>
			<div class="smartcms_content post" style="display:none">
				<input class="smartcms_url" value="<?php echo SMARTCMS_SRW_URL ?>" type="hidden">
				<input class="smartcms_proid" value="<?php echo esc_attr($proId) ?>" type="hidden">
				<input class="smartcms_mapid" value="<?php echo esc_attr($mapId) ?>" type="hidden">
				<input class="smartcms_posttype" value="<?php echo esc_attr(get_post_type($proId)) ?>" type="hidden">
				<div class="smartcms_content_seats">
					<?php
					foreach($seats as $seat){
						$seatLabel = $seat->seatLabel;
						$seatColor = $seat->seatColor;
						
						$tablePrice = $wpdb->prefix . 'srw_seat_reservation_product_value';
						$price = $wpdb->get_results("SELECT * from $tablePrice where color = '".$seatLabel."' and proId = ".$proId);
						$price = $price[0]->price;
						
						if($seatLabel != "hallway"){
							?>
							<div class="smartcms_content_seats_item">
								<span class="smartcms_content_seats_item_label"><?php 
									echo esc_attr($seatLabel);
									if($price) echo "(".esc_attr($currencyS.$price).")";
								?></span><br>
								<span style="background:<?php echo esc_attr($seatColor) ?>" class="smartcms_content_seats_item_color"><?php echo esc_attr($seatColor) ?></span>
							</div>
							<?php
						}
					}
					?>
				</div>
				<div class="smartcms_content_schedules">
				<?php
				if($schedules){
					foreach($schedules as $sche){
						$checkSchedule = explode(" ", $sche->datetime);
						?>
						<span class="smartcms_content_schedules_item">
							<input type="hidden" class="smartcms_content_schedules_item_value" value="<?php echo esc_attr($sche->datetime) ?>">
							<span class="smartcms_content_schedules_item_date"><?php echo esc_attr($checkSchedule[0]) ?></span>
							<span class="smartcms_content_schedules_item_time"><?php echo esc_attr($checkSchedule[1]) ?></span>
						</span>
						<?php
					}
				}else{
					$arroDay = array(0, 1, 2, 3, 4, 5, 6);
					$arrDay = array();
					$arrTime = "";
					
					$tableDailySchedules = $wpdb->prefix . 'srw_seat_reservation_dailyschedules';
					$checkDailySchedules = $wpdb->get_results( "SELECT * FROM $tableDailySchedules where profileid = ".$fileId );
					$dailies = explode(",", $checkDailySchedules[0]->daily);
					if($dailies){
						foreach($dailies as $dai){
							if($dai == "monday")
								array_push($arrDay, 1);
							elseif($dai == "tuesday")
								array_push($arrDay, 2);
							elseif($dai == "wednesday")
								array_push($arrDay, 3);
							elseif($dai == "thursday")
								array_push($arrDay, 4);
							elseif($dai == "friday")
								array_push($arrDay, 5);
							elseif($dai == "saturday")
								array_push($arrDay, 6);
							elseif($dai == "sunday")
								array_push($arrDay, 0);
						}
					}
					$arrfDay = array_diff($arroDay, $arrDay);
					
					$tableDailyTimes = $wpdb->prefix . 'srw_seat_reservation_dailytimes';
					$times = $wpdb->get_results( "SELECT * FROM $tableDailyTimes where profileid = ".$fileId );
					if($times){
						foreach($times as $time){
							if($arrTime)
								$arrTime .= ",".$time->time;
							else
								$arrTime .= $time->time;
						}
					}
					
					if($dailies[0]){
						?>
						<input class="array_dates" type="hidden" value='<?php echo json_encode($arrfDay, 1) ?>'>
						<input class="array_times" type="hidden" value="<?php echo esc_attr($arrTime) ?>">
						<input id="scw_schedules_picker" type="text" placeholder="Choose a date!">
						<?php
					}
				}
				?>
				</div>
				<div class="smartcms_content_mapping">
					<?php
					foreach($rows as $r){
						?>
						<div class="smartcms_content_mapping_item">
						<?php
						foreach($columns as $keyc=>$col){
							$rs = $wpdb->get_results("SELECT * from $tableSeatMapValue where mapcolumn = '".$col."' and row = '".$r."' and mapId = ".$mapId);
							$type = $rs[0]->type;
							
							$seatTable = $wpdb->prefix . 'srw_seat_reservation_seat';
							$typeRs = $wpdb->get_results("SELECT * from $seatTable where profileID = ".$fileId." and seatLabel = '".$type."'");
							$typeColor = $typeRs[0]->seatColor;
							
							if(in_array($r.".".$col , $checkOrderArr))
								$realColor = $bookedColor;
							else
								$realColor = $typeColor;
							?>
							<span id="<?php echo esc_attr($r.$col) ?>" style="width: calc(<?php echo esc_attr($width) ?>%)" class="scw<?php echo esc_attr($type) ?> smartcms_content_mapping_item_con <?php if(in_array($r.".".$col , $checkOrderArr)) echo "disable" ?>">
								<input type="hidden" class="booked_color" value="<?php echo esc_attr($bookedColor) ?>">
								<input type="hidden" class="real_color" value="<?php echo esc_attr($typeColor) ?>">
								<span style="display: none" class="srwseat_item_con_seat"><?php echo esc_attr($r.".".$col) ?></span>
								<span class="srwseat_item_con_color" style="background: <?php echo esc_attr($realColor) ?>"><?php echo esc_attr($r.".".$col) ?></span>
							</span>
							<?php
						}
						?>
						</div>
						<?php
					}
					?>
				</div>
				<div class="scw_total">
					<span><?php echo esc_html__("Total", "scwasrfw-translate"); ?>: <?php echo esc_attr($currencyS) ?></span>
					<span class="scw_total_value">0</span>
				</div>
				<div class="scw_sendform">
					<div class="scw_form_item scw_form_name">
						<label><?php echo esc_html__("Name", "scwasrfw-translate"); ?></label>
						<input class="scw_form_name_input" type="text">
					</div>
					<div class="scw_form_item scw_form_address">
						<label><?php echo esc_html__("Address", "scwasrfw-translate"); ?></label>
						<input class="scw_form_address_input" type="text">
					</div>
					<div class="scw_form_item scw_form_email">
						<label><?php echo esc_html__("Email", "scwasrfw-translate"); ?></label>
						<input class="scw_form_email_input" type="text">
					</div>
					<div class="scw_form_item scw_form_phone">
						<label><?php echo esc_html__("Phone", "scwasrfw-translate"); ?></label>
						<input class="scw_form_phone_input" type="text">
					</div>
					<div class="scw_form_item scw_form_note">
						<label><?php echo esc_html__("Note", "scwasrfw-translate"); ?></label>
						<textarea class="scw_form_note_input"></textarea>
					</div>
					<div class="scw_form_item"><span class="scw_form_submit"><?php echo esc_html__("Submit", "scwasrfw-translate"); ?></span></div>
				</div>
			</div>
			<?php
			$string = ob_get_contents();
			ob_end_clean();
			$content .= $string;
		}
	}
	return $content;
}

function scw_cart_updated( $removed_cart_item_key, $cart ) {
    $line_item = $cart->removed_cart_contents[ $removed_cart_item_key ];
    $product_id = $line_item[ 'product_id' ];

	if(isset($_SESSION["seats".$product_id])) {
		unset($_SESSION["seats".$product_id]);
	}
};
add_action( 'woocommerce_cart_item_removed', 'scw_cart_updated', 10, 2 );