<?php
/**
 * @package Calendarista
 * @version 15.6.7
/*
Plugin Name: Calendarista
Plugin URI: https://www.calendarista.com
Description: The ultimate booking plug-in. Prepare for greatness!
Version: 15.6.7
Author: Alessandro Zifiglio
Author URI: https://www.typps.com
License: Copyright @Alessandro Zifiglio. All rights reserved. Codecanyon licensing applies.
*/

if(!defined('CALENDARISTA_VERSION')){
	define('CALENDARISTA_VERSION', '15.6.7');
}
if(!defined('CALENDARISTA_ROOT_FOLDER')){
	define('CALENDARISTA_ROOT_FOLDER', dirname( __FILE__ ));
}
if(!defined('CALENDARISTA_ROOT_FILE')){
	define('CALENDARISTA_ROOT_FILE', __FILE__);
}
if(!defined('CALENDARISTA_LANGUAGES_FOLDER')){
	define('CALENDARISTA_LANGUAGES_FOLDER', dirname( plugin_basename( __FILE__ ) ) . '/languages/');
}
if(!defined('CALENDARISTA_PLUGINDIR')){
	define('CALENDARISTA_PLUGINDIR', content_url() . '/plugins/' . basename(dirname( __FILE__ )) . '/'    ) ;
}
if(!defined('CALENDARISTA_STRIPE_SDK')){
	define('CALENDARISTA_STRIPE_SDK', dirname( __FILE__ ) . '/ext/stripe/lib/');
}
if(!defined('CALENDARISTA_MUSTACHE')){
	define('CALENDARISTA_MUSTACHE', dirname( __FILE__ ) . '/ext/mustache/src/Mustache/');
}
if(!defined('CALENDARISTA_PLUGIN_UPDATE_CHECKER')){
	define('CALENDARISTA_PLUGIN_UPDATE_CHECKER', dirname( __FILE__ ) . '/ext/plugin-update-checker-4.2/plugin-update-checker.php');
}
if(!defined('CALENDARISTA_TWILIO')){
	define('CALENDARISTA_TWILIO', dirname( __FILE__ ) . '/ext/twilio-lib/src/Twilio/autoload.php');
}
if(!defined('CALENDARISTA_TWILIO_CERT')){
	define('CALENDARISTA_TWILIO_CERT', dirname( __FILE__ ) . '/ext/twilio-lib/src/Twilio/update_certs.php');
}
if(!defined('CALENDARISTA_GCAL')){
	define('CALENDARISTA_GCAL', dirname( __FILE__ ) . '/ext/google-api-php-client-master/');
}
if(!defined('CALENDARISTA_RELATIVE_PATH_TO_PLUGIN')){
	define('CALENDARISTA_RELATIVE_PATH_TO_PLUGIN', basename(dirname( __FILE__ )) . '/Calendarista.php');
}
if(!defined('CALENDARISTA_RELATIVE_PATH_TO_DOCUMENTATION')){
	define('CALENDARISTA_RELATIVE_PATH_TO_DOCUMENTATION', plugins_url() . '/' . basename(dirname( __FILE__ )) . '/CALENDARISTA-README.pdf');
}
if(!defined('CALENDARISTA_ABSOLUTE_PATH_TO_DOCUMENTATION')){
	define('CALENDARISTA_ABSOLUTE_PATH_TO_DOCUMENTATION', 'https://drive.google.com/file/d/1O0G8VSizIs6u7-RzZmzG3VO1qPPTixAP/view');
}
if(!defined('CALENDARISTA_ABSOLUTE_PATH_TO_PLUGIN')){
	define('CALENDARISTA_ABSOLUTE_PATH_TO_PLUGIN', __FILE__);
}
if(!defined('CALENDARISTA_PLUGIN_SLUG')){
	define('CALENDARISTA_PLUGIN_SLUG', basename(dirname( __FILE__ )));
}
if(!defined('CALENDARISTA_RESTRICTED_MODE')){
	define('CALENDARISTA_RESTRICTED_MODE',  false);
}
if(!defined('CALENDARISTA_DATEFORMAT')){
	define('CALENDARISTA_DATEFORMAT', 'Y-m-d');
}
if(!defined('CALENDARISTA_FULL_DATEFORMAT')){
	define('CALENDARISTA_FULL_DATEFORMAT', 'Y-m-d H:i');
}
if(!defined('CALENDARISTA_LONG_DATEFORMAT')){
	define('CALENDARISTA_LONG_DATEFORMAT', 'F j, Y, g:i a');
}
if(!defined('CALENDARISTA_META_KEY_NAME')){
	define('CALENDARISTA_META_KEY_NAME', 'calendarista_page_type');
}
/*if(!defined('CALENDARISTA_ACTIVATION_NOREDIRECT')){
	define('CALENDARISTA_ACTIVATION_NOREDIRECT', true);
}*/
require_once dirname(__FILE__) . '/lib/Initialize.php';
new Calendarista_Initialize();
?>