<?php
class Calendarista_EmailSettingsController extends Calendarista_BaseController
{
	private $repo;
	private $mustacheEngine;
	private $emailSetting;
	public function __construct($updateCallback = null, $deleteCallback = null){
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_emailsettings')){
				return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		if(!class_exists('Mustache_Engine')){
			require_once CALENDARISTA_MUSTACHE . 'Autoloader.php';
			Mustache_Autoloader::register();
		}
		$this->mustacheEngine = new Mustache_Engine();
		$this->emailSetting = new Calendarista_EmailSetting($_POST);
		$this->repo = new Calendarista_EmailSettingRepository($this->emailSetting->emailType);
		parent::__construct(null, $updateCallback, $deleteCallback);
		if(array_key_exists('calendarista_updatesetting', $_POST)){
			$this->updateGeneralSetting($updateCallback);
		}
	}
	
	public function update($callback){
		$errorMessage = false;
		$result = false;
		try{
			$this->mustacheEngine->render($this->emailSetting->subject, array());
		} catch (Exception $e) {
			$errorMessage = $e->getMessage();
		}
		if(!$errorMessage){
			try{
				$this->mustacheEngine->render($this->emailSetting->content, array());
			} catch (Exception $e) {
				$errorMessage = $e->getMessage();
			} 
		}
		if(!$errorMessage){
			if($this->emailSetting->id === -1){
				$result = $this->repo->insert($this->emailSetting);
			}else{
				$result = $this->repo->update($this->emailSetting);
			}
		}
		$this->executeCallback($callback, array($result, $errorMessage));
	}
	
	public function delete($callback){
		$emailSetting = $this->repo->read();
		$result = false;
		if($emailSetting){
			$result = $this->repo->delete($emailSetting->id);
		}
		$this->executeCallback($callback, array($result));
	}
	
	public function updateGeneralSetting($callback){
		$repo = new Calendarista_GeneralSettingsRepository();
		$result = null;
		$generalSettings = $repo->read();
		$generalSettings->emailSenderName = (string)$this->getPostValue('emailSenderName');
		$generalSettings->senderEmail = (string)$this->getPostValue('senderEmail');
		$generalSettings->utf8EncodeEmailSubject = (bool)$this->getPostValue('utf8EncodeEmailSubject');
		$generalSettings->smtpHostName = (string)$this->getPostValue('smtpHostName');
		$generalSettings->smtpUserName = (string)$this->getPostValue('smtpUserName');
		$generalSettings->smtpPassword = (string)$this->getPostValue('smtpPassword');
		$generalSettings->smtpPortNumber = (string)$this->getPostValue('smtpPortNumber');
		$generalSettings->smtpSecure = (string)$this->getPostValue('smtpSecure');
		$generalSettings->smtpAuthenticate = filter_var($this->getPostValue('smtpAuthenticate'), FILTER_VALIDATE_BOOLEAN);
		$generalSettings->adminNotificationEmail = (string)$this->getPostValue('adminNotificationEmail');
		$generalSettings->emailTemplateHeaderImage = (string)$this->getPostValue('emailTemplateHeaderImage');
		$generalSettings->emailTemplateHeaderTitle = (string)$this->getPostValue('emailTemplateHeaderTitle');
		$generalSettings->emailTemplateHeaderBackground = (string)$this->getPostValue('emailTemplateHeaderBackground');
		$generalSettings->emailTemplateHeaderColor = (string)$this->getPostValue('emailTemplateHeaderColor');
		$generalSettings->emailTemplateBodyColor = (string)$this->getPostValue('emailTemplateBodyColor');
		if($generalSettings->id === -1){
			$result = $repo->insert($generalSettings);
		}else{
			$result = $repo->update($generalSettings);
		}
		$this->executeCallback($callback, array($result, null));
	}
	
}
?>