<?php
class Calendarista_FeedController extends Calendarista_BaseController{
	private $feedsRepo;
	private $bookedAvailabilityRepo;
	public function __construct($createCallback, $updateCallback, $deleteCallback, $deleteAllImportedFeeds, $deleteManyCallback){
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_feeds')){
			return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		$this->feedsRepo = new Calendarista_FeedsRepository();
		$this->bookedAvailabilityRepo = new Calendarista_BookedAvailabilityRepository();
		parent::__construct($createCallback, $updateCallback, $deleteCallback);
		if(array_key_exists('calendarista_delete_many', $_POST)){
			$this->deleteMany($deleteManyCallback);
		}else if(array_key_exists('calendarista_delete_many_sync_data', $_POST)){
			$this->deleteManySyncData($deleteManyCallback);
		}else if(array_key_exists('calendarista_delete_sync_data', $_POST)){
			$this->deleteSyncData($deleteCallback);
		}else if(array_key_exists('calendarista_delete_all_imported', $_POST)){
			$this->deleteAllImportedFeeds($deleteAllImportedFeeds);
		}
	}
	public function create($callback){
		$projectId = (int)$this->getPostValue('projectId');
		$_availabilityId = (int)$this->getPostValue('availabilityId');
		$feedUrl = trim($this->getPostValue('feedUrl'));
		$availabilityRepo = new Calendarista_AvailabilityRepository();
		$result = false;
		$availabilityList = array();
		if($_availabilityId === -1){
			$availabilities = $availabilityRepo->readAll($projectId);
			foreach($availabilities as $_availability){
				array_push($availabilityList, $_availability->id);
			}
		}else{
			array_push($availabilityList, $_availabilityId);
		}
		foreach($availabilityList as $availabilityId){
			if(!$this->feedExists($projectId, $availabilityId, $feedUrl)){
				$project = Calendarista_ProjectHelper::getProject($projectId);
				$availability = $availabilityRepo->read($availabilityId);
				$result = $this->feedsRepo->insert(array(
					'projectId'=>$projectId
					, 'availabilityId'=>$availabilityId === -1 ? null : $availabilityId
					, 'projectName'=>$project->name
					, 'availabilityName'=>$availability ? $availability->name : null
					, 'feedUrl'=>$feedUrl
				));
				$result = true;
			}
		}
		$this->executeCallback($callback, array($result));
	}
	protected function feedExists($projectId, $availabilityId, $feedUrl){
		$result = null;
		if($availabilityId !== -1){
			$result = $this->feedsRepo->readByAvailability($availabilityId);
		}else{
			$result = $this->feedsRepo->readByProject($projectId);
		}
		if($result){
			foreach($result as $feed){
				if($feed['feedUrl'] == $feedUrl){
					return true;
				}
			}
		}
		return false;
	}
	public function update($callback){
		$repo = new Calendarista_GeneralSettingsRepository();
		$generalSetting = $repo->read();
		//cancel any previous schedules and begin fresh
		Calendarista_FeedSynchJob::cancelAllSchedules();
		$cronJobFeedTimeout = isset($_POST['cronJobFeedTimeout']) ? $_POST['cronJobFeedTimeout'] : 0;
		$generalSetting->cronJobFeedTimeout = $cronJobFeedTimeout;
		if($generalSetting->id === -1){
			$repo->insert($generalSetting);
		}else{
			$repo->update($generalSetting);
		}
		$this->executeCallback($callback, array($cronJobFeedTimeout));
	}
	public function delete($callback, $eliminateSyncData = false){
		$id = (int)$this->getPostValue('calendarista_delete');
		if($eliminateSyncData){
			$id = (int)$this->getPostValue('calendarista_delete_sync_data');
			$this->eliminateSyncData($id);
		}
		$result = $this->feedsRepo->delete($id);
		$this->executeCallback($callback, array($id, $result));
	}
	public function deleteMany($callback, $eliminateSyncData = false){
		$val = isset($_POST['feeds']) ? (array)$_POST['feeds'] : null;
		if($val){
			$feeds = array_map('intval', $val);
			$bookedAvailabilityRepo = new Calendarista_BookedAvailabilityRepository();
			foreach($feeds as $id){
				if($eliminateSyncData){
					$this->eliminateSyncData($id);
				}
				$this->feedsRepo->delete($id);
			}
		}
		$this->executeCallback($callback, array());
	}
	public function deleteAllImportedFeeds($callback){
		$bookedAvailabilityRepo = new Calendarista_BookedAvailabilityRepository();
		$result = $bookedAvailabilityRepo->deleteAllImportedFeeds();
		$this->executeCallback($callback, array($result));
	}
	public function deleteManySyncData($callback){
		$this->deleteMany($callback, true);
	}
	public function deleteSyncData($callback){
		$this->delete($callback, true);
	}
	protected function eliminateSyncData($id){
		$projectId = (int)$this->getPostValue('projectId_' . $id);
		$availabilityId = (int)$this->getPostValue('availabilityId_' . $id);
		$this->bookedAvailabilityRepo->deleteSyncedDataByAvailability($availabilityId);
	}
}
?>