<?php
class Calendarista_GcalController extends Calendarista_BaseController{
	private $gcalRepo;
	private $bookedAvailabilityRepo;
	private $id;
	private $userId;
	private $code;
	public function __construct($createCallback, $deleteCallback, $deleteManyCallback, $deletedWithSyncDataCallback, $syncCallback){
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_gcal')){
			return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		$this->gcalRepo = new Calendarista_GcalRepository();
		parent::__construct($createCallback, null, $deleteCallback);
		if(array_key_exists('calendarista_delete_many', $_POST)){
			$this->deleteMany($deleteManyCallback);
		}else if(array_key_exists('calendarista_delete_with_data', $_POST)){
			$this->deletedWithSyncData($deletedWithSyncDataCallback);
		}else if(array_key_exists('calendarista_sync', $_POST)){
			$this->sync($syncCallback);
		}
	}
	public function create($callback){
		$gcalProfileId = $this->getPostValue('gcalProfileId');
		$calendarId = $this->getPostValue('calendarId');
		$calendarName = $this->getPostValue('calendarName');
		$projectId = (int)$this->getPostValue('projectId');
		$projectName = $this->getPostValue('projectName');
		$availabilityId = (int)$this->getPostValue('availabilityId');
		$availabilityName = $this->getPostValue('availabilityName');
		$result = false;
		$duplicate = $this->gcalRepo->exists(array(
			'gcalProfileId'=>$gcalProfileId
			, 'calendarId'=>$calendarId
			, 'availabilityId'=>$availabilityId
		));
		if(!$duplicate){
			$result = $this->gcalRepo->insert(array(
				'gcalProfileId'=>$gcalProfileId
				, 'calendarId'=>$calendarId
				, 'calendarName'=>$calendarName
				, 'projectId'=>$projectId
				, 'projectName'=>$projectName
				, 'availabilityId'=>$availabilityId
				, 'availabilityName'=>$availabilityName
			));
		}
		$this->executeCallback($callback, array($result));
	}
	public function update($callback){
		$this->executeCallback($callback, array(null));
	}
	public function delete($deleteCallback){
		$id = (int)$this->getPostValue('calendarista_delete');
		$availabilityId = (int)$this->getPostValue('availabilityId');
		$result = $this->gcalRepo->delete($id);
		$this->executeCallback($deleteCallback, array($result));
	}
	public function deletedWithSyncData($deleteCallback){
		$gcalId = (int)$this->getPostValue('calendarista_delete_with_data');
		$availabilityId = (int)$this->getPostValue('availabilityId');
		$bookedAvailabilityRepo = new Calendarista_BookedAvailabilityRepository();
		$this->gcalRepo->deleteByGcalProfileIdAndAvailability($gcalId, $availabilityId);
		$result = array('imported'=>0, 'exported'=>0);
		$result['imported'] = $bookedAvailabilityRepo->deleteImportedDataByAvailability($availabilityId, $gcalId);
		$result['exported'] = Calendarista_GoogleCalendarHelper::deleteExportedByAvailability($availabilityId, $gcalId);
		$this->executeCallback($deleteCallback, array($result));
	}
	public function deleteMany($callback){
		$val = isset($_POST['id']) ? (array)$_POST['id'] : null;
		if($val){
			$ids = array_map('intval', $val);
			$availabilityId = (int)$this->getPostValue('availabilityId');
			foreach($ids as $id){
				$this->gcalRepo->delete($id);
			}
		}
		$this->executeCallback($callback, array(count($ids)));
	}
	public function sync($callback){
		$id = (int)$this->getPostValue('calendarista_sync');
		$gcal = $this->gcalRepo->read($id); 
		$result = Calendarista_GoogleCalendarHelper::syncByGCal($gcal['gcalProfileId'], $id);
		$this->executeCallback($callback, array($result));
	}
	protected function userHasProfile($userId){
		$profile = $this->gcalRepo->readByUserId($userId);
		return $profile !== false;
	}
}
?>